/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.firebird.packet.command.query.blob;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.nio.charset.Charset;
import lombok.Generated;
import org.apache.shardingsphere.database.protocol.firebird.payload.FirebirdPacketPayload;

public final class FirebirdBlobRegistry {
    private static byte[] segment;

    public static void clearSegment() {
        segment = null;
    }

    public static FirebirdPacketPayload buildSegmentPayload(ByteBufAllocator alloc, Charset cs) {
        if (segment == null) {
            return null;
        }
        int len = segment.length;
        int pad = 4 - len % 4 & 3;
        ByteBuf buf = alloc.buffer(4 + len + pad);
        buf.writeInt(len);
        buf.writeBytes(segment);
        if (pad > 0) {
            buf.writeZero(pad);
        }
        return new FirebirdPacketPayload(buf, cs);
    }

    @Generated
    private FirebirdBlobRegistry() {
    }

    @Generated
    public static byte[] getSegment() {
        return segment;
    }

    @Generated
    public static void setSegment(byte[] segment) {
        FirebirdBlobRegistry.segment = segment;
    }
}

