/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.firebird.packet.command.query.blob;

import io.netty.buffer.ByteBuf;
import lombok.Generated;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.FirebirdCommandPacket;
import org.apache.shardingsphere.database.protocol.firebird.payload.FirebirdPacketPayload;

public final class FirebirdGetBlobSegmentCommandPacket
extends FirebirdCommandPacket {
    private final int blobHandle;
    private final int segmentLength;
    private final byte[] segment;

    public FirebirdGetBlobSegmentCommandPacket(FirebirdPacketPayload payload) {
        payload.skipReserved(4);
        this.blobHandle = payload.readInt4();
        this.segmentLength = payload.readInt4();
        ByteBuf buffer = payload.readBuffer();
        this.segment = new byte[buffer.readableBytes()];
        buffer.readBytes(this.segment);
    }

    @Override
    protected void write(FirebirdPacketPayload payload) {
    }

    public static int getLength(FirebirdPacketPayload payload) {
        int length = 12;
        length += payload.getBufferLength(length);
        return length;
    }

    @Generated
    public int getBlobHandle() {
        return this.blobHandle;
    }

    @Generated
    public int getSegmentLength() {
        return this.segmentLength;
    }

    @Generated
    public byte[] getSegment() {
        return this.segment;
    }
}

