/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.firebird.packet.command.query.blob;

import lombok.Generated;
import org.apache.shardingsphere.database.protocol.firebird.packet.FirebirdPacket;
import org.apache.shardingsphere.database.protocol.firebird.payload.FirebirdPacketPayload;

public final class FirebirdGetBlobSegmentResponsePacket
extends FirebirdPacket {
    private final byte[] segment;

    @Override
    protected void write(FirebirdPacketPayload payload) {
        int segmentLength = this.segment.length;
        payload.writeInt2LE(segmentLength);
        if (segmentLength > 0) {
            payload.writeBytes(this.segment);
            int pad = 4 - segmentLength % 4 & 3;
            if (pad > 0) {
                payload.getByteBuf().writeZero(pad);
            }
        }
    }

    @Generated
    public FirebirdGetBlobSegmentResponsePacket(byte[] segment) {
        this.segment = segment;
    }
}

