/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.firebird.packet.command.query.info;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntFunction;
import lombok.Generated;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.FirebirdCommandPacket;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.info.FirebirdInfoPacketType;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.info.type.common.FirebirdCommonInfoPacketType;
import org.apache.shardingsphere.database.protocol.firebird.payload.FirebirdPacketPayload;

public final class FirebirdInfoPacket
extends FirebirdCommandPacket {
    private final int handle;
    private final int incarnation;
    private final List<FirebirdInfoPacketType> infoItems = new ArrayList<FirebirdInfoPacketType>();
    private final int maxLength;

    public FirebirdInfoPacket(FirebirdPacketPayload payload, IntFunction<FirebirdInfoPacketType> valueOf) {
        payload.skipReserved(4);
        this.handle = payload.readInt4();
        this.incarnation = payload.readInt4();
        this.parseInfo(payload.readBuffer(), valueOf);
        this.maxLength = payload.readInt4();
    }

    private void parseInfo(ByteBuf buffer, IntFunction<FirebirdInfoPacketType> valueOf) {
        while (buffer.isReadable()) {
            byte code = buffer.readByte();
            FirebirdInfoPacketType type = valueOf.apply(code);
            if (null != type) {
                this.infoItems.add(type);
                continue;
            }
            this.infoItems.add(FirebirdCommonInfoPacketType.valueOf(code));
        }
    }

    @Override
    protected void write(FirebirdPacketPayload payload) {
    }

    public static int getLength(FirebirdPacketPayload payload) {
        int length = 12;
        length += payload.getBufferLength(length);
        return length + 4;
    }

    @Generated
    public FirebirdInfoPacket(int handle, int incarnation, int maxLength) {
        this.handle = handle;
        this.incarnation = incarnation;
        this.maxLength = maxLength;
    }

    @Generated
    public int getHandle() {
        return this.handle;
    }

    @Generated
    public int getIncarnation() {
        return this.incarnation;
    }

    @Generated
    public List<FirebirdInfoPacketType> getInfoItems() {
        return this.infoItems;
    }

    @Generated
    public int getMaxLength() {
        return this.maxLength;
    }
}

