/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.firebird.payload;

import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import lombok.Generated;
import org.apache.shardingsphere.database.protocol.payload.PacketPayload;

public final class FirebirdPacketPayload
implements PacketPayload {
    private final ByteBuf byteBuf;
    private final Charset charset;

    public int readInt1Unsigned() {
        return this.byteBuf.readUnsignedByte();
    }

    public int readInt1() {
        return this.byteBuf.readByte();
    }

    public void writeInt1(int value) {
        this.byteBuf.writeByte(value);
    }

    public int readInt2() {
        return this.byteBuf.readUnsignedShort();
    }

    public void writeInt2(int value) {
        this.byteBuf.writeShort(value);
    }

    public int readInt2LE() {
        return this.byteBuf.readUnsignedShortLE();
    }

    public void writeInt2LE(int value) {
        this.byteBuf.writeShortLE(value);
    }

    public int readInt4() {
        return this.byteBuf.readInt();
    }

    public long readInt4Unsigned() {
        return this.byteBuf.readUnsignedInt();
    }

    public void writeInt4(int value) {
        this.byteBuf.writeInt(value);
    }

    public void writeInt4LE(int value) {
        this.byteBuf.writeIntLE(value);
    }

    public long readInt8() {
        return this.byteBuf.readLong();
    }

    public void writeInt8(long value) {
        this.byteBuf.writeLong(value);
    }

    public ByteBuf readBytes(int count) {
        return this.byteBuf.readSlice(count);
    }

    public void writeBytes(byte[] value) {
        this.byteBuf.writeBytes(value);
    }

    public ByteBuf readBuffer() {
        int length = this.byteBuf.readInt();
        ByteBuf buffer = this.byteBuf.readSlice(length);
        this.skipPadding(length);
        return buffer;
    }

    public void writeBuffer(byte[] value) {
        this.byteBuf.writeInt(value.length);
        this.byteBuf.writeBytes(value);
        this.byteBuf.writeBytes(new byte[4 - value.length & 3]);
    }

    public void writeBuffer(ByteBuf buffer) {
        this.byteBuf.writeInt(buffer.writerIndex());
        this.byteBuf.writeBytes(buffer);
        this.byteBuf.writeBytes(new byte[4 - buffer.writerIndex() & 3]);
    }

    public String readString() {
        return this.readBuffer().toString(this.charset);
    }

    public void writeString(String value) {
        this.writeBuffer(value.getBytes(this.charset));
    }

    public void skipReserved(int length) {
        this.byteBuf.skipBytes(length);
    }

    public void skipPadding(int length) {
        this.byteBuf.skipBytes(this.getPadding(length));
    }

    public int getPadding(int length) {
        return 4 - length & 3;
    }

    public int getBufferLength(int index) {
        int length = this.byteBuf.getInt(index) + 4;
        return length + this.getPadding(length);
    }

    @Generated
    public FirebirdPacketPayload(ByteBuf byteBuf, Charset charset) {
        this.byteBuf = byteBuf;
        this.charset = charset;
    }

    @Generated
    public ByteBuf getByteBuf() {
        return this.byteBuf;
    }

    @Generated
    public Charset getCharset() {
        return this.charset;
    }
}

