/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.route.engine.tableless;

import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.type.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.exception.generic.NoTablelessRouteInfoException;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.route.engine.tableless.DialectDALStatementBroadcastRouteDecider;
import org.apache.shardingsphere.infra.route.engine.tableless.TablelessRouteEngine;
import org.apache.shardingsphere.infra.route.engine.tableless.type.broadcast.TablelessDataSourceBroadcastRouteEngine;
import org.apache.shardingsphere.infra.route.engine.tableless.type.broadcast.TablelessInstanceBroadcastRouteEngine;
import org.apache.shardingsphere.infra.route.engine.tableless.type.unicast.TablelessDataSourceUnicastRouteEngine;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.attribute.type.CursorSQLStatementAttribute;
import org.apache.shardingsphere.sql.parser.statement.core.statement.attribute.type.TablelessDataSourceBroadcastRouteSQLStatementAttribute;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dal.DALStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dal.SetStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.CloseStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.DDLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.function.AlterFunctionStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.function.CreateFunctionStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.function.DropFunctionStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.schema.AlterSchemaStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.schema.CreateSchemaStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.schema.DropSchemaStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.tablespace.AlterTablespaceStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.tablespace.CreateTablespaceStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.tablespace.DropTablespaceStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.DMLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.tcl.TCLStatement;

public final class TablelessRouteEngineFactory {
    public static TablelessRouteEngine newInstance(QueryContext queryContext, ShardingSphereDatabase database) {
        SQLStatement sqlStatement = queryContext.getSqlStatementContext().getSqlStatement();
        if (sqlStatement instanceof DMLStatement) {
            return TablelessRouteEngineFactory.getDMLRouteEngine(queryContext.getSqlStatementContext());
        }
        if (sqlStatement instanceof DDLStatement) {
            return TablelessRouteEngineFactory.getDDLRouteEngine(queryContext.getSqlStatementContext(), database);
        }
        if (sqlStatement instanceof DALStatement) {
            return TablelessRouteEngineFactory.getDALRouteEngine((DALStatement)sqlStatement, database);
        }
        if (sqlStatement instanceof TCLStatement) {
            return new TablelessDataSourceBroadcastRouteEngine();
        }
        throw new NoTablelessRouteInfoException();
    }

    private static TablelessRouteEngine getDMLRouteEngine(SQLStatementContext sqlStatementContext) {
        if (sqlStatementContext instanceof SelectStatementContext) {
            return new TablelessDataSourceUnicastRouteEngine();
        }
        throw new NoTablelessRouteInfoException();
    }

    private static TablelessRouteEngine getDDLRouteEngine(SQLStatementContext sqlStatementContext, ShardingSphereDatabase database) {
        if (sqlStatementContext.getSqlStatement().getAttributes().findAttribute(CursorSQLStatementAttribute.class).isPresent()) {
            return TablelessRouteEngineFactory.getCursorRouteEngine(sqlStatementContext.getSqlStatement(), database);
        }
        SQLStatement sqlStatement = sqlStatementContext.getSqlStatement();
        if (TablelessRouteEngineFactory.isFunctionDDLStatement(sqlStatement) || TablelessRouteEngineFactory.isSchemaDDLStatement(sqlStatement)) {
            return new TablelessDataSourceBroadcastRouteEngine();
        }
        throw new NoTablelessRouteInfoException();
    }

    private static TablelessRouteEngine getCursorRouteEngine(SQLStatement sqlStatement, ShardingSphereDatabase database) {
        if (sqlStatement instanceof CloseStatement && ((CloseStatement)sqlStatement).isCloseAll()) {
            return new TablelessDataSourceBroadcastRouteEngine();
        }
        if (sqlStatement instanceof CreateTablespaceStatement || sqlStatement instanceof AlterTablespaceStatement || sqlStatement instanceof DropTablespaceStatement) {
            return new TablelessInstanceBroadcastRouteEngine(database);
        }
        throw new NoTablelessRouteInfoException();
    }

    private static boolean isFunctionDDLStatement(SQLStatement sqlStatement) {
        return sqlStatement instanceof CreateFunctionStatement || sqlStatement instanceof AlterFunctionStatement || sqlStatement instanceof DropFunctionStatement;
    }

    private static boolean isSchemaDDLStatement(SQLStatement sqlStatement) {
        return sqlStatement instanceof CreateSchemaStatement || sqlStatement instanceof AlterSchemaStatement || sqlStatement instanceof DropSchemaStatement;
    }

    private static TablelessRouteEngine getDALRouteEngine(DALStatement sqlStatement, ShardingSphereDatabase database) {
        if (sqlStatement instanceof SetStatement || sqlStatement.getAttributes().findAttribute(TablelessDataSourceBroadcastRouteSQLStatementAttribute.class).isPresent()) {
            return new TablelessDataSourceBroadcastRouteEngine();
        }
        Optional dialectDALStatementBroadcastRouteDecider = DatabaseTypedSPILoader.findService(DialectDALStatementBroadcastRouteDecider.class, (DatabaseType)sqlStatement.getDatabaseType());
        if (dialectDALStatementBroadcastRouteDecider.map(optional -> optional.isDataSourceBroadcastRoute(sqlStatement)).orElse(false).booleanValue()) {
            return new TablelessDataSourceBroadcastRouteEngine();
        }
        if (dialectDALStatementBroadcastRouteDecider.map(optional -> optional.isInstanceBroadcastRoute(sqlStatement)).orElse(false).booleanValue()) {
            return new TablelessInstanceBroadcastRouteEngine(database);
        }
        throw new NoTablelessRouteInfoException();
    }

    @Generated
    private TablelessRouteEngineFactory() {
    }
}

