/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.consistencycheck.table;

import java.util.Collection;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.result.TableInventoryCheckCalculatedResult;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.table.MatchingTableInventoryChecker;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.table.TableDataConsistencyChecker;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.table.TableInventoryCheckParameter;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.table.TableInventoryChecker;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.table.calculator.CRC32TableInventoryCheckCalculator;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.query.calculator.TableInventoryCalculator;
import org.apache.shardingsphere.data.pipeline.core.util.DatabaseTypeUtils;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.infra.spi.annotation.SPIDescription;

@SPIDescription(value="Match CRC32 of records.")
public final class CRC32MatchTableDataConsistencyChecker
implements TableDataConsistencyChecker {
    @Override
    public TableInventoryChecker buildTableInventoryChecker(TableInventoryCheckParameter param) {
        return new CRC32MatchTableInventoryChecker(param);
    }

    public Collection<DatabaseType> getSupportedDatabaseTypes() {
        return DatabaseTypeUtils.getTypeAndBranchTypes("MySQL");
    }

    @Override
    public void close() {
    }

    public String getType() {
        return "CRC32_MATCH";
    }

    private static final class CRC32MatchTableInventoryChecker
    extends MatchingTableInventoryChecker {
        CRC32MatchTableInventoryChecker(TableInventoryCheckParameter param) {
            super(param);
        }

        @Override
        protected TableInventoryCalculator<TableInventoryCheckCalculatedResult> buildSingleTableInventoryCalculator() {
            return new CRC32TableInventoryCheckCalculator();
        }
    }
}

