/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.execute;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.execute.PipelineLifecycleRunnable;
import org.apache.shardingsphere.infra.util.datetime.DateTimeFormatterFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPipelineLifecycleRunnable
implements PipelineLifecycleRunnable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractPipelineLifecycleRunnable.class);
    private final AtomicReference<Boolean> running = new AtomicReference<Object>(null);
    private volatile long startTimeMillis;

    protected boolean isRunning() {
        Boolean running = this.running.get();
        return null != running && running != false;
    }

    @Override
    public final void start() {
        if (null != this.running.get() || !this.running.compareAndSet(null, true)) {
            return;
        }
        this.startTimeMillis = System.currentTimeMillis();
        this.runBlocking();
    }

    protected abstract void runBlocking();

    @Override
    public final void stop() {
        Boolean running = this.running.get();
        if (null == running) {
            this.running.set(false);
            return;
        }
        if (!running.booleanValue()) {
            return;
        }
        LocalDateTime startTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(this.startTimeMillis), ZoneId.systemDefault());
        log.info("stop lifecycle executor {}, startTime={}, cost {} ms", new Object[]{this, startTime.format(DateTimeFormatterFactory.getDatetimeFormatter()), System.currentTimeMillis() - this.startTimeMillis});
        try {
            this.doStop();
        }
        catch (RuntimeException ex) {
            log.warn("doStop failed", (Throwable)ex);
        }
        this.running.set(false);
    }

    protected abstract void doStop();

    @Override
    public final void run() {
        this.start();
    }
}

