/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.query.calculator;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.query.calculator.AbstractTableInventoryCalculator;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.query.calculator.TableInventoryCalculateParameter;
import org.jspecify.annotations.NonNull;

public abstract class AbstractStreamingTableInventoryCalculator<S>
extends AbstractTableInventoryCalculator<S> {
    @Override
    public final Iterable<S> calculate(TableInventoryCalculateParameter param) {
        return new ResultIterable(param);
    }

    protected abstract Optional<S> calculateChunk(TableInventoryCalculateParameter var1);

    private class ResultIterable
    implements Iterable<S> {
        private final TableInventoryCalculateParameter param;

        @Override
        public @NonNull Iterator<S> iterator() {
            return new ResultIterator(this.param);
        }

        @Generated
        public ResultIterable(TableInventoryCalculateParameter param) {
            this.param = param;
        }
    }

    private class ResultIterator
    implements Iterator<S> {
        private final AtomicBoolean currentChunkCalculated = new AtomicBoolean();
        private final AtomicReference<Optional<S>> nextResult = new AtomicReference();
        private final TableInventoryCalculateParameter param;

        @Override
        public boolean hasNext() {
            this.calculateIfNecessary();
            return this.nextResult.get().isPresent();
        }

        @Override
        public S next() {
            this.calculateIfNecessary();
            Optional result = this.nextResult.get();
            this.nextResult.set(null);
            this.currentChunkCalculated.set(false);
            return result.orElseThrow(NoSuchElementException::new);
        }

        private void calculateIfNecessary() {
            if (!this.currentChunkCalculated.get()) {
                this.nextResult.set(AbstractStreamingTableInventoryCalculator.this.calculateChunk(this.param));
                this.currentChunkCalculated.set(true);
            }
        }

        @Generated
        public ResultIterator(TableInventoryCalculateParameter param) {
            this.param = param;
        }
    }
}

