/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.job.progress;

import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.ingest.position.IngestPosition;
import org.apache.shardingsphere.data.pipeline.core.task.progress.InventoryTaskProgress;

public final class JobItemInventoryTasksProgress {
    private final Map<String, InventoryTaskProgress> progresses;

    public Map<String, IngestPosition> getInventoryPosition(String tableName) {
        Pattern pattern = Pattern.compile(String.format("\\.%s#(\\d+)?", tableName));
        return this.progresses.entrySet().stream().filter(entry -> pattern.matcher((CharSequence)entry.getKey()).find()).collect(Collectors.toMap(Map.Entry::getKey, entry -> ((InventoryTaskProgress)entry.getValue()).getPosition()));
    }

    @Generated
    public JobItemInventoryTasksProgress(Map<String, InventoryTaskProgress> progresses) {
        this.progresses = progresses;
    }

    @Generated
    public Map<String, InventoryTaskProgress> getProgresses() {
        return this.progresses;
    }
}

