/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.datanode;

import com.cedarsoftware.util.CaseInsensitiveMap;
import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.metadata.database.metadata.DialectDatabaseMetaData;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.database.connector.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.kernel.metadata.datanode.InvalidDataNodeFormatException;

public final class DataNode {
    private static final String DELIMITER = ".";
    private static final String ASTERISK = "*";
    private final String dataSourceName;
    private final String schemaName;
    private final String tableName;

    public DataNode(String dataNode) {
        this.validateDataNodeFormat(dataNode);
        List segments = Splitter.on((String)DELIMITER).splitToList((CharSequence)dataNode);
        boolean isIncludeSchema = 3 == segments.size();
        this.dataSourceName = (String)segments.get(0);
        this.schemaName = isIncludeSchema ? (String)segments.get(1) : null;
        this.tableName = (String)segments.get(isIncludeSchema ? 2 : 1);
    }

    public DataNode(String databaseName, DatabaseType databaseType, String dataNode) {
        ShardingSpherePreconditions.checkState((boolean)dataNode.contains(DELIMITER), () -> new InvalidDataNodeFormatException(dataNode));
        DialectDatabaseMetaData dialectDatabaseMetaData = new DatabaseTypeRegistry(databaseType).getDialectDatabaseMetaData();
        boolean containsSchema = dialectDatabaseMetaData.getSchemaOption().isSchemaAvailable() && this.isValidDataNode(dataNode, 3);
        List segments = Splitter.on((String)DELIMITER).limit(containsSchema ? 3 : 2).splitToList((CharSequence)dataNode);
        this.dataSourceName = (String)segments.get(0);
        this.schemaName = this.getSchemaName(databaseName, dialectDatabaseMetaData, containsSchema, segments);
        this.tableName = containsSchema ? ((String)segments.get(2)).toLowerCase() : ((String)segments.get(1)).toLowerCase();
    }

    private String getSchemaName(String databaseName, DialectDatabaseMetaData dialectDatabaseMetaData, boolean containsSchema, List<String> segments) {
        return dialectDatabaseMetaData.getSchemaOption().getDefaultSchema().map(optional -> containsSchema ? (String)segments.get(1) : ASTERISK).orElse(databaseName);
    }

    private boolean isValidDataNode(String dataNodeStr, int tier) {
        if (this.hasInvalidDelimiterStructure(dataNodeStr)) {
            return false;
        }
        List segments = Splitter.on((String)DELIMITER).splitToList((CharSequence)dataNodeStr);
        return this.isAnySegmentIsEmptyOrContainsOnlyWhitespace(tier, segments);
    }

    private boolean hasInvalidDelimiterStructure(String dataNodeStr) {
        return !dataNodeStr.contains(DELIMITER) || this.hasLeadingOrTrailingDelimiter(dataNodeStr) || this.hasConsecutiveDelimiters(dataNodeStr) || this.hasWhitespaceAroundDelimiters(dataNodeStr);
    }

    private boolean hasLeadingOrTrailingDelimiter(String dataNodeStr) {
        return dataNodeStr.startsWith(DELIMITER) || dataNodeStr.endsWith(DELIMITER);
    }

    private boolean hasConsecutiveDelimiters(String dataNodeStr) {
        return dataNodeStr.contains("..");
    }

    private boolean hasWhitespaceAroundDelimiters(String dataNodeStr) {
        return dataNodeStr.contains(" .") || dataNodeStr.contains(". ");
    }

    private boolean isAnySegmentIsEmptyOrContainsOnlyWhitespace(int tier, List<String> segments) {
        return segments.stream().noneMatch(each -> each.trim().isEmpty()) && tier == segments.size();
    }

    private void validateDataNodeFormat(String dataNode) {
        ShardingSpherePreconditions.checkState((this.isValidDataNode(dataNode, 2) || this.isValidDataNode(dataNode, 3) ? 1 : 0) != 0, () -> new InvalidDataNodeFormatException(dataNode));
    }

    public String format() {
        return null == this.schemaName ? this.formatWithoutSchema() : this.formatWithSchema();
    }

    public String format(DatabaseType databaseType) {
        return this.shouldIncludeSchema(databaseType) ? this.formatWithSchema() : this.formatWithoutSchema();
    }

    private boolean shouldIncludeSchema(DatabaseType databaseType) {
        return null != this.schemaName && new DatabaseTypeRegistry(databaseType).getDialectDatabaseMetaData().getSchemaOption().getDefaultSchema().isPresent();
    }

    private String formatWithSchema() {
        return String.join((CharSequence)DELIMITER, this.dataSourceName, this.schemaName, this.tableName);
    }

    private String formatWithoutSchema() {
        return String.join((CharSequence)DELIMITER, this.dataSourceName, this.tableName);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (null == object || this.getClass() != object.getClass()) {
            return false;
        }
        DataNode dataNode = (DataNode)object;
        return Objects.equal(Optional.ofNullable(this.dataSourceName).map(CaseInsensitiveMap.CaseInsensitiveString::of).orElse(null), Optional.ofNullable(dataNode.dataSourceName).map(CaseInsensitiveMap.CaseInsensitiveString::of).orElse(null)) && Objects.equal(Optional.ofNullable(this.tableName).map(CaseInsensitiveMap.CaseInsensitiveString::of).orElse(null), Optional.ofNullable(dataNode.tableName).map(CaseInsensitiveMap.CaseInsensitiveString::of).orElse(null)) && Objects.equal(Optional.ofNullable(this.schemaName).map(CaseInsensitiveMap.CaseInsensitiveString::of).orElse(null), Optional.ofNullable(dataNode.schemaName).map(CaseInsensitiveMap.CaseInsensitiveString::of).orElse(null));
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{Optional.ofNullable(this.dataSourceName).map(CaseInsensitiveMap.CaseInsensitiveString::of).orElse(null), Optional.ofNullable(this.tableName).map(CaseInsensitiveMap.CaseInsensitiveString::of).orElse(null), Optional.ofNullable(this.schemaName).map(CaseInsensitiveMap.CaseInsensitiveString::of).orElse(null)});
    }

    @Generated
    public DataNode(String dataSourceName, String schemaName, String tableName) {
        this.dataSourceName = dataSourceName;
        this.schemaName = schemaName;
        this.tableName = tableName;
    }

    @Generated
    public String getDataSourceName() {
        return this.dataSourceName;
    }

    @Generated
    public String getSchemaName() {
        return this.schemaName;
    }

    @Generated
    public String getTableName() {
        return this.tableName;
    }

    @Generated
    public String toString() {
        return "DataNode(dataSourceName=" + this.getDataSourceName() + ", schemaName=" + this.getSchemaName() + ", tableName=" + this.getTableName() + ")";
    }
}

