/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.database.schema.manager;

import java.util.Collection;
import java.util.LinkedList;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereView;

public final class GenericSchemaManager {
    public static Collection<ShardingSphereSchema> getToBeAlteredSchemasWithTablesAdded(ShardingSphereDatabase reloadDatabase, ShardingSphereDatabase currentDatabase) {
        LinkedList<ShardingSphereSchema> result = new LinkedList<ShardingSphereSchema>();
        reloadDatabase.getAllSchemas().stream().filter(each -> !currentDatabase.containsSchema(each.getName())).forEach(result::add);
        reloadDatabase.getAllSchemas().stream().filter(each -> currentDatabase.containsSchema(each.getName())).collect(Collectors.toList()).forEach(each -> result.add(GenericSchemaManager.getToBeAlteredSchemaWithTablesAdded(each, currentDatabase.getSchema(each.getName()))));
        return result;
    }

    private static ShardingSphereSchema getToBeAlteredSchemaWithTablesAdded(ShardingSphereSchema reloadSchema, ShardingSphereSchema currentSchema) {
        return new ShardingSphereSchema(currentSchema.getName(), reloadSchema.getProtocolType(), GenericSchemaManager.getToBeAddedTables(reloadSchema, currentSchema), new LinkedList<ShardingSphereView>());
    }

    public static Collection<ShardingSphereTable> getToBeAddedTables(ShardingSphereSchema reloadSchema, ShardingSphereSchema currentSchema) {
        return reloadSchema.getAllTables().stream().filter(each -> !currentSchema.containsTable(each.getName()) || !each.toString().equals(currentSchema.getTable(each.getName()).toString())).collect(Collectors.toList());
    }

    public static Collection<ShardingSphereSchema> getToBeAlteredSchemasWithTablesDropped(ShardingSphereDatabase reloadDatabase, ShardingSphereDatabase currentDatabase) {
        LinkedList<ShardingSphereSchema> result = new LinkedList<ShardingSphereSchema>();
        currentDatabase.getAllSchemas().stream().filter(each -> reloadDatabase.containsSchema(each.getName())).collect(Collectors.toMap(ShardingSphereSchema::getName, each -> each)).forEach((key, value) -> result.add(GenericSchemaManager.getToBeAlteredSchemaWithTablesDropped(reloadDatabase.getSchema((String)key), value)));
        return result;
    }

    private static ShardingSphereSchema getToBeAlteredSchemaWithTablesDropped(ShardingSphereSchema reloadSchema, ShardingSphereSchema currentSchema) {
        return new ShardingSphereSchema(currentSchema.getName(), reloadSchema.getProtocolType(), GenericSchemaManager.getToBeDroppedTables(reloadSchema, currentSchema), new LinkedList<ShardingSphereView>());
    }

    public static Collection<ShardingSphereTable> getToBeDroppedTables(ShardingSphereSchema reloadSchema, ShardingSphereSchema currentSchema) {
        return currentSchema.getAllTables().stream().filter(each -> !reloadSchema.containsTable(each.getName())).collect(Collectors.toList());
    }

    public static Collection<String> getToBeDroppedSchemaNames(ShardingSphereDatabase reloadDatabase, ShardingSphereDatabase currentDatabase) {
        return currentDatabase.getAllSchemas().stream().map(ShardingSphereSchema::getName).filter(each -> !reloadDatabase.containsSchema((String)each)).collect(Collectors.toSet());
    }

    @Generated
    private GenericSchemaManager() {
    }
}

