/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.connector.firebird.metadata.data.loader;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.metadata.data.loader.MetaDataLoaderConnection;
import org.apache.shardingsphere.database.connector.core.metadata.data.loader.MetaDataLoaderMaterial;
import org.apache.shardingsphere.database.connector.core.type.DatabaseTypeRegistry;

final class FirebirdBlobColumnLoader {
    private static final String SELECT_BLOB_COLUMNS_SQL = "SELECT TRIM(rf.RDB$FIELD_NAME) AS COLUMN_NAME, f.RDB$FIELD_SUB_TYPE AS SUB_TYPE FROM RDB$RELATION_FIELDS rf JOIN RDB$FIELDS f ON rf.RDB$FIELD_SOURCE = f.RDB$FIELD_NAME WHERE TRIM(UPPER(rf.RDB$RELATION_NAME)) = ? AND f.RDB$FIELD_TYPE = 261";
    private final MetaDataLoaderMaterial material;

    Map<String, Map<String, Integer>> load() throws SQLException {
        if (this.material.getActualTableNames().isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Map<String, Integer>> result = new HashMap<String, Map<String, Integer>>(this.material.getActualTableNames().size(), 1.0f);
        DatabaseTypeRegistry databaseTypeRegistry = new DatabaseTypeRegistry(this.material.getStorageType());
        try (MetaDataLoaderConnection connection = new MetaDataLoaderConnection(this.material.getStorageType(), this.material.getDataSource().getConnection());){
            for (String each : this.material.getActualTableNames()) {
                String formattedTableName = databaseTypeRegistry.formatIdentifierPattern(each);
                Map<String, Integer> blobColumns = this.loadTableBlobColumns(connection, formattedTableName);
                result.put(each, blobColumns);
            }
        }
        return result;
    }

    private Map<String, Integer> loadTableBlobColumns(MetaDataLoaderConnection connection, String formattedTableName) throws SQLException {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        try (PreparedStatement preparedStatement = connection.prepareStatement(SELECT_BLOB_COLUMNS_SQL);){
            preparedStatement.setString(1, formattedTableName.toUpperCase(Locale.ENGLISH));
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    String normalizedColumnName = this.normalizeColumnName(resultSet.getString("COLUMN_NAME"));
                    if (null == normalizedColumnName) continue;
                    result.put(normalizedColumnName, this.getColumnSubtype(resultSet));
                }
            }
        }
        return result.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(result);
    }

    private String normalizeColumnName(String columnName) {
        if (null == columnName) {
            return null;
        }
        String trimmed = columnName.trim();
        return trimmed.isEmpty() ? null : trimmed.toUpperCase(Locale.ENGLISH);
    }

    private Integer getColumnSubtype(ResultSet resultSet) throws SQLException {
        Object subTypeValue = resultSet.getObject("SUB_TYPE");
        return null == subTypeValue ? null : Integer.valueOf(((Number)subTypeValue).intValue());
    }

    @Generated
    public FirebirdBlobColumnLoader(MetaDataLoaderMaterial material) {
        this.material = material;
    }
}

