/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.timeout.IdleStateHandler;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.database.protocol.codec.PacketCodec;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.frontend.netty.ChannelAttrInitializer;
import org.apache.shardingsphere.proxy.frontend.netty.FrontendChannelInboundHandler;
import org.apache.shardingsphere.proxy.frontend.netty.FrontendChannelLimitationInboundHandler;
import org.apache.shardingsphere.proxy.frontend.netty.ProxyFlowControlHandler;
import org.apache.shardingsphere.proxy.frontend.spi.DatabaseProtocolFrontendEngine;

public final class ServerHandlerInitializer
extends ChannelInitializer<Channel> {
    private final DatabaseType databaseType;

    protected void initChannel(Channel socketChannel) {
        DatabaseProtocolFrontendEngine databaseProtocolFrontendEngine = (DatabaseProtocolFrontendEngine)DatabaseTypedSPILoader.getService(DatabaseProtocolFrontendEngine.class, (DatabaseType)this.databaseType);
        ChannelPipeline pipeline = socketChannel.pipeline();
        pipeline.addLast(new ChannelHandler[]{new ChannelAttrInitializer()});
        pipeline.addLast(new ChannelHandler[]{new PacketCodec(databaseProtocolFrontendEngine.getCodecEngine())});
        pipeline.addLast(new ChannelHandler[]{new FrontendChannelLimitationInboundHandler(databaseProtocolFrontendEngine)});
        pipeline.addLast(ProxyFlowControlHandler.class.getSimpleName(), (ChannelHandler)new ProxyFlowControlHandler());
        this.addIdleStateHandlerIfNeeded(pipeline);
        pipeline.addLast(FrontendChannelInboundHandler.class.getSimpleName(), (ChannelHandler)new FrontendChannelInboundHandler(databaseProtocolFrontendEngine, socketChannel));
        databaseProtocolFrontendEngine.initChannel(socketChannel);
    }

    private void addIdleStateHandlerIfNeeded(ChannelPipeline pipeline) {
        long idleTimeout = (Long)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getProps().getValue((Enum)ConfigurationPropertyKey.PROXY_FRONTEND_CONNECTION_IDLE_TIMEOUT);
        if (0L < idleTimeout) {
            pipeline.addLast(new ChannelHandler[]{new IdleStateHandler(0L, 0L, idleTimeout, TimeUnit.SECONDS)});
        }
    }

    @Generated
    public ServerHandlerInitializer(DatabaseType databaseType) {
        this.databaseType = databaseType;
    }
}

