/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.executor.enumerable.enumerator.memory;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.authority.rule.AuthorityRule;
import org.apache.shardingsphere.database.connector.core.metadata.database.metadata.option.table.DialectDriverQuerySystemCatalogOption;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.metadata.statistics.RowStatistics;
import org.apache.shardingsphere.infra.metadata.statistics.TableStatistics;
import org.apache.shardingsphere.infra.metadata.user.Grantee;

public final class MemoryTableStatisticsBuilder {
    public static TableStatistics buildTableStatistics(ShardingSphereTable table, ShardingSphereMetaData metaData, DialectDriverQuerySystemCatalogOption driverQuerySystemCatalogOption) {
        if (driverQuerySystemCatalogOption.isDatabaseDataTable(table.getName())) {
            return MemoryTableStatisticsBuilder.buildDatabaseData(table.getName(), metaData.getAllDatabases(), driverQuerySystemCatalogOption.getDatCompatibility());
        }
        if (driverQuerySystemCatalogOption.isTableDataTable(table.getName())) {
            return MemoryTableStatisticsBuilder.buildTableData(table.getName(), metaData);
        }
        if (driverQuerySystemCatalogOption.isRoleDataTable(table.getName())) {
            return MemoryTableStatisticsBuilder.buildRoleData(table.getName(), metaData);
        }
        return new TableStatistics(table.getName());
    }

    private static TableStatistics buildDatabaseData(String tableName, Collection<ShardingSphereDatabase> databases, String datCompatibility) {
        TableStatistics result = new TableStatistics(tableName);
        for (ShardingSphereDatabase each : databases) {
            Object[] rows = new Object[15];
            rows[0] = each.getName();
            rows[11] = datCompatibility;
            result.getRows().add(new RowStatistics(Arrays.asList(rows)));
        }
        return result;
    }

    private static TableStatistics buildTableData(String tableName, ShardingSphereMetaData metaData) {
        TableStatistics result = new TableStatistics(tableName);
        for (ShardingSphereDatabase each : metaData.getAllDatabases()) {
            result.getRows().addAll(MemoryTableStatisticsBuilder.buildTableData(each.getAllSchemas()));
        }
        return result;
    }

    private static Collection<RowStatistics> buildTableData(Collection<ShardingSphereSchema> schemas) {
        LinkedList<RowStatistics> result = new LinkedList<RowStatistics>();
        for (ShardingSphereSchema schema : schemas) {
            for (ShardingSphereTable each : schema.getAllTables()) {
                Object[] rows = new Object[10];
                rows[0] = schema.getName();
                rows[1] = each.getName();
                result.add(new RowStatistics(Arrays.asList(rows)));
            }
        }
        return result;
    }

    private static TableStatistics buildRoleData(String tableName, ShardingSphereMetaData metaData) {
        TableStatistics result = new TableStatistics(tableName);
        for (Grantee each : ((AuthorityRule)metaData.getGlobalRuleMetaData().getSingleRule(AuthorityRule.class)).getGrantees()) {
            Object[] rows = new Object[27];
            rows[0] = each.getUsername();
            result.getRows().add(new RowStatistics(Arrays.asList(rows)));
        }
        return result;
    }

    @Generated
    private MemoryTableStatisticsBuilder() {
    }
}

