/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.mysql.ingest.incremental.client.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.exception.PipelineInternalException;
import org.apache.shardingsphere.data.pipeline.mysql.ingest.incremental.binlog.MySQLBinlogContext;
import org.apache.shardingsphere.data.pipeline.mysql.ingest.incremental.binlog.event.MySQLBaseBinlogEvent;
import org.apache.shardingsphere.data.pipeline.mysql.ingest.incremental.binlog.event.PlaceholderBinlogEvent;
import org.apache.shardingsphere.data.pipeline.mysql.ingest.incremental.binlog.event.query.MySQLQueryBinlogEvent;
import org.apache.shardingsphere.data.pipeline.mysql.ingest.incremental.binlog.event.rows.MySQLDeleteRowsBinlogEvent;
import org.apache.shardingsphere.data.pipeline.mysql.ingest.incremental.binlog.event.rows.MySQLUpdateRowsBinlogEvent;
import org.apache.shardingsphere.data.pipeline.mysql.ingest.incremental.binlog.event.rows.MySQLWriteRowsBinlogEvent;
import org.apache.shardingsphere.data.pipeline.mysql.ingest.incremental.binlog.event.transaction.MySQLXidBinlogEvent;
import org.apache.shardingsphere.database.protocol.constant.CommonConstants;
import org.apache.shardingsphere.database.protocol.mysql.constant.MySQLBinlogEventType;
import org.apache.shardingsphere.database.protocol.mysql.packet.binlog.MySQLBinlogEventHeader;
import org.apache.shardingsphere.database.protocol.mysql.packet.binlog.management.MySQLBinlogFormatDescriptionEventPacket;
import org.apache.shardingsphere.database.protocol.mysql.packet.binlog.management.MySQLBinlogRotateEventPacket;
import org.apache.shardingsphere.database.protocol.mysql.packet.binlog.row.MySQLBinlogRowsEventPacket;
import org.apache.shardingsphere.database.protocol.mysql.packet.binlog.row.MySQLBinlogTableMapEventPacket;
import org.apache.shardingsphere.database.protocol.mysql.payload.MySQLPacketPayload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MySQLBinlogEventPacketDecoder
extends ByteToMessageDecoder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MySQLBinlogEventPacketDecoder.class);
    private static final String TX_BEGIN_SQL = "BEGIN";
    private final MySQLBinlogContext binlogContext;
    private final boolean decodeWithTX;
    private List<MySQLBaseBinlogEvent> records = new LinkedList<MySQLBaseBinlogEvent>();

    public MySQLBinlogEventPacketDecoder(int checksumLength, Map<Long, MySQLBinlogTableMapEventPacket> tableMap, boolean decodeWithTX) {
        this.decodeWithTX = decodeWithTX;
        this.binlogContext = new MySQLBinlogContext(checksumLength, tableMap);
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        while (in.readableBytes() >= 20) {
            in.markReaderIndex();
            MySQLPacketPayload payload = new MySQLPacketPayload(in, (Charset)ctx.channel().attr(CommonConstants.CHARSET_ATTRIBUTE_KEY).get());
            this.checkPayload(payload);
            MySQLBinlogEventHeader binlogEventHeader = new MySQLBinlogEventHeader(payload, this.binlogContext.getChecksumLength());
            if (!this.checkEventIntegrity(in, binlogEventHeader)) {
                return;
            }
            Optional<MySQLBaseBinlogEvent> binlogEvent = this.decodeEvent(binlogEventHeader, payload);
            if (!binlogEvent.isPresent()) {
                this.skipChecksum(binlogEventHeader.getEventType(), in);
                return;
            }
            if (binlogEvent.get() instanceof PlaceholderBinlogEvent) {
                out.add(binlogEvent.get());
                this.skipChecksum(binlogEventHeader.getEventType(), in);
                return;
            }
            if (this.decodeWithTX) {
                this.processEventWithTX(binlogEvent.get(), out);
            } else {
                this.processEventIgnoreTX(binlogEvent.get(), out);
            }
            this.skipChecksum(binlogEventHeader.getEventType(), in);
        }
    }

    private void checkPayload(MySQLPacketPayload payload) {
        int statusCode = payload.readInt1();
        if (255 == statusCode) {
            int errorNo = payload.readInt2();
            payload.skipReserved(1);
            String sqlState = payload.readStringFix(5);
            throw new PipelineInternalException("Decode binlog event failed, errorCode: %d, sqlState: %s, errorMessage: %s", new Object[]{errorNo, sqlState, payload.readStringEOF()});
        }
        if (0 != statusCode) {
            log.debug("Illegal binlog status code {}, remaining packet \n{}", (Object)statusCode, (Object)this.readRemainPacket(payload));
        }
    }

    private String readRemainPacket(MySQLPacketPayload payload) {
        return ByteBufUtil.hexDump((byte[])payload.readStringFixByBytes(payload.getByteBuf().readableBytes()));
    }

    private boolean checkEventIntegrity(ByteBuf in, MySQLBinlogEventHeader binlogEventHeader) {
        if (in.readableBytes() < binlogEventHeader.getEventSize() - 19) {
            log.debug("the event body is not complete, event size={}, readable bytes={}", (Object)binlogEventHeader.getEventSize(), (Object)in.readableBytes());
            in.resetReaderIndex();
            return false;
        }
        return true;
    }

    private void processEventWithTX(MySQLBaseBinlogEvent binlogEvent, List<Object> out) {
        if (binlogEvent instanceof MySQLQueryBinlogEvent) {
            MySQLQueryBinlogEvent queryEvent = (MySQLQueryBinlogEvent)binlogEvent;
            if (TX_BEGIN_SQL.equals(queryEvent.getSql())) {
                this.records = new LinkedList<MySQLBaseBinlogEvent>();
            } else {
                out.add(binlogEvent);
            }
        } else if (binlogEvent instanceof MySQLXidBinlogEvent) {
            this.records.add(binlogEvent);
            out.add(this.records);
        } else {
            this.records.add(binlogEvent);
        }
    }

    private void processEventIgnoreTX(MySQLBaseBinlogEvent binlogEvent, List<Object> out) {
        MySQLQueryBinlogEvent queryEvent;
        if (binlogEvent instanceof MySQLQueryBinlogEvent && TX_BEGIN_SQL.equals((queryEvent = (MySQLQueryBinlogEvent)binlogEvent).getSql())) {
            return;
        }
        out.add(binlogEvent);
    }

    private Optional<MySQLBaseBinlogEvent> decodeEvent(MySQLBinlogEventHeader binlogEventHeader, MySQLPacketPayload payload) {
        switch (MySQLBinlogEventType.valueOf((int)binlogEventHeader.getEventType()).orElse(MySQLBinlogEventType.UNKNOWN_EVENT)) {
            case ROTATE_EVENT: {
                this.decodeRotateEvent(binlogEventHeader, payload);
                return Optional.empty();
            }
            case FORMAT_DESCRIPTION_EVENT: {
                this.decodeFormatDescriptionEvent(binlogEventHeader, payload);
                return Optional.empty();
            }
            case TABLE_MAP_EVENT: {
                this.decodeTableMapEvent(binlogEventHeader, payload);
                return Optional.empty();
            }
            case WRITE_ROWS_EVENT_V1: 
            case WRITE_ROWS_EVENT_V2: {
                return Optional.of(this.decodeWriteRowsEventV2(binlogEventHeader, payload));
            }
            case UPDATE_ROWS_EVENT_V1: 
            case UPDATE_ROWS_EVENT_V2: {
                return Optional.of(this.decodeUpdateRowsEventV2(binlogEventHeader, payload));
            }
            case DELETE_ROWS_EVENT_V1: 
            case DELETE_ROWS_EVENT_V2: {
                return Optional.of(this.decodeDeleteRowsEventV2(binlogEventHeader, payload));
            }
            case QUERY_EVENT: {
                return Optional.of(this.decodeQueryEvent(binlogEventHeader, payload));
            }
            case XID_EVENT: {
                return Optional.of(this.decodeXidEvent(binlogEventHeader, payload));
            }
        }
        return Optional.of(this.decodePlaceholderEvent(binlogEventHeader, payload));
    }

    private void decodeRotateEvent(MySQLBinlogEventHeader binlogEventHeader, MySQLPacketPayload payload) {
        MySQLBinlogRotateEventPacket packet = new MySQLBinlogRotateEventPacket(binlogEventHeader, payload);
        this.binlogContext.setFileName(packet.getNextBinlogName());
    }

    private void decodeFormatDescriptionEvent(MySQLBinlogEventHeader binlogEventHeader, MySQLPacketPayload payload) {
        MySQLBinlogFormatDescriptionEventPacket packet = new MySQLBinlogFormatDescriptionEventPacket(binlogEventHeader, payload);
        int readableBytes = payload.getByteBuf().readableBytes();
        if (binlogEventHeader.getChecksumLength() <= 0 && readableBytes > 0) {
            if (readableBytes != 4) {
                log.warn("the format description event has extra bytes, readable bytes length={}, binlogEventHeader={}, formatDescriptionEvent={}", new Object[]{readableBytes, binlogEventHeader, packet});
            }
            payload.getByteBuf().skipBytes(readableBytes);
        }
    }

    private void decodeTableMapEvent(MySQLBinlogEventHeader binlogEventHeader, MySQLPacketPayload payload) {
        this.binlogContext.putTableMapEvent(new MySQLBinlogTableMapEventPacket(binlogEventHeader, payload));
    }

    private MySQLWriteRowsBinlogEvent decodeWriteRowsEventV2(MySQLBinlogEventHeader binlogEventHeader, MySQLPacketPayload payload) {
        MySQLBinlogRowsEventPacket packet = new MySQLBinlogRowsEventPacket(binlogEventHeader, payload);
        MySQLBinlogTableMapEventPacket tableMapEventPacket = this.binlogContext.getTableMapEvent(packet.getTableId());
        packet.readRows(tableMapEventPacket, payload);
        return new MySQLWriteRowsBinlogEvent(this.binlogContext.getFileName(), binlogEventHeader.getLogPos(), binlogEventHeader.getTimestamp(), tableMapEventPacket.getSchemaName(), tableMapEventPacket.getTableName(), packet.getRows());
    }

    private MySQLUpdateRowsBinlogEvent decodeUpdateRowsEventV2(MySQLBinlogEventHeader binlogEventHeader, MySQLPacketPayload payload) {
        MySQLBinlogRowsEventPacket packet = new MySQLBinlogRowsEventPacket(binlogEventHeader, payload);
        MySQLBinlogTableMapEventPacket tableMapEventPacket = this.binlogContext.getTableMapEvent(packet.getTableId());
        packet.readRows(tableMapEventPacket, payload);
        return new MySQLUpdateRowsBinlogEvent(this.binlogContext.getFileName(), binlogEventHeader.getLogPos(), binlogEventHeader.getTimestamp(), tableMapEventPacket.getSchemaName(), tableMapEventPacket.getTableName(), packet.getRows(), packet.getRows2());
    }

    private MySQLDeleteRowsBinlogEvent decodeDeleteRowsEventV2(MySQLBinlogEventHeader binlogEventHeader, MySQLPacketPayload payload) {
        MySQLBinlogRowsEventPacket packet = new MySQLBinlogRowsEventPacket(binlogEventHeader, payload);
        MySQLBinlogTableMapEventPacket tableMapEventPacket = this.binlogContext.getTableMapEvent(packet.getTableId());
        packet.readRows(tableMapEventPacket, payload);
        return new MySQLDeleteRowsBinlogEvent(this.binlogContext.getFileName(), binlogEventHeader.getLogPos(), binlogEventHeader.getTimestamp(), tableMapEventPacket.getSchemaName(), tableMapEventPacket.getTableName(), packet.getRows());
    }

    private PlaceholderBinlogEvent decodePlaceholderEvent(MySQLBinlogEventHeader binlogEventHeader, MySQLPacketPayload payload) {
        PlaceholderBinlogEvent result = new PlaceholderBinlogEvent(this.binlogContext.getFileName(), binlogEventHeader.getLogPos(), binlogEventHeader.getTimestamp());
        int remainDataLength = binlogEventHeader.getEventSize() + 1 - binlogEventHeader.getChecksumLength() - payload.getByteBuf().readerIndex();
        if (remainDataLength > 0) {
            payload.skipReserved(remainDataLength);
        }
        return result;
    }

    private MySQLQueryBinlogEvent decodeQueryEvent(MySQLBinlogEventHeader binlogEventHeader, MySQLPacketPayload payload) {
        int threadId = payload.readInt4();
        int executionTime = payload.readInt4();
        payload.skipReserved(1);
        int errorCode = payload.readInt2();
        payload.skipReserved(payload.readInt2());
        String databaseName = payload.readStringNul();
        String sql = payload.readStringFix(payload.getByteBuf().readableBytes() - binlogEventHeader.getChecksumLength());
        return new MySQLQueryBinlogEvent(this.binlogContext.getFileName(), binlogEventHeader.getLogPos(), binlogEventHeader.getTimestamp(), threadId, executionTime, errorCode, databaseName, sql);
    }

    private MySQLXidBinlogEvent decodeXidEvent(MySQLBinlogEventHeader binlogEventHeader, MySQLPacketPayload payload) {
        return new MySQLXidBinlogEvent(this.binlogContext.getFileName(), binlogEventHeader.getLogPos(), binlogEventHeader.getTimestamp(), payload.readInt8());
    }

    private void skipChecksum(int eventType, ByteBuf in) {
        if (0 < this.binlogContext.getChecksumLength() && MySQLBinlogEventType.FORMAT_DESCRIPTION_EVENT.getValue() != eventType) {
            in.skipBytes(this.binlogContext.getChecksumLength());
        }
    }
}

