/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.mysql.handler.admin.executor;

import lombok.Generated;
import org.apache.shardingsphere.authority.checker.AuthorityChecker;
import org.apache.shardingsphere.authority.rule.AuthorityRule;
import org.apache.shardingsphere.database.exception.core.exception.syntax.database.UnknownDatabaseException;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.DatabaseAdminUpdateExecutor;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.sql.parser.statement.core.util.SQLUtils;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.MySQLUseStatement;

public final class MySQLUseDatabaseExecutor
implements DatabaseAdminUpdateExecutor {
    private final MySQLUseStatement sqlStatement;

    public void execute(ConnectionSession connectionSession, ShardingSphereMetaData metaData) {
        String databaseName = SQLUtils.getExactlyValue((String)this.sqlStatement.getDatabase());
        AuthorityRule authorityRule = (AuthorityRule)metaData.getGlobalRuleMetaData().getSingleRule(AuthorityRule.class);
        AuthorityChecker authorityChecker = new AuthorityChecker(authorityRule, connectionSession.getConnectionContext().getGrantee());
        ShardingSpherePreconditions.checkState((metaData.containsDatabase(databaseName) && authorityChecker.isAuthorized(databaseName) ? 1 : 0) != 0, () -> new UnknownDatabaseException(databaseName));
        connectionSession.setCurrentDatabaseName(databaseName);
    }

    @Generated
    public MySQLUseDatabaseExecutor(MySQLUseStatement sqlStatement) {
        this.sqlStatement = sqlStatement;
    }
}

