/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.algorithm.loadbalancer.weight;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.shardingsphere.infra.algorithm.core.ShardingSphereAlgorithm;
import org.apache.shardingsphere.infra.algorithm.core.exception.AlgorithmInitializationException;
import org.apache.shardingsphere.infra.algorithm.loadbalancer.spi.LoadBalanceAlgorithm;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;

public final class WeightLoadBalanceAlgorithm
implements LoadBalanceAlgorithm {
    private static final double ACCURACY_THRESHOLD = 1.0E-4;
    private final Map<String, double[]> weightMap = new ConcurrentHashMap<String, double[]>();
    private final Map<String, Double> weightConfigMap = new HashMap<String, Double>();

    public void init(Properties props) {
        Set<String> availableTargetNames = props.stringPropertyNames();
        ShardingSpherePreconditions.checkNotEmpty(availableTargetNames, () -> new AlgorithmInitializationException((ShardingSphereAlgorithm)this, "Available target is required.", new Object[0]));
        for (String each : availableTargetNames) {
            String weight = props.getProperty(each);
            ShardingSpherePreconditions.checkNotNull((Object)weight, () -> new AlgorithmInitializationException((ShardingSphereAlgorithm)this, "Weight of available target `%s` is required.", new Object[]{each}));
            try {
                this.weightConfigMap.put(each, Double.parseDouble(weight));
            }
            catch (NumberFormatException ex) {
                throw new AlgorithmInitializationException((ShardingSphereAlgorithm)this, "Weight `%s` of available target `%s` should be number.", new Object[]{weight, each});
            }
        }
    }

    public void check(String databaseName, Collection<String> configuredTargetNames) {
        this.weightConfigMap.keySet().forEach(each -> ShardingSpherePreconditions.checkContains((Collection)configuredTargetNames, (Object)each, () -> new AlgorithmInitializationException((ShardingSphereAlgorithm)this, "Target `%s` is required in database `%s`.", new Object[]{each, databaseName})));
    }

    public String getTargetName(String groupName, List<String> availableTargetNames) {
        double[] weight = this.weightMap.containsKey(groupName) && this.weightMap.get(groupName).length == availableTargetNames.size() ? this.weightMap.get(groupName) : this.initWeight(availableTargetNames);
        this.weightMap.put(groupName, weight);
        return this.getAvailableTargetName(availableTargetNames, weight);
    }

    private String getAvailableTargetName(List<String> availableTargetNames, double[] weight) {
        double randomWeight = ThreadLocalRandom.current().nextDouble(0.0, 1.0);
        int index = Arrays.binarySearch(weight, randomWeight);
        if (index < 0) {
            return (index = -index - 1) < weight.length && randomWeight < weight[index] ? availableTargetNames.get(index) : availableTargetNames.get(availableTargetNames.size() - 1);
        }
        return availableTargetNames.get(index);
    }

    private double[] initWeight(List<String> availableTargetNames) {
        double[] result = this.getWeights(availableTargetNames);
        Preconditions.checkState((0 == result.length || !(Math.abs(result[result.length - 1] - 1.0) >= 1.0E-4) ? 1 : 0) != 0, (Object)"The cumulative weight is calculated incorrectly, and the sum of the probabilities is not equal to 1");
        return result;
    }

    private double[] getWeights(List<String> availableTargetNames) {
        double[] exactWeights = new double[availableTargetNames.size()];
        int index = 0;
        double sum = 0.0;
        for (String each : availableTargetNames) {
            double weight = this.getWeightValue(each);
            exactWeights[index++] = weight;
            sum += weight;
        }
        for (int i = 0; i < index; ++i) {
            if (exactWeights[i] <= 0.0) continue;
            exactWeights[i] = exactWeights[i] / sum;
        }
        return this.calculateWeight(exactWeights);
    }

    private double[] calculateWeight(double[] exactWeights) {
        double[] result = new double[exactWeights.length];
        double randomRange = 0.0;
        for (int i = 0; i < result.length; ++i) {
            result[i] = randomRange + exactWeights[i];
            randomRange += exactWeights[i];
        }
        return result;
    }

    private double getWeightValue(String readDataSourceName) {
        double result = this.weightConfigMap.get(readDataSourceName);
        if (Double.isInfinite(result)) {
            result = 10000.0;
        }
        if (Double.isNaN(result)) {
            result = 1.0;
        }
        return result;
    }

    public String getType() {
        return "WEIGHT";
    }
}

