/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.distsql.handler.aware.DistSQLExecutorRuleAware;
import org.apache.shardingsphere.distsql.handler.engine.query.DistSQLQueryExecutor;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.sharding.distsql.statement.ShowShardingTableRulesUsedAuditorStatement;
import org.apache.shardingsphere.sharding.rule.ShardingRule;

public final class ShowShardingTableRulesUsedAuditorExecutor
implements DistSQLQueryExecutor<ShowShardingTableRulesUsedAuditorStatement>,
DistSQLExecutorRuleAware<ShardingRule> {
    private ShardingRule rule;

    public Collection<String> getColumnNames(ShowShardingTableRulesUsedAuditorStatement sqlStatement) {
        return Arrays.asList("type", "name");
    }

    public Collection<LocalDataQueryResultRow> getRows(ShowShardingTableRulesUsedAuditorStatement sqlStatement, ContextManager contextManager) {
        if (!sqlStatement.getAuditorName().isPresent()) {
            return Collections.emptyList();
        }
        LinkedList<LocalDataQueryResultRow> result = new LinkedList<LocalDataQueryResultRow>();
        this.rule.getConfiguration().getTables().forEach(each -> {
            if (null != each.getAuditStrategy() && each.getAuditStrategy().getAuditorNames().contains(sqlStatement.getAuditorName().get())) {
                result.add(new LocalDataQueryResultRow(new Object[]{"table", each.getLogicTable()}));
            }
        });
        this.rule.getConfiguration().getAutoTables().forEach(each -> {
            if (null != each.getAuditStrategy() && each.getAuditStrategy().getAuditorNames().contains(sqlStatement.getAuditorName().get())) {
                result.add(new LocalDataQueryResultRow(new Object[]{"auto_table", each.getLogicTable()}));
            }
        });
        return result;
    }

    public Class<ShardingRule> getRuleClass() {
        return ShardingRule.class;
    }

    public Class<ShowShardingTableRulesUsedAuditorStatement> getType() {
        return ShowShardingTableRulesUsedAuditorStatement.class;
    }

    @Generated
    public void setRule(ShardingRule rule) {
        this.rule = rule;
    }
}

