/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.distsql.handler.aware;

import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.database.exception.core.exception.syntax.database.NoDatabaseSelectedException;
import org.apache.shardingsphere.distsql.handler.aware.DistSQLExecutorConnectionContextAware;
import org.apache.shardingsphere.distsql.handler.aware.DistSQLExecutorDatabaseAware;
import org.apache.shardingsphere.distsql.handler.aware.DistSQLExecutorRuleAware;
import org.apache.shardingsphere.distsql.handler.engine.DistSQLConnectionContext;
import org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.spi.global.GlobalRuleDefinitionExecutor;
import org.apache.shardingsphere.distsql.statement.DistSQLStatement;
import org.apache.shardingsphere.distsql.statement.type.rql.rule.global.ShowGlobalRulesStatement;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.generic.UnsupportedSQLOperationException;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.generator.aware.ConnectionContextAware;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.mode.manager.ContextManager;

public final class DistSQLExecutorAwareSetter {
    private final Object executor;

    public void set(ContextManager contextManager, ShardingSphereDatabase database, DistSQLConnectionContext distsqlConnectionContext, DistSQLStatement sqlStatement) {
        if (this.executor instanceof DistSQLExecutorDatabaseAware) {
            ShardingSpherePreconditions.checkNotNull((Object)database, NoDatabaseSelectedException::new);
            ((DistSQLExecutorDatabaseAware)this.executor).setDatabase(database);
        }
        if (this.executor instanceof DistSQLExecutorRuleAware) {
            if (!(sqlStatement instanceof ShowGlobalRulesStatement) && !(this.executor instanceof GlobalRuleDefinitionExecutor)) {
                ShardingSpherePreconditions.checkNotNull((Object)database, NoDatabaseSelectedException::new);
            }
            this.setRule((DistSQLExecutorRuleAware)this.executor, contextManager, database);
        }
        if (this.executor instanceof DistSQLExecutorConnectionContextAware) {
            ((DistSQLExecutorConnectionContextAware)this.executor).setConnectionContext(distsqlConnectionContext);
        }
        if (this.executor instanceof ConnectionContextAware) {
            ((ConnectionContextAware)this.executor).setConnectionContext(distsqlConnectionContext.getQueryContext().getConnectionContext());
        }
    }

    private void setRule(DistSQLExecutorRuleAware executor, ContextManager contextManager, ShardingSphereDatabase database) throws UnsupportedSQLOperationException {
        Optional<ShardingSphereRule> rule = this.findRule(contextManager, database, executor.getRuleClass());
        ShardingSpherePreconditions.checkState((boolean)rule.isPresent(), () -> new UnsupportedSQLOperationException(String.format("The current database has no `%s` rules", executor.getRuleClass())));
        executor.setRule(rule.get());
    }

    private Optional<ShardingSphereRule> findRule(ContextManager contextManager, ShardingSphereDatabase database, Class<ShardingSphereRule> ruleClass) {
        Optional globalRule = contextManager.getMetaDataContexts().getMetaData().getGlobalRuleMetaData().findSingleRule(ruleClass);
        return globalRule.isPresent() ? globalRule : database.getRuleMetaData().findSingleRule(ruleClass);
    }

    @Generated
    public DistSQLExecutorAwareSetter(Object executor) {
        this.executor = executor;
    }
}

