/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.distsql.handler.update;

import java.util.Collection;
import java.util.List;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.spi.database.type.DatabaseRuleCreateExecutor;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.kernel.metadata.rule.DuplicateRuleException;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.shadow.config.ShadowRuleConfiguration;
import org.apache.shardingsphere.shadow.distsql.handler.checker.ShadowRuleStatementChecker;
import org.apache.shardingsphere.shadow.distsql.handler.converter.ShadowRuleStatementConverter;
import org.apache.shardingsphere.shadow.distsql.handler.supporter.ShadowRuleStatementSupporter;
import org.apache.shardingsphere.shadow.distsql.segment.ShadowAlgorithmSegment;
import org.apache.shardingsphere.shadow.distsql.segment.ShadowRuleSegment;
import org.apache.shardingsphere.shadow.distsql.statement.CreateShadowRuleStatement;
import org.apache.shardingsphere.shadow.rule.ShadowRule;
import org.apache.shardingsphere.shadow.spi.ShadowAlgorithm;

public final class CreateShadowRuleExecutor
implements DatabaseRuleCreateExecutor<CreateShadowRuleStatement, ShadowRule, ShadowRuleConfiguration> {
    private ShardingSphereDatabase database;
    private ShadowRule rule;

    public void checkBeforeUpdate(CreateShadowRuleStatement sqlStatement) {
        this.checkDuplicatedRules(sqlStatement);
        this.checkStorageUnits(sqlStatement.getRules());
        this.checkAlgorithms(sqlStatement.getRules());
        this.checkAlgorithmType(sqlStatement.getRules());
    }

    private void checkDuplicatedRules(CreateShadowRuleStatement sqlStatement) {
        List<String> toBeCreatedRuleNames = ShadowRuleStatementSupporter.getRuleNames(sqlStatement.getRules());
        ShadowRuleStatementChecker.checkDuplicated(toBeCreatedRuleNames, duplicated -> new DuplicateRuleException("shadow", this.database.getName(), duplicated));
        ShadowRuleStatementChecker.checkDuplicatedWithLogicDataSource(toBeCreatedRuleNames, this.database);
        if (!sqlStatement.isIfNotExists()) {
            toBeCreatedRuleNames.retainAll(ShadowRuleStatementSupporter.getRuleNames(null == this.rule ? null : this.rule.getConfiguration()));
            ShardingSpherePreconditions.checkMustEmpty(toBeCreatedRuleNames, () -> new DuplicateRuleException("shadow", this.database.getName(), toBeCreatedRuleNames));
        }
    }

    private void checkStorageUnits(Collection<ShadowRuleSegment> segments) {
        ShadowRuleStatementChecker.checkStorageUnitsExist(ShadowRuleStatementSupporter.getStorageUnitNames(segments), this.database);
    }

    private void checkAlgorithms(Collection<ShadowRuleSegment> segments) {
        ShadowRuleStatementChecker.checkDuplicated(ShadowRuleStatementSupporter.getAlgorithmNames(segments), duplicated -> new DuplicateRuleException("shadow", this.database.getName(), duplicated));
    }

    private void checkAlgorithmType(Collection<ShadowRuleSegment> segments) {
        segments.stream().flatMap(each -> each.getShadowTableRules().values().stream()).flatMap(Collection::stream).map(ShadowAlgorithmSegment::getAlgorithmSegment).forEach(each -> TypedSPILoader.checkService(ShadowAlgorithm.class, (Object)each.getName(), (Properties)each.getProps()));
    }

    public ShadowRuleConfiguration buildToBeCreatedRuleConfiguration(CreateShadowRuleStatement sqlStatement) {
        Collection segments = sqlStatement.getRules();
        if (sqlStatement.isIfNotExists()) {
            List<String> toBeCreatedRuleNames = ShadowRuleStatementSupporter.getRuleNames(sqlStatement.getRules());
            toBeCreatedRuleNames.retainAll(ShadowRuleStatementSupporter.getRuleNames(this.rule.getConfiguration()));
            segments.removeIf(each -> toBeCreatedRuleNames.contains(each.getRuleName()));
        }
        return ShadowRuleStatementConverter.convert(segments);
    }

    public Class<ShadowRule> getRuleClass() {
        return ShadowRule.class;
    }

    public Class<CreateShadowRuleStatement> getType() {
        return CreateShadowRuleStatement.class;
    }

    @Generated
    public void setDatabase(ShardingSphereDatabase database) {
        this.database = database;
    }

    @Generated
    public void setRule(ShadowRule rule) {
        this.rule = rule;
    }
}

