/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.scenario.migration.api;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.PipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.api.type.ShardingSpherePipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.api.type.StandardPipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.core.context.PipelineContextKey;
import org.apache.shardingsphere.data.pipeline.core.context.PipelineContextManager;
import org.apache.shardingsphere.data.pipeline.core.datanode.JobDataNodeEntry;
import org.apache.shardingsphere.data.pipeline.core.datanode.JobDataNodeLine;
import org.apache.shardingsphere.data.pipeline.core.datanode.JobDataNodeLineConvertUtils;
import org.apache.shardingsphere.data.pipeline.core.datasource.PipelineDataSource;
import org.apache.shardingsphere.data.pipeline.core.datasource.yaml.config.YamlPipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.core.exception.param.PipelineInvalidParameterException;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.mapper.TableAndSchemaNameMapper;
import org.apache.shardingsphere.data.pipeline.core.job.api.PipelineAPIFactory;
import org.apache.shardingsphere.data.pipeline.core.job.api.TransmissionJobAPI;
import org.apache.shardingsphere.data.pipeline.core.job.config.PipelineJobConfiguration;
import org.apache.shardingsphere.data.pipeline.core.job.id.PipelineJobId;
import org.apache.shardingsphere.data.pipeline.core.job.id.PipelineJobIdUtils;
import org.apache.shardingsphere.data.pipeline.core.job.service.PipelineJobConfigurationManager;
import org.apache.shardingsphere.data.pipeline.core.job.service.PipelineJobManager;
import org.apache.shardingsphere.data.pipeline.core.job.type.PipelineJobType;
import org.apache.shardingsphere.data.pipeline.core.metadata.PipelineDataSourcePersistService;
import org.apache.shardingsphere.data.pipeline.core.sqlbuilder.sql.PipelinePrepareSQLBuilder;
import org.apache.shardingsphere.data.pipeline.scenario.migration.MigrationJobId;
import org.apache.shardingsphere.data.pipeline.scenario.migration.MigrationJobType;
import org.apache.shardingsphere.data.pipeline.scenario.migration.api.MigrationSourceTargetEntry;
import org.apache.shardingsphere.data.pipeline.scenario.migration.config.MigrationJobConfiguration;
import org.apache.shardingsphere.data.pipeline.scenario.migration.config.yaml.config.YamlMigrationJobConfiguration;
import org.apache.shardingsphere.data.pipeline.scenario.migration.config.yaml.swapper.YamlMigrationJobConfigurationSwapper;
import org.apache.shardingsphere.database.connector.core.jdbcurl.parser.ConnectionProperties;
import org.apache.shardingsphere.database.connector.core.jdbcurl.parser.ConnectionPropertiesParser;
import org.apache.shardingsphere.database.connector.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.database.connector.core.type.DatabaseTypeFactory;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.datasource.pool.props.domain.DataSourcePoolProperties;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.kernel.metadata.resource.storageunit.DuplicateStorageUnitException;
import org.apache.shardingsphere.infra.exception.kernel.metadata.resource.storageunit.MissingRequiredStorageUnitsException;
import org.apache.shardingsphere.infra.exception.kernel.metadata.rule.EmptyRuleException;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.resource.unit.StorageUnit;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.infra.util.json.JsonUtils;
import org.apache.shardingsphere.infra.yaml.config.pojo.YamlRootConfiguration;
import org.apache.shardingsphere.infra.yaml.config.pojo.rule.YamlRuleConfiguration;
import org.apache.shardingsphere.infra.yaml.config.swapper.resource.YamlDataSourceConfigurationSwapper;
import org.apache.shardingsphere.infra.yaml.config.swapper.rule.YamlRuleConfigurationSwapperEngine;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.single.yaml.config.YamlSingleRuleConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MigrationJobAPI
implements TransmissionJobAPI {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MigrationJobAPI.class);
    private final PipelineJobManager jobManager;
    private final PipelineJobConfigurationManager jobConfigManager;
    private final PipelineDataSourcePersistService dataSourcePersistService;

    public MigrationJobAPI() {
        MigrationJobType jobType = new MigrationJobType();
        this.jobManager = new PipelineJobManager((PipelineJobType)jobType);
        this.jobConfigManager = new PipelineJobConfigurationManager(jobType.getOption());
        this.dataSourcePersistService = new PipelineDataSourcePersistService();
    }

    public String schedule(PipelineContextKey contextKey, Collection<MigrationSourceTargetEntry> sourceTargetEntries, String targetDatabaseName) {
        MigrationJobConfiguration jobConfig = new YamlMigrationJobConfigurationSwapper().swapToObject(this.buildYamlJobConfiguration(contextKey, sourceTargetEntries, targetDatabaseName));
        this.jobManager.start((PipelineJobConfiguration)jobConfig);
        return jobConfig.getJobId();
    }

    private YamlMigrationJobConfiguration buildYamlJobConfiguration(PipelineContextKey contextKey, Collection<MigrationSourceTargetEntry> sourceTargetEntries, String targetDatabaseName) {
        YamlMigrationJobConfiguration result = new YamlMigrationJobConfiguration();
        result.setTargetDatabaseName(targetDatabaseName);
        Map metaDataDataSource = this.dataSourcePersistService.load(contextKey, "MIGRATION");
        LinkedHashMap<String, List<DataNode>> sourceDataNodes = new LinkedHashMap<String, List<DataNode>>(sourceTargetEntries.size(), 1.0f);
        LinkedHashMap<String, YamlPipelineDataSourceConfiguration> configSources = new LinkedHashMap<String, YamlPipelineDataSourceConfiguration>(sourceTargetEntries.size(), 1.0f);
        YamlDataSourceConfigurationSwapper dataSourceConfigSwapper = new YamlDataSourceConfigurationSwapper();
        for (MigrationSourceTargetEntry each2 : new HashSet<MigrationSourceTargetEntry>(sourceTargetEntries).stream().sorted(Comparator.comparing(MigrationSourceTargetEntry::getTargetTableName).thenComparing(each -> each.getSource().format())).collect(Collectors.toList())) {
            sourceDataNodes.computeIfAbsent(each2.getTargetTableName(), key -> new LinkedList()).add(each2.getSource());
            ShardingSpherePreconditions.checkState((1 == ((List)sourceDataNodes.get(each2.getTargetTableName())).size() ? 1 : 0) != 0, () -> new PipelineInvalidParameterException("More than one source table for " + each2.getTargetTableName()));
            String dataSourceName = each2.getSource().getDataSourceName();
            if (configSources.containsKey(dataSourceName)) continue;
            ShardingSpherePreconditions.checkContainsKey((Map)metaDataDataSource, (Object)dataSourceName, () -> new PipelineInvalidParameterException(dataSourceName + " doesn't exist. Run `SHOW MIGRATION SOURCE STORAGE UNITS;` to verify it."));
            Map sourceDataSourcePoolProps = dataSourceConfigSwapper.swapToMap((DataSourcePoolProperties)metaDataDataSource.get(dataSourceName));
            StandardPipelineDataSourceConfiguration sourceDataSourceConfig = new StandardPipelineDataSourceConfiguration(sourceDataSourcePoolProps);
            configSources.put(dataSourceName, this.buildYamlPipelineDataSourceConfiguration(sourceDataSourceConfig.getType(), sourceDataSourceConfig.getParameter()));
            DatabaseType sourceDatabaseType = sourceDataSourceConfig.getDatabaseType();
            if (null == result.getSourceDatabaseType()) {
                result.setSourceDatabaseType(sourceDatabaseType.getType());
                continue;
            }
            if (result.getSourceDatabaseType().equals(sourceDatabaseType.getType())) continue;
            throw new PipelineInvalidParameterException("Source storage units have different database types");
        }
        result.setSources(configSources);
        ShardingSphereDatabase targetDatabase = PipelineContextManager.getProxyContext().getMetaDataContexts().getMetaData().getDatabase(targetDatabaseName);
        PipelineDataSourceConfiguration targetPipelineDataSourceConfig = this.buildTargetPipelineDataSourceConfiguration(targetDatabase);
        result.setTarget(this.buildYamlPipelineDataSourceConfiguration(targetPipelineDataSourceConfig.getType(), targetPipelineDataSourceConfig.getParameter()));
        result.setTargetDatabaseType(targetPipelineDataSourceConfig.getDatabaseType().getType());
        List tablesFirstDataNodes = sourceDataNodes.entrySet().stream().map(entry -> new JobDataNodeEntry((String)entry.getKey(), ((List)entry.getValue()).subList(0, 1))).collect(Collectors.toList());
        result.setTargetTableNames(new ArrayList(sourceDataNodes.keySet()).stream().sorted().collect(Collectors.toList()));
        result.setTargetTableSchemaMap(this.buildTargetTableSchemaMap(sourceDataNodes));
        result.setTablesFirstDataNodes(new JobDataNodeLine(tablesFirstDataNodes).marshal());
        result.setJobShardingDataNodes(JobDataNodeLineConvertUtils.convertDataNodesToLines(sourceDataNodes).stream().map(JobDataNodeLine::marshal).collect(Collectors.toList()));
        result.setJobId(PipelineJobIdUtils.marshal((PipelineJobId)new MigrationJobId(contextKey, result.getJobShardingDataNodes())));
        return result;
    }

    private YamlPipelineDataSourceConfiguration buildYamlPipelineDataSourceConfiguration(String type, String param) {
        YamlPipelineDataSourceConfiguration result = new YamlPipelineDataSourceConfiguration();
        result.setType(type);
        result.setParameter(param);
        return result;
    }

    private PipelineDataSourceConfiguration buildTargetPipelineDataSourceConfiguration(ShardingSphereDatabase targetDatabase) {
        HashMap<String, Map<String, Object>> targetPoolProps = new HashMap<String, Map<String, Object>>(targetDatabase.getResourceMetaData().getStorageUnits().size(), 1.0f);
        YamlDataSourceConfigurationSwapper dataSourceConfigSwapper = new YamlDataSourceConfigurationSwapper();
        for (Map.Entry entry : targetDatabase.getResourceMetaData().getStorageUnits().entrySet()) {
            targetPoolProps.put((String)entry.getKey(), dataSourceConfigSwapper.swapToMap(((StorageUnit)entry.getValue()).getDataSourcePoolProperties()));
        }
        YamlRootConfiguration targetRootConfig = this.buildYamlRootConfiguration(targetDatabase.getName(), targetPoolProps, targetDatabase.getRuleMetaData().getConfigurations());
        return new ShardingSpherePipelineDataSourceConfiguration(targetRootConfig);
    }

    private YamlRootConfiguration buildYamlRootConfiguration(String databaseName, Map<String, Map<String, Object>> yamlDataSources, Collection<RuleConfiguration> rules) {
        ShardingSpherePreconditions.checkNotEmpty(rules, () -> new EmptyRuleException(databaseName));
        YamlRootConfiguration result = new YamlRootConfiguration();
        result.setDatabaseName(databaseName);
        result.setDataSources(yamlDataSources);
        result.setRules(this.getYamlRuleConfigurations(rules));
        return result;
    }

    private Collection<YamlRuleConfiguration> getYamlRuleConfigurations(Collection<RuleConfiguration> rules) {
        Collection result = new YamlRuleConfigurationSwapperEngine().swapToYamlRuleConfigurations(rules);
        Optional<YamlSingleRuleConfiguration> originalSingleRuleConfig = result.stream().filter(YamlSingleRuleConfiguration.class::isInstance).map(YamlSingleRuleConfiguration.class::cast).findFirst();
        result.removeIf(YamlSingleRuleConfiguration.class::isInstance);
        YamlSingleRuleConfiguration singleRuleConfig = new YamlSingleRuleConfiguration();
        singleRuleConfig.setTables(Collections.singletonList("*.*"));
        originalSingleRuleConfig.ifPresent(optional -> singleRuleConfig.setDefaultDataSource(optional.getDefaultDataSource()));
        result.add(singleRuleConfig);
        return result;
    }

    private Map<String, String> buildTargetTableSchemaMap(Map<String, List<DataNode>> sourceDataNodes) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(sourceDataNodes.size(), 1.0f);
        sourceDataNodes.forEach((tableName, dataNodes) -> result.put((String)tableName, ((DataNode)dataNodes.get(0)).getSchemaName()));
        return result;
    }

    public void registerMigrationSourceStorageUnits(PipelineContextKey contextKey, Map<String, DataSourcePoolProperties> propsMap) {
        Map existDataSources = this.dataSourcePersistService.load(contextKey, this.getType());
        HashSet<String> duplicateDataSourceNames = new HashSet<String>(propsMap.size(), 1.0f);
        for (Map.Entry<String, DataSourcePoolProperties> entry : propsMap.entrySet()) {
            if (!existDataSources.containsKey(entry.getKey())) continue;
            duplicateDataSourceNames.add(entry.getKey());
        }
        ShardingSpherePreconditions.checkMustEmpty(duplicateDataSourceNames, () -> new DuplicateStorageUnitException(contextKey.getDatabaseName(), duplicateDataSourceNames));
        LinkedHashMap<String, DataSourcePoolProperties> result = new LinkedHashMap<String, DataSourcePoolProperties>(existDataSources);
        result.putAll(propsMap);
        this.dataSourcePersistService.persist(contextKey, this.getType(), result);
    }

    public void dropMigrationSourceResources(PipelineContextKey contextKey, Collection<String> resourceNames) {
        Map metaDataDataSource = this.dataSourcePersistService.load(contextKey, this.getType());
        Collection notExistedResources = resourceNames.stream().filter(each -> !metaDataDataSource.containsKey(each)).collect(Collectors.toList());
        ShardingSpherePreconditions.checkMustEmpty((Collection)notExistedResources, () -> new MissingRequiredStorageUnitsException(contextKey.getDatabaseName(), notExistedResources));
        for (String each2 : resourceNames) {
            metaDataDataSource.remove(each2);
        }
        this.dataSourcePersistService.persist(contextKey, this.getType(), metaDataDataSource);
    }

    public Collection<Collection<Object>> listMigrationSourceResources(PipelineContextKey contextKey) {
        Map propsMap = this.dataSourcePersistService.load(contextKey, this.getType());
        ArrayList<Collection<Object>> result = new ArrayList<Collection<Object>>(propsMap.size());
        for (Map.Entry entry : propsMap.entrySet()) {
            String dataSourceName = (String)entry.getKey();
            DataSourcePoolProperties value = (DataSourcePoolProperties)entry.getValue();
            LinkedList<Object> props = new LinkedList<Object>();
            props.add(dataSourceName);
            String url = String.valueOf(value.getConnectionPropertySynonyms().getStandardProperties().get("url"));
            DatabaseType databaseType = DatabaseTypeFactory.get((String)url);
            props.add(databaseType.getType());
            ConnectionProperties connectionProps = ((ConnectionPropertiesParser)DatabaseTypedSPILoader.getService(ConnectionPropertiesParser.class, (DatabaseType)databaseType)).parse(url, "", null);
            props.add(connectionProps.getHostname());
            props.add(connectionProps.getPort());
            props.add(connectionProps.getCatalog());
            Map standardProps = value.getPoolPropertySynonyms().getStandardProperties();
            props.add(this.getStandardProperty(standardProps, "connectionTimeoutMilliseconds"));
            props.add(this.getStandardProperty(standardProps, "idleTimeoutMilliseconds"));
            props.add(this.getStandardProperty(standardProps, "maxLifetimeMilliseconds"));
            props.add(this.getStandardProperty(standardProps, "maxPoolSize"));
            props.add(this.getStandardProperty(standardProps, "minPoolSize"));
            props.add(this.getStandardProperty(standardProps, "readOnly"));
            Map otherProps = value.getCustomProperties().getProperties();
            props.add(otherProps.isEmpty() ? "" : JsonUtils.toJsonString((Object)otherProps));
            result.add(props);
        }
        return result;
    }

    private String getStandardProperty(Map<String, Object> standardProps, String key) {
        return standardProps.containsKey(key) && null != standardProps.get(key) ? standardProps.get(key).toString() : "";
    }

    public void commit(String jobId) {
        log.info("Commit job {}", (Object)jobId);
        long startTimeMillis = System.currentTimeMillis();
        this.jobManager.stop(jobId);
        this.dropCheckJobs(jobId);
        MigrationJobConfiguration jobConfig = (MigrationJobConfiguration)this.jobConfigManager.getJobConfiguration(jobId);
        this.refreshTableMetadata(jobId, jobConfig.getTargetDatabaseName());
        this.jobManager.drop(jobId);
        log.info("Commit cost {} ms", (Object)(System.currentTimeMillis() - startTimeMillis));
    }

    private void refreshTableMetadata(String jobId, String databaseName) {
        ContextManager contextManager = PipelineContextManager.getContext((PipelineContextKey)PipelineJobIdUtils.parseContextKey((String)jobId));
        ShardingSphereDatabase database = contextManager.getMetaDataContexts().getMetaData().getDatabase(databaseName);
        contextManager.reloadDatabase(database);
    }

    public void rollback(String jobId) throws SQLException {
        long startTimeMillis = System.currentTimeMillis();
        this.dropCheckJobs(jobId);
        this.cleanTempTableOnRollback(jobId);
        this.jobManager.drop(jobId);
        log.info("Rollback job {} cost {} ms", (Object)jobId, (Object)(System.currentTimeMillis() - startTimeMillis));
    }

    private void dropCheckJobs(String jobId) {
        Collection checkJobIds = PipelineAPIFactory.getPipelineGovernanceFacade((PipelineContextKey)PipelineJobIdUtils.parseContextKey((String)jobId)).getJobFacade().getCheck().listCheckJobIds(jobId);
        if (checkJobIds.isEmpty()) {
            return;
        }
        for (String each : checkJobIds) {
            try {
                this.jobManager.drop(each);
            }
            catch (RuntimeException ex) {
                log.info("drop check job failed, check job id: {}, error: {}", (Object)each, (Object)ex.getMessage());
            }
        }
    }

    private void cleanTempTableOnRollback(String jobId) throws SQLException {
        MigrationJobConfiguration jobConfig = (MigrationJobConfiguration)new PipelineJobConfigurationManager(((PipelineJobType)TypedSPILoader.getService(PipelineJobType.class, (Object)this.getType())).getOption()).getJobConfiguration(jobId);
        PipelinePrepareSQLBuilder pipelineSQLBuilder = new PipelinePrepareSQLBuilder(jobConfig.getTargetDatabaseType());
        TableAndSchemaNameMapper mapping = new TableAndSchemaNameMapper(jobConfig.getTargetTableSchemaMap());
        try (PipelineDataSource dataSource = new PipelineDataSource(jobConfig.getTarget());
             Connection connection = dataSource.getConnection();){
            for (String each : jobConfig.getTargetTableNames()) {
                String targetSchemaName = mapping.getSchemaName(each);
                String sql = pipelineSQLBuilder.buildDropSQL(targetSchemaName, each);
                log.info("cleanTempTableOnRollback, targetSchemaName={}, targetTableName={}, sql={}", new Object[]{targetSchemaName, each, sql});
                Statement statement = connection.createStatement();
                try {
                    statement.execute(sql);
                }
                finally {
                    if (statement == null) continue;
                    statement.close();
                }
            }
        }
    }

    public String getType() {
        return "MIGRATION";
    }
}

