/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.firebird.command.query.blob;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public final class FirebirdBlobIdGenerator {
    private static final FirebirdBlobIdGenerator INSTANCE = new FirebirdBlobIdGenerator();
    private final Map<Integer, AtomicLong> connectionRegistry = new ConcurrentHashMap<Integer, AtomicLong>();

    public static FirebirdBlobIdGenerator getInstance() {
        return INSTANCE;
    }

    public void registerConnection(int connectionId) {
        this.connectionRegistry.put(connectionId, new AtomicLong(0L));
    }

    public long nextBlobId(int connectionId) {
        return this.connectionRegistry.get(connectionId).incrementAndGet();
    }

    public void unregisterConnection(int connectionId) {
        this.connectionRegistry.remove(connectionId);
    }
}

