/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.route.determiner;

import java.util.Collection;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.shadow.condition.ShadowCondition;
import org.apache.shardingsphere.shadow.spi.column.ColumnShadowAlgorithm;
import org.apache.shardingsphere.shadow.spi.column.PreciseColumnShadowValue;

public final class ColumnShadowAlgorithmDeterminer {
    public static boolean isShadow(ColumnShadowAlgorithm<Comparable<?>> shadowAlgorithm, ShadowCondition shadowCondition) {
        for (PreciseColumnShadowValue<Comparable<?>> each : ColumnShadowAlgorithmDeterminer.createColumnShadowValues(shadowCondition)) {
            if (shadowCondition.getTableName().equals(shadowCondition.getColumnCondition().getTable()) && shadowAlgorithm.isShadow(each)) continue;
            return false;
        }
        return true;
    }

    private static Collection<PreciseColumnShadowValue<Comparable<?>>> createColumnShadowValues(ShadowCondition shadowCondition) {
        LinkedList result = new LinkedList();
        for (Comparable<?> each : shadowCondition.getColumnCondition().getValues()) {
            result.add(new PreciseColumnShadowValue(shadowCondition.getTableName(), shadowCondition.getOperationType(), shadowCondition.getColumnCondition().getColumn(), each));
        }
        return result;
    }

    @Generated
    private ColumnShadowAlgorithmDeterminer() {
    }
}

