/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.postgresql.handler.admin.factory;

import com.cedarsoftware.util.CaseInsensitiveMap;
import com.cedarsoftware.util.CaseInsensitiveSet;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.infra.binder.context.statement.type.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.metadata.database.schema.manager.SystemSchemaManager;
import org.apache.shardingsphere.infra.metadata.statistics.collector.DialectDatabaseStatisticsCollector;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.DatabaseAdminExecutor;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.DatabaseMetaDataExecutor;
import org.apache.shardingsphere.sql.parser.statement.core.extractor.TableExtractor;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SubqueryTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.TableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.SelectStatement;

public final class PostgreSQLSelectAdminExecutorFactory {
    private static final DatabaseType DATABASE_TYPE = (DatabaseType)TypedSPILoader.getService(DatabaseType.class, (Object)"PostgreSQL");
    private static final Map<String, Collection<String>> SCHEMA_TABLES = new CaseInsensitiveMap();

    public static Optional<DatabaseAdminExecutor> newInstance(SelectStatementContext selectStatementContext, String sql, List<Object> parameters) {
        Map<String, Collection<String>> selectedSchemaTables = PostgreSQLSelectAdminExecutorFactory.getSelectedSchemaTables(selectStatementContext.getSqlStatement());
        if (PostgreSQLSelectAdminExecutorFactory.isSelectedStatisticsSystemTable(selectedSchemaTables) || PostgreSQLSelectAdminExecutorFactory.isSelectedShardingSphereSystemTable(selectedSchemaTables)) {
            return Optional.empty();
        }
        if (PostgreSQLSelectAdminExecutorFactory.isSelectSystemTable(selectedSchemaTables)) {
            return Optional.of(new DatabaseMetaDataExecutor(sql, parameters));
        }
        return Optional.empty();
    }

    private static Map<String, Collection<String>> getSelectedSchemaTables(SelectStatement sqlStatement) {
        CaseInsensitiveMap result = new CaseInsensitiveMap();
        for (TableSegment each : PostgreSQLSelectAdminExecutorFactory.extractTables(sqlStatement)) {
            Optional ownerSegment;
            if (!(each instanceof SimpleTableSegment) || !(ownerSegment = ((SimpleTableSegment)each).getOwner()).isPresent()) continue;
            Collection tables = (Collection)result.getOrDefault(((OwnerSegment)ownerSegment.get()).getIdentifier().getValue(), new CaseInsensitiveSet());
            tables.add(((SimpleTableSegment)each).getTableName().getIdentifier().getValue());
            result.put(((OwnerSegment)ownerSegment.get()).getIdentifier().getValue(), tables);
        }
        return result;
    }

    private static Collection<TableSegment> extractTables(SelectStatement sqlStatement) {
        TableExtractor tableExtractor = new TableExtractor();
        tableExtractor.extractTablesFromSelect(sqlStatement);
        LinkedList<TableSegment> result = new LinkedList<TableSegment>(tableExtractor.getTableContext());
        for (TableSegment each : tableExtractor.getTableContext()) {
            if (!(each instanceof SubqueryTableSegment)) continue;
            TableExtractor subTableExtractor = new TableExtractor();
            subTableExtractor.extractTablesFromSelect(((SubqueryTableSegment)each).getSubquery().getSelect());
            result.addAll(subTableExtractor.getTableContext());
        }
        return result;
    }

    private static boolean isSelectedStatisticsSystemTable(Map<String, Collection<String>> selectedSchemaTables) {
        return DatabaseTypedSPILoader.findService(DialectDatabaseStatisticsCollector.class, (DatabaseType)DATABASE_TYPE).map(optional -> optional.isStatisticsTables(selectedSchemaTables)).orElse(false);
    }

    private static boolean isSelectedShardingSphereSystemTable(Map<String, Collection<String>> selectedSchemaTables) {
        if (selectedSchemaTables.isEmpty()) {
            return false;
        }
        for (Map.Entry<String, Collection<String>> each : selectedSchemaTables.entrySet()) {
            if (!SCHEMA_TABLES.containsKey(each.getKey())) {
                return false;
            }
            if (SCHEMA_TABLES.get(each.getKey()).containsAll(each.getValue())) continue;
            return false;
        }
        return true;
    }

    private static boolean isSelectSystemTable(Map<String, Collection<String>> selectedSchemaTables) {
        if (selectedSchemaTables.isEmpty()) {
            return false;
        }
        for (Map.Entry<String, Collection<String>> each : selectedSchemaTables.entrySet()) {
            if (SystemSchemaManager.isSystemTable((String)"postgresql", (String)each.getKey(), each.getValue())) continue;
            return false;
        }
        return true;
    }

    @Generated
    private PostgreSQLSelectAdminExecutorFactory() {
    }

    static {
        SCHEMA_TABLES.put("shardingsphere", (Collection<String>)new CaseInsensitiveSet(Collections.singletonList("cluster_information")));
    }
}

