/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.postgresql.command.query.extended;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.database.protocol.postgresql.packet.command.query.extended.bind.PostgreSQLTypeUnspecifiedSQLParameter;
import org.apache.shardingsphere.infra.binder.context.aware.ParameterAware;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.engine.SQLBindEngine;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.connection.kernel.KernelProcessor;
import org.apache.shardingsphere.infra.executor.audit.SQLAuditEngine;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroup;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupContext;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupReportContext;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionContext;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.ConnectionMode;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.SQLExecutorExceptionHandler;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutor;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.DatabaseConnectionManager;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.DriverExecutionPrepareEngine;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.ExecutorStatementManager;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.StorageResourceOption;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.jdbc.JDBCDriverType;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.jdbc.StatementOption;
import org.apache.shardingsphere.infra.hint.HintValueContext;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.resource.ResourceMetaData;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.proxy.backend.connector.jdbc.statement.JDBCBackendStatement;
import org.apache.shardingsphere.proxy.backend.context.BackendExecutorContext;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.query.extended.PostgreSQLServerPreparedStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;

public final class PostgreSQLBatchedStatementsExecutor {
    private final KernelProcessor kernelProcessor = new KernelProcessor();
    private final JDBCExecutor jdbcExecutor;
    private final ConnectionSession connectionSession;
    private final MetaDataContexts metaDataContexts;
    private final PostgreSQLServerPreparedStatement preparedStatement;
    private final Map<ExecutionUnit, List<List<Object>>> executionUnitParams = new HashMap<ExecutionUnit, List<List<Object>>>();
    private final ExecutionContext anyExecutionContext;
    private ExecutionGroupContext<JDBCExecutionUnit> executionGroupContext;

    public PostgreSQLBatchedStatementsExecutor(ConnectionSession connectionSession, PostgreSQLServerPreparedStatement preparedStatement, List<List<Object>> parameterSets) {
        this.jdbcExecutor = new JDBCExecutor(BackendExecutorContext.getInstance().getExecutorEngine(), connectionSession.getConnectionContext());
        this.connectionSession = connectionSession;
        this.metaDataContexts = ProxyContext.getInstance().getContextManager().getMetaDataContexts();
        this.preparedStatement = preparedStatement;
        Iterator<List<Object>> parameterSetsIterator = parameterSets.iterator();
        SQLStatementContext sqlStatementContext = null;
        ExecutionContext executionContext = null;
        if (parameterSetsIterator.hasNext()) {
            List<Object> firstGroupOfParam = parameterSetsIterator.next();
            sqlStatementContext = this.createSQLStatementContext(firstGroupOfParam, preparedStatement.getHintValueContext());
            executionContext = this.createExecutionContext(this.createQueryContext(sqlStatementContext, firstGroupOfParam, preparedStatement.getHintValueContext()));
            for (ExecutionUnit each : executionContext.getExecutionUnits()) {
                this.executionUnitParams.computeIfAbsent(each, unused -> new LinkedList()).add(each.getSqlUnit().getParameters());
            }
        }
        this.anyExecutionContext = executionContext;
        this.prepareForRestOfParametersSet(parameterSetsIterator, sqlStatementContext, preparedStatement.getHintValueContext());
    }

    private SQLStatementContext createSQLStatementContext(List<Object> params, HintValueContext hintValueContext) {
        SQLStatementContext result = new SQLBindEngine(this.metaDataContexts.getMetaData(), this.connectionSession.getCurrentDatabaseName(), hintValueContext).bind(this.preparedStatement.getSqlStatementContext().getSqlStatement());
        if (result instanceof ParameterAware) {
            ((ParameterAware)result).bindParameters(params);
        }
        return result;
    }

    private void prepareForRestOfParametersSet(Iterator<List<Object>> paramSetsIterator, SQLStatementContext sqlStatementContext, HintValueContext hintValueContext) {
        while (paramSetsIterator.hasNext()) {
            List<Object> eachGroupOfParam = paramSetsIterator.next();
            if (sqlStatementContext instanceof ParameterAware) {
                ((ParameterAware)sqlStatementContext).bindParameters(eachGroupOfParam);
            }
            ExecutionContext eachExecutionContext = this.createExecutionContext(this.createQueryContext(sqlStatementContext, eachGroupOfParam, hintValueContext));
            for (ExecutionUnit each : eachExecutionContext.getExecutionUnits()) {
                this.executionUnitParams.computeIfAbsent(each, unused -> new LinkedList()).add(each.getSqlUnit().getParameters());
            }
        }
    }

    private QueryContext createQueryContext(SQLStatementContext sqlStatementContext, List<Object> params, HintValueContext hintValueContext) {
        return new QueryContext(sqlStatementContext, this.preparedStatement.getSql(), params, hintValueContext, this.connectionSession.getConnectionContext(), this.metaDataContexts.getMetaData());
    }

    private ExecutionContext createExecutionContext(QueryContext queryContext) {
        ShardingSphereDatabase currentDatabase = this.metaDataContexts.getMetaData().getDatabase(this.connectionSession.getCurrentDatabaseName());
        SQLAuditEngine.audit((QueryContext)queryContext, (ShardingSphereDatabase)currentDatabase);
        return this.kernelProcessor.generateExecutionContext(queryContext, this.metaDataContexts.getMetaData().getGlobalRuleMetaData(), this.metaDataContexts.getMetaData().getProps());
    }

    public int executeBatch() throws SQLException {
        this.connectionSession.getDatabaseConnectionManager().handleAutoCommit();
        this.addBatchedParametersToPreparedStatements();
        return this.executeBatchedPreparedStatements();
    }

    private void addBatchedParametersToPreparedStatements() throws SQLException {
        Collection rules = this.metaDataContexts.getMetaData().getDatabase(this.connectionSession.getUsedDatabaseName()).getRuleMetaData().getRules();
        int maxConnectionsSizePerQuery = (Integer)this.metaDataContexts.getMetaData().getProps().getValue((Enum)ConfigurationPropertyKey.MAX_CONNECTIONS_SIZE_PER_QUERY);
        DriverExecutionPrepareEngine prepareEngine = new DriverExecutionPrepareEngine(JDBCDriverType.PREPARED_STATEMENT, maxConnectionsSizePerQuery, (DatabaseConnectionManager)this.connectionSession.getDatabaseConnectionManager(), (ExecutorStatementManager)((JDBCBackendStatement)this.connectionSession.getStatementManager()), (StorageResourceOption)new StatementOption(false), rules, this.metaDataContexts.getMetaData());
        this.executionGroupContext = prepareEngine.prepare(this.connectionSession.getUsedDatabaseName(), this.anyExecutionContext, this.executionUnitParams.keySet(), new ExecutionGroupReportContext(this.connectionSession.getProcessId(), this.connectionSession.getUsedDatabaseName(), this.connectionSession.getConnectionContext().getGrantee()));
        for (ExecutionGroup eachGroup : this.executionGroupContext.getInputGroups()) {
            for (JDBCExecutionUnit each : eachGroup.getInputs()) {
                this.prepareJDBCExecutionUnit(each);
            }
        }
    }

    private void prepareJDBCExecutionUnit(JDBCExecutionUnit jdbcExecutionUnit) throws SQLException {
        PreparedStatement preparedStatement = (PreparedStatement)jdbcExecutionUnit.getStorageResource();
        for (List eachGroupParam : this.executionUnitParams.getOrDefault(jdbcExecutionUnit.getExecutionUnit(), Collections.emptyList())) {
            ListIterator params = eachGroupParam.listIterator();
            while (params.hasNext()) {
                int paramIndex = params.nextIndex() + 1;
                Object value = params.next();
                if (value instanceof PostgreSQLTypeUnspecifiedSQLParameter) {
                    value = value.toString();
                }
                preparedStatement.setObject(paramIndex, value);
            }
            preparedStatement.addBatch();
        }
    }

    private int executeBatchedPreparedStatements() throws SQLException {
        boolean isExceptionThrown = SQLExecutorExceptionHandler.isExceptionThrown();
        ShardingSphereDatabase database = this.metaDataContexts.getMetaData().getDatabase(this.connectionSession.getUsedDatabaseName());
        DatabaseType protocolType = database.getProtocolType();
        BatchedStatementsJDBCExecutorCallback callback = new BatchedStatementsJDBCExecutorCallback(protocolType, database.getResourceMetaData(), this.preparedStatement.getSqlStatementContext().getSqlStatement(), isExceptionThrown);
        List executeResults = this.jdbcExecutor.execute(this.executionGroupContext, (JDBCExecutorCallback)callback);
        int result = 0;
        Iterator iterator = executeResults.iterator();
        while (iterator.hasNext()) {
            int[] eachResult;
            for (int each : eachResult = (int[])iterator.next()) {
                result += each;
            }
        }
        return result;
    }

    private static final class BatchedStatementsJDBCExecutorCallback
    extends JDBCExecutorCallback<int[]> {
        private BatchedStatementsJDBCExecutorCallback(DatabaseType protocolType, ResourceMetaData resourceMetaData, SQLStatement sqlStatement, boolean isExceptionThrown) {
            super(protocolType, resourceMetaData, sqlStatement, isExceptionThrown);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected int[] executeSQL(String sql, Statement statement, ConnectionMode connectionMode, DatabaseType storageType) throws SQLException {
            try {
                int[] nArray = statement.executeBatch();
                return nArray;
            }
            finally {
                statement.close();
            }
        }

        protected Optional<int[]> getSaneResult(SQLStatement sqlStatement, SQLException ex) {
            return Optional.empty();
        }
    }
}

