/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.tracing.rdb.config;

import com.google.common.base.CaseFormat;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.spi.tracing.storage.TracingStorageConfiguration;
import org.apache.shardingsphere.elasticjob.tracing.rdb.storage.datasource.DataSourceRegistry;
import org.apache.shardingsphere.elasticjob.tracing.rdb.storage.datasource.JDBCParameterDecorator;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;

public final class RDBTracingStorageConfiguration
implements TracingStorageConfiguration<DataSource> {
    private static final String GETTER_PREFIX = "get";
    private static final String SETTER_PREFIX = "set";
    private static final Collection<Class<?>> GENERAL_CLASS_TYPE = Sets.newHashSet((Object[])new Class[]{Boolean.TYPE, Boolean.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, String.class, Collection.class, List.class});
    private static final Collection<String> SKIPPED_PROPERTY_NAMES = Sets.newHashSet((Object[])new String[]{"loginTimeout"});
    private final String dataSourceClassName;
    private final Map<String, Object> props = new LinkedHashMap<String, Object>();

    public static RDBTracingStorageConfiguration getDataSourceConfiguration(DataSource dataSource) {
        RDBTracingStorageConfiguration result = new RDBTracingStorageConfiguration(dataSource.getClass().getName());
        result.props.putAll(RDBTracingStorageConfiguration.findAllGetterProperties(dataSource));
        return result;
    }

    private static Map<String, Object> findAllGetterProperties(Object target) {
        Collection<Method> allGetterMethods = RDBTracingStorageConfiguration.findAllGetterMethods(target.getClass());
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(allGetterMethods.size(), 1.0f);
        for (Method each : allGetterMethods) {
            String propertyName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, each.getName().substring(GETTER_PREFIX.length()));
            if (!GENERAL_CLASS_TYPE.contains(each.getReturnType()) || SKIPPED_PROPERTY_NAMES.contains(propertyName)) continue;
            Optional.ofNullable(each.invoke(target, new Object[0])).ifPresent(propertyValue -> result.put(propertyName, propertyValue));
        }
        return result;
    }

    private static Collection<Method> findAllGetterMethods(Class<?> clazz) {
        Method[] methods = clazz.getMethods();
        HashSet<Method> result = new HashSet<Method>(methods.length);
        for (Method each : methods) {
            if (!each.getName().startsWith(GETTER_PREFIX) || 0 != each.getParameterTypes().length) continue;
            result.add(each);
        }
        return result;
    }

    public DataSource createDataSource() {
        DataSource result = (DataSource)Class.forName(this.dataSourceClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
        Method[] methods = result.getClass().getMethods();
        for (Map.Entry<String, Object> entry : this.props.entrySet()) {
            Optional<Method> setterMethod;
            if (SKIPPED_PROPERTY_NAMES.contains(entry.getKey()) || !(setterMethod = this.findSetterMethod(methods, entry.getKey())).isPresent()) continue;
            setterMethod.get().invoke((Object)result, entry.getValue());
        }
        Optional decorator = TypedSPILoader.findService(JDBCParameterDecorator.class, result.getClass());
        return decorator.isPresent() ? ((JDBCParameterDecorator)decorator.get()).decorate(result) : result;
    }

    private Optional<Method> findSetterMethod(Method[] methods, String property) {
        String setterMethodName = Joiner.on((String)"").join((Object)SETTER_PREFIX, (Object)CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, property), new Object[0]);
        for (Method each : methods) {
            if (!each.getName().equals(setterMethodName) || 1 != each.getParameterTypes().length) continue;
            return Optional.of(each);
        }
        return Optional.empty();
    }

    public DataSource getStorage() {
        return DataSourceRegistry.getInstance().getDataSource(this);
    }

    public boolean equals(Object obj) {
        return this == obj || null != obj && this.getClass() == obj.getClass() && this.equalsByProperties((RDBTracingStorageConfiguration)obj);
    }

    private boolean equalsByProperties(RDBTracingStorageConfiguration dataSourceConfig) {
        return this.dataSourceClassName.equals(dataSourceConfig.dataSourceClassName) && this.props.equals(dataSourceConfig.props);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.dataSourceClassName, this.props});
    }

    @Generated
    public RDBTracingStorageConfiguration(String dataSourceClassName) {
        this.dataSourceClassName = dataSourceClassName;
    }

    @Generated
    public String getDataSourceClassName() {
        return this.dataSourceClassName;
    }

    @Generated
    public Map<String, Object> getProps() {
        return this.props;
    }
}

