/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.banyandb.stream;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.skywalking.banyandb.v1.client.RowEntity;
import org.apache.skywalking.banyandb.v1.client.StreamQuery;
import org.apache.skywalking.banyandb.v1.client.StreamQueryResponse;
import org.apache.skywalking.oap.server.core.profiling.ebpf.storage.EBPFProfilingDataRecord;
import org.apache.skywalking.oap.server.core.storage.profiling.ebpf.IEBPFProfilingDataDAO;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBConverter;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBStorageClient;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.AbstractBanyanDBDAO;

public class BanyanDBEBPFProfilingDataDAO
extends AbstractBanyanDBDAO
implements IEBPFProfilingDataDAO {
    private static final Set<String> TAGS = ImmutableSet.of((Object)"upload_time", (Object)"schedule_id", (Object)"stack_id", (Object)"target_type", (Object)"dump_binary", (Object)"task_id", (Object[])new String[0]);
    private final int profileDataQueryBatchSize;

    public BanyanDBEBPFProfilingDataDAO(BanyanDBStorageClient client, int profileDataQueryBatchSize) {
        super(client);
        this.profileDataQueryBatchSize = profileDataQueryBatchSize;
    }

    public List<EBPFProfilingDataRecord> queryData(List<String> scheduleIdList, final long beginTime, final long endTime) throws IOException {
        ArrayList<EBPFProfilingDataRecord> records = new ArrayList<EBPFProfilingDataRecord>();
        for (final String scheduleId : scheduleIdList) {
            StreamQueryResponse resp = this.query(false, "ebpf_profiling_data", TAGS, new AbstractBanyanDBDAO.QueryBuilder<StreamQuery>(){

                @Override
                protected void apply(StreamQuery query) {
                    query.and(this.eq("schedule_id", scheduleId));
                    query.and(this.gte("upload_time", beginTime));
                    query.and(this.lte("upload_time", endTime));
                    query.setLimit(BanyanDBEBPFProfilingDataDAO.this.profileDataQueryBatchSize);
                }
            });
            records.addAll(resp.getElements().stream().map(this::buildDataRecord).collect(Collectors.toList()));
        }
        return records;
    }

    private EBPFProfilingDataRecord buildDataRecord(RowEntity rowEntity) {
        EBPFProfilingDataRecord.Builder builder = new EBPFProfilingDataRecord.Builder();
        return builder.storage2Entity((Convert2Entity)new BanyanDBConverter.StorageToStream("ebpf_profiling_data", rowEntity));
    }
}

