/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.remote;

import java.util.List;
import org.apache.skywalking.oap.server.core.remote.client.RemoteClient;
import org.apache.skywalking.oap.server.core.remote.client.RemoteClientManager;
import org.apache.skywalking.oap.server.core.remote.data.StreamData;
import org.apache.skywalking.oap.server.core.remote.selector.ForeverFirstSelector;
import org.apache.skywalking.oap.server.core.remote.selector.HashCodeSelector;
import org.apache.skywalking.oap.server.core.remote.selector.RollingSelector;
import org.apache.skywalking.oap.server.core.remote.selector.Selector;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.module.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteSenderService
implements Service {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteSenderService.class);
    private final ModuleManager moduleManager;
    private final HashCodeSelector hashCodeSelector;
    private final ForeverFirstSelector foreverFirstSelector;
    private final RollingSelector rollingSelector;

    public RemoteSenderService(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
        this.hashCodeSelector = new HashCodeSelector();
        this.foreverFirstSelector = new ForeverFirstSelector();
        this.rollingSelector = new RollingSelector();
    }

    public void send(String nextWorkName, StreamData streamData, Selector selector) {
        RemoteClientManager clientManager = (RemoteClientManager)this.moduleManager.find("core").provider().getService(RemoteClientManager.class);
        RemoteClient remoteClient = null;
        List<RemoteClient> clientList = clientManager.getRemoteClient();
        if (clientList.size() == 0) {
            LOGGER.warn("There is no available remote server for now, ignore the streaming data until the cluster metadata initialized.");
            return;
        }
        switch (selector) {
            case HashCode: {
                remoteClient = this.hashCodeSelector.select(clientList, streamData);
                break;
            }
            case Rolling: {
                remoteClient = this.rollingSelector.select(clientList, streamData);
                break;
            }
            case ForeverFirst: {
                remoteClient = this.foreverFirstSelector.select(clientList, streamData);
            }
        }
        remoteClient.push(nextWorkName, streamData);
    }
}

