/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.message.AlterPartitionResponseData;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.Errors;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.requests.AbstractResponse;

public class AlterPartitionResponse
extends AbstractResponse {
    private final AlterPartitionResponseData data;

    public AlterPartitionResponse(AlterPartitionResponseData data) {
        super(ApiKeys.ALTER_PARTITION);
        this.data = data;
    }

    @Override
    public AlterPartitionResponseData data() {
        return this.data;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> counts = new HashMap<Errors, Integer>();
        this.updateErrorCounts(counts, Errors.forCode(this.data.errorCode()));
        this.data.topics().forEach(topicResponse -> topicResponse.partitions().forEach(partitionResponse -> this.updateErrorCounts(counts, Errors.forCode(partitionResponse.errorCode()))));
        return counts;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    public static AlterPartitionResponse parse(ByteBuffer buffer, short version) {
        return new AlterPartitionResponse(new AlterPartitionResponseData(new ByteBufferAccessor(buffer), version));
    }
}

