/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.meter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.skywalking.apm.agent.core.meter.AbstractBuilder;
import org.apache.skywalking.apm.agent.core.meter.BaseMeter;
import org.apache.skywalking.apm.agent.core.meter.MeterId;
import org.apache.skywalking.apm.agent.core.meter.MeterType;
import org.apache.skywalking.apm.network.language.agent.v3.MeterBucketValue;
import org.apache.skywalking.apm.network.language.agent.v3.MeterData;
import org.apache.skywalking.apm.network.language.agent.v3.MeterHistogram;

public class Histogram
extends BaseMeter {
    protected final Bucket[] buckets;

    public Histogram(MeterId meterId, List<Double> steps) {
        super(meterId);
        this.buckets = this.initBuckets(steps);
    }

    public void addValue(double value) {
        Bucket bucket = this.findBucket(value);
        if (bucket == null) {
            return;
        }
        bucket.increment(1L);
    }

    private Bucket findBucket(double value) {
        int low = 0;
        int high = this.buckets.length - 1;
        while (low <= high) {
            int mid = (low + high) / 2;
            if (this.buckets[mid].bucket < value) {
                low = mid + 1;
                continue;
            }
            if (this.buckets[mid].bucket > value) {
                high = mid - 1;
                continue;
            }
            return this.buckets[mid];
        }
        return --low < this.buckets.length && low >= 0 ? this.buckets[low] : null;
    }

    private Bucket[] initBuckets(List<Double> steps) {
        return (Bucket[])steps.stream().map(Bucket::new).toArray(Bucket[]::new);
    }

    @Override
    public MeterData.Builder transform() {
        MeterData.Builder builder = MeterData.newBuilder();
        List values = Arrays.stream(this.buckets).map(Bucket::transform).collect(Collectors.toList());
        return builder.setHistogram(MeterHistogram.newBuilder().setName(this.getName()).addAllLabels(this.transformTags()).addAllValues(values).build());
    }

    protected static class Bucket {
        protected double bucket;
        protected AtomicLong count = new AtomicLong();

        public Bucket(double bucket) {
            this.bucket = bucket;
        }

        public void increment(long count) {
            this.count.addAndGet(count);
        }

        public MeterBucketValue transform() {
            return MeterBucketValue.newBuilder().setBucket(this.bucket).setCount(this.count.get()).build();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Bucket bucket1 = (Bucket)o;
            return this.bucket == bucket1.bucket;
        }

        public int hashCode() {
            return Objects.hash(this.bucket);
        }
    }

    public static class Builder
    extends AbstractBuilder<Builder, Histogram> {
        private double minValue = 0.0;
        private List<Double> steps;

        public Builder(String name) {
            super(name);
        }

        public Builder steps(List<Double> steps) {
            this.steps = new ArrayList<Double>(steps);
            return this;
        }

        public Builder minValue(double minValue) {
            this.minValue = minValue;
            return this;
        }

        @Override
        protected MeterType getType() {
            return MeterType.HISTOGRAM;
        }

        @Override
        protected Histogram create(MeterId meterId) {
            if (this.steps == null || this.steps.isEmpty()) {
                throw new IllegalArgumentException("Missing steps setting");
            }
            this.steps = this.steps.stream().distinct().sorted().collect(Collectors.toList());
            if (this.steps.get(0) < this.minValue) {
                throw new IllegalArgumentException("Step[0] must be bigger than min value");
            }
            if (this.steps.get(0) != this.minValue) {
                this.steps.add(0, this.minValue);
            }
            return new Histogram(meterId, this.steps);
        }
    }
}

