/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.meter.micrometer;

import io.micrometer.core.instrument.AbstractTimer;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.core.instrument.distribution.pause.PauseDetector;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.DoubleAccumulator;
import org.apache.skywalking.apm.meter.micrometer.MeterBuilder;
import org.apache.skywalking.apm.meter.micrometer.SkywalkingConfig;
import org.apache.skywalking.apm.toolkit.meter.Counter;
import org.apache.skywalking.apm.toolkit.meter.Gauge;
import org.apache.skywalking.apm.toolkit.meter.Histogram;
import org.apache.skywalking.apm.toolkit.meter.MeterFactory;
import org.apache.skywalking.apm.toolkit.meter.MeterId;

public class SkywalkingTimer
extends AbstractTimer {
    private final Counter counter;
    private final Counter sum;
    private final Gauge max;
    private final DoubleAccumulator maxAdder;
    private final Optional<Histogram> histogram;

    protected SkywalkingTimer(Meter.Id id, MeterId meterId, SkywalkingConfig config, Clock clock, DistributionStatisticConfig distributionStatisticConfig, PauseDetector pauseDetector, TimeUnit baseTimeUnit, boolean supportsAggregablePercentiles) {
        super(id, clock, distributionStatisticConfig, pauseDetector, baseTimeUnit, supportsAggregablePercentiles);
        String baseName = meterId.getName();
        this.counter = MeterBuilder.buildCounter(meterId.copyTo(baseName + "_count", MeterId.MeterType.COUNTER), config);
        this.sum = MeterBuilder.buildCounter(meterId.copyTo(baseName + "_sum", MeterId.MeterType.COUNTER), config);
        this.maxAdder = new DoubleAccumulator((a, b) -> a > b ? a : b, 0.0);
        this.max = (Gauge)MeterFactory.gauge(meterId.copyTo(baseName + "_max", MeterId.MeterType.GAUGE), () -> this.maxAdder.doubleValue()).build();
        this.histogram = MeterBuilder.buildHistogram(meterId, supportsAggregablePercentiles, distributionStatisticConfig, true);
    }

    protected void recordNonNegative(long amount, TimeUnit unit) {
        this.counter.increment(1.0);
        long amountToMillisecond = TimeUnit.MILLISECONDS.convert(amount, unit);
        this.sum.increment(amountToMillisecond);
        this.maxAdder.accumulate(amountToMillisecond);
        this.histogram.ifPresent(h -> h.addValue(amountToMillisecond));
    }

    public long count() {
        return (long)this.counter.get();
    }

    public double totalTime(TimeUnit unit) {
        return unit.convert((long)this.sum.get(), TimeUnit.MILLISECONDS);
    }

    public double max(TimeUnit unit) {
        return unit.convert((long)this.max.get(), TimeUnit.MILLISECONDS);
    }
}

