/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.parser;

import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.antlr.v4.runtime.tree.TerminalNodeImpl;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.catalyst.trees.Origin;
import org.apache.spark.sql.catalyst.util.SparkParserUtils;
import org.apache.spark.sql.errors.QueryParsingErrors$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.util.matching.Regex;

public final class ParserUtils$
implements SparkParserUtils {
    public static ParserUtils$ MODULE$;
    private final Regex escapedIdentifier;
    private final Regex qualifiedEscapedIdentifier;
    private final Regex U16_CHAR_PATTERN;
    private final Regex U32_CHAR_PATTERN;
    private final Regex OCTAL_CHAR_PATTERN;
    private final Regex ESCAPED_CHAR_PATTERN;

    static {
        new ParserUtils$();
    }

    public String unescapeSQLString(String b) {
        return SparkParserUtils.unescapeSQLString$((SparkParserUtils)this, (String)b);
    }

    public String string(Token token) {
        return SparkParserUtils.string$((SparkParserUtils)this, (Token)token);
    }

    public String string(TerminalNode node) {
        return SparkParserUtils.string$((SparkParserUtils)this, (TerminalNode)node);
    }

    public Origin position(Token token) {
        return SparkParserUtils.position$((SparkParserUtils)this, (Token)token);
    }

    public <T> T withOrigin(ParserRuleContext ctx, Option<String> sqlText, Function0<T> f) {
        return (T)SparkParserUtils.withOrigin$((SparkParserUtils)this, (ParserRuleContext)ctx, sqlText, f);
    }

    public <T> Option<String> withOrigin$default$2() {
        return SparkParserUtils.withOrigin$default$2$((SparkParserUtils)this);
    }

    public Origin positionAndText(Token startToken, Token stopToken, String sqlText, Option<String> objectType, Option<String> objectName) {
        return SparkParserUtils.positionAndText$((SparkParserUtils)this, (Token)startToken, (Token)stopToken, (String)sqlText, objectType, objectName);
    }

    public String command(ParserRuleContext ctx) {
        return SparkParserUtils.command$((SparkParserUtils)this, (ParserRuleContext)ctx);
    }

    public Regex U16_CHAR_PATTERN() {
        return this.U16_CHAR_PATTERN;
    }

    public Regex U32_CHAR_PATTERN() {
        return this.U32_CHAR_PATTERN;
    }

    public Regex OCTAL_CHAR_PATTERN() {
        return this.OCTAL_CHAR_PATTERN;
    }

    public Regex ESCAPED_CHAR_PATTERN() {
        return this.ESCAPED_CHAR_PATTERN;
    }

    public void org$apache$spark$sql$catalyst$util$SparkParserUtils$_setter_$U16_CHAR_PATTERN_$eq(Regex x$1) {
        this.U16_CHAR_PATTERN = x$1;
    }

    public void org$apache$spark$sql$catalyst$util$SparkParserUtils$_setter_$U32_CHAR_PATTERN_$eq(Regex x$1) {
        this.U32_CHAR_PATTERN = x$1;
    }

    public void org$apache$spark$sql$catalyst$util$SparkParserUtils$_setter_$OCTAL_CHAR_PATTERN_$eq(Regex x$1) {
        this.OCTAL_CHAR_PATTERN = x$1;
    }

    public void org$apache$spark$sql$catalyst$util$SparkParserUtils$_setter_$ESCAPED_CHAR_PATTERN_$eq(Regex x$1) {
        this.ESCAPED_CHAR_PATTERN = x$1;
    }

    public Nothing$ operationNotAllowed(String message, ParserRuleContext ctx) {
        throw QueryParsingErrors$.MODULE$.operationNotAllowedError(message, ctx);
    }

    public <T> void checkDuplicateClauses(List<T> nodes, String clauseName, ParserRuleContext ctx) {
        if (nodes.size() > 1) {
            throw QueryParsingErrors$.MODULE$.duplicateClausesError(clauseName, ctx);
        }
    }

    public <T> void checkDuplicateKeys(Seq<Tuple2<String, T>> keyPairs, ParserRuleContext ctx) {
        ((IterableLike)keyPairs.groupBy((Function1 & Serializable & scala.Serializable)x$1 -> (String)x$1._1()).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ParserUtils$.$anonfun$checkDuplicateKeys$2(x$2)))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                throw QueryParsingErrors$.MODULE$.duplicateKeysError(key, ctx);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public String source(ParserRuleContext ctx) {
        CharStream stream = ctx.getStart().getInputStream();
        return stream.getText(Interval.of((int)ctx.getStart().getStartIndex(), (int)ctx.getStop().getStopIndex()));
    }

    public String remainder(ParserRuleContext ctx) {
        return this.remainder(ctx.getStop());
    }

    public String remainder(Token token) {
        CharStream stream = token.getInputStream();
        Interval interval = Interval.of((int)(token.getStopIndex() + 1), (int)(stream.size() - 1));
        return stream.getText(interval);
    }

    public String interval(Token start, Token end) {
        Interval interval = Interval.of((int)(start.getStopIndex() + 1), (int)(end.getStartIndex() - 1));
        return start.getInputStream().getText(interval);
    }

    public String stringWithoutUnescape(Token node) {
        return StringOps$.MODULE$.slice$extension(Predef$.MODULE$.augmentString(node.getText()), 1, new StringOps(Predef$.MODULE$.augmentString(node.getText())).size() - 1);
    }

    public Seq<Tuple2<String, String>> entry(String key, Token value) {
        return (Seq)Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)value)).toSeq().map((Function1 & Serializable & scala.Serializable)x -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)MODULE$.string((Token)x)), Seq$.MODULE$.canBuildFrom());
    }

    public void validate(Function0<Object> f, String message, ParserRuleContext ctx) {
        if (!f.apply$mcZ$sp()) {
            throw new ParseException("_LEGACY_ERROR_TEMP_0064", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"msg"), (Object)message)})), ctx);
        }
    }

    public Regex escapedIdentifier() {
        return this.escapedIdentifier;
    }

    public Regex qualifiedEscapedIdentifier() {
        return this.qualifiedEscapedIdentifier;
    }

    public String toExprAlias(ParseTree ctx) {
        StringBuilder sb = new StringBuilder();
        ParserUtils$.concatTerms$1(ctx, sb);
        return sb.toString();
    }

    public static final /* synthetic */ boolean $anonfun$checkDuplicateKeys$2(Tuple2 x$2) {
        return ((SeqLike)x$2._2()).size() > 1;
    }

    public static final /* synthetic */ Object $anonfun$toExprAlias$1(ParseTree ctx$2, StringBuilder sb$1, int i) {
        ParseTree parseTree = ctx$2.getChild(i);
        if (parseTree instanceof TerminalNodeImpl) {
            TerminalNodeImpl terminalNodeImpl = (TerminalNodeImpl)parseTree;
            String termText = terminalNodeImpl.getText();
            int tt = terminalNodeImpl.getSymbol().getType();
            String current = 8 <= tt && tt <= 336 || 363 <= tt && tt <= 371 ? termText.toUpperCase(Locale.ROOT) : termText;
            return sb$1.append(current);
        }
        ParserUtils$.concatTerms$1(parseTree, sb$1);
        return BoxedUnit.UNIT;
    }

    private static final void concatTerms$1(ParseTree ctx, StringBuilder sb$1) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), ctx.getChildCount()).foreach((Function1 & Serializable & scala.Serializable)i -> ParserUtils$.$anonfun$toExprAlias$1(ctx, sb$1, BoxesRunTime.unboxToInt((Object)i)));
    }

    private ParserUtils$() {
        MODULE$ = this;
        SparkParserUtils.$init$((SparkParserUtils)this);
        this.escapedIdentifier = new StringOps(Predef$.MODULE$.augmentString("`((?s).+)`")).r();
        this.qualifiedEscapedIdentifier = new StringOps(Predef$.MODULE$.augmentString("((?s).+).`((?s).+)`")).r();
    }
}

