/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.FrameLessOffsetWindowFunction;
import org.apache.spark.sql.catalyst.expressions.Lag$;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.UnaryMinus;
import org.apache.spark.sql.catalyst.expressions.UnaryMinus$;
import org.apache.spark.sql.catalyst.expressions.WindowExpression$;
import org.apache.spark.sql.catalyst.expressions.package$;
import org.apache.spark.sql.catalyst.trees.TernaryLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@ExpressionDescription(usage="\n    _FUNC_(input[, offset[, default]]) - Returns the value of `input` at the `offset`th row\n      before the current row in the window. The default value of `offset` is 1 and the default\n      value of `default` is null. If the value of `input` at the `offset`th row is null,\n      null is returned. If there is no such offset row (e.g., when the offset is 1, the first\n      row of the window does not have any previous row), `default` is returned.\n  ", arguments="\n    Arguments:\n      * input - a string expression to evaluate `offset` rows before the current row.\n      * offset - an int expression which is rows to jump back in the partition.\n      * default - a string expression which is to use when the offset row does not exist.\n  ", examples="\n    Examples:\n      > SELECT a, b, _FUNC_(b) OVER (PARTITION BY a ORDER BY b) FROM VALUES ('A1', 2), ('A1', 1), ('A2', 3), ('A1', 1) tab(a, b);\n       A1\t1\tNULL\n       A1\t1\t1\n       A1\t2\t1\n       A2\t3\tNULL\n  ", since="2.0.0", group="window_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005mh\u0001\u0002\u0015*\u0001ZB\u0001B\u0016\u0001\u0003\u0016\u0004%\ta\u0016\u0005\t1\u0002\u0011\t\u0012)A\u0005\u0003\"A\u0011\f\u0001BK\u0002\u0013\u0005q\u000b\u0003\u0005[\u0001\tE\t\u0015!\u0003B\u0011!Y\u0006A!f\u0001\n\u00039\u0006\u0002\u0003/\u0001\u0005#\u0005\u000b\u0011B!\t\u0011u\u0003!Q3A\u0005\u0002yC\u0001B\u0019\u0001\u0003\u0012\u0003\u0006Ia\u0018\u0005\u0006G\u0002!\t\u0001\u001a\u0005\u0006G\u0002!\tA\u001b\u0005\u0006G\u0002!\tA\u001c\u0005\u0006G\u0002!\t\u0001\u001e\u0005\u0006G\u0002!\ta\u001e\u0005\u0006G\u0002!\t!\u001f\u0005\bc\u0002\u0011\r\u0011\"\u0011X\u0011\u0019Q\b\u0001)A\u0005\u0003\")1\u0010\u0001C!/\")A\u0010\u0001C!/\")Q\u0010\u0001C!/\")a\u0010\u0001C)\u007f\"I\u0011Q\u0002\u0001\u0002\u0002\u0013\u0005\u0011q\u0002\u0005\n\u00033\u0001\u0011\u0013!C\u0001\u00037A\u0011\"!\r\u0001#\u0003%\t!a\u0007\t\u0013\u0005M\u0002!%A\u0005\u0002\u0005m\u0001\"CA\u001b\u0001E\u0005I\u0011AA\u001c\u0011%\tY\u0004AA\u0001\n\u0003\ni\u0004C\u0005\u0002P\u0001\t\t\u0011\"\u0001\u0002R!I\u0011\u0011\f\u0001\u0002\u0002\u0013\u0005\u00111\f\u0005\n\u0003O\u0002\u0011\u0011!C!\u0003SB\u0011\"a\u001e\u0001\u0003\u0003%\t!!\u001f\t\u0013\u0005u\u0004!!A\u0005B\u0005}\u0004\"CAB\u0001\u0005\u0005I\u0011IAC\u000f%\ty+KA\u0001\u0012\u0003\t\tL\u0002\u0005)S\u0005\u0005\t\u0012AAZ\u0011\u0019\u0019'\u0005\"\u0001\u0002L\"I\u0011Q\u001a\u0012\u0002\u0002\u0013\u0015\u0013q\u001a\u0005\n\u0003#\u0014\u0013\u0011!CA\u0003'D\u0011\"!8#\u0003\u0003%\t)a8\t\u0013\u0005E(%!A\u0005\n\u0005M(a\u0001'bO*\u0011!fK\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002-[\u0005A1-\u0019;bYf\u001cHO\u0003\u0002/_\u0005\u00191/\u001d7\u000b\u0005A\n\u0014!B:qCJ\\'B\u0001\u001a4\u0003\u0019\t\u0007/Y2iK*\tA'A\u0002pe\u001e\u001c\u0001aE\u0003\u0001om\"%\n\u0005\u00029s5\t\u0011&\u0003\u0002;S\tibI]1nK2+7o](gMN,GoV5oI><h)\u001e8di&|g\u000eE\u0002=\u007f\u0005k\u0011!\u0010\u0006\u0003}-\nQ\u0001\u001e:fKNL!\u0001Q\u001f\u0003\u0017Q+'O\\1ss2K7.\u001a\t\u0003q\tK!aQ\u0015\u0003\u0015\u0015C\bO]3tg&|g\u000e\u0005\u0002F\u00116\taIC\u0001H\u0003\u0015\u00198-\u00197b\u0013\tIeIA\u0004Qe>$Wo\u0019;\u0011\u0005-\u001bfB\u0001'R\u001d\ti\u0005+D\u0001O\u0015\tyU'\u0001\u0004=e>|GOP\u0005\u0002\u000f&\u0011!KR\u0001\ba\u0006\u001c7.Y4f\u0013\t!VK\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002S\r\u0006)\u0011N\u001c9viV\t\u0011)\u0001\u0004j]B,H\u000fI\u0001\fS:\u0004X\u000f^(gMN,G/\u0001\u0007j]B,Ho\u00144gg\u0016$\b%A\u0004eK\u001a\fW\u000f\u001c;\u0002\u0011\u0011,g-Y;mi\u0002\n1\"[4o_J,g*\u001e7mgV\tq\f\u0005\u0002FA&\u0011\u0011M\u0012\u0002\b\u0005>|G.Z1o\u00031IwM\\8sK:+H\u000e\\:!\u0003\u0019a\u0014N\\5u}Q)QMZ4iSB\u0011\u0001\b\u0001\u0005\u0006-&\u0001\r!\u0011\u0005\u00063&\u0001\r!\u0011\u0005\u00067&\u0001\r!\u0011\u0005\u0006;&\u0001\ra\u0018\u000b\u0005K.dW\u000eC\u0003W\u0015\u0001\u0007\u0011\tC\u0003Z\u0015\u0001\u0007\u0011\tC\u0003\\\u0015\u0001\u0007\u0011\tF\u0003f_B\u00148\u000fC\u0003W\u0017\u0001\u0007\u0011\tC\u0003r\u0017\u0001\u0007\u0011)\u0001\u0004pM\u001a\u001cX\r\u001e\u0005\u00067.\u0001\r!\u0011\u0005\u0006;.\u0001\r!\u0011\u000b\u0004KV4\b\"\u0002,\r\u0001\u0004\t\u0005\"B-\r\u0001\u0004\tECA3y\u0011\u00151V\u00021\u0001B)\u0005)\u0017aB8gMN,G\u000fI\u0001\u0006M&\u00148\u000f^\u0001\u0007g\u0016\u001cwN\u001c3\u0002\u000bQD\u0017N\u001d3\u0002/]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3sK:Le\u000e^3s]\u0006dGcB3\u0002\u0002\u0005\u0015\u0011\u0011\u0002\u0005\u0007\u0003\u0007!\u0002\u0019A!\u0002\u00119,wOR5sgRDa!a\u0002\u0015\u0001\u0004\t\u0015!\u00038foN+7m\u001c8e\u0011\u0019\tY\u0001\u0006a\u0001\u0003\u0006Aa.Z<UQ&\u0014H-\u0001\u0003d_BLH#C3\u0002\u0012\u0005M\u0011QCA\f\u0011\u001d1V\u0003%AA\u0002\u0005Cq!W\u000b\u0011\u0002\u0003\u0007\u0011\tC\u0004\\+A\u0005\t\u0019A!\t\u000fu+\u0002\u0013!a\u0001?\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA\u000fU\r\t\u0015qD\u0016\u0003\u0003C\u0001B!a\t\u0002.5\u0011\u0011Q\u0005\u0006\u0005\u0003O\tI#A\u0005v]\u000eDWmY6fI*\u0019\u00111\u0006$\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u00020\u0005\u0015\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014AD2paf$C-\u001a4bk2$HeM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00135+\t\tIDK\u0002`\u0003?\tQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA !\u0011\t\t%a\u0013\u000e\u0005\u0005\r#\u0002BA#\u0003\u000f\nA\u0001\\1oO*\u0011\u0011\u0011J\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002N\u0005\r#AB*ue&tw-\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002TA\u0019Q)!\u0016\n\u0007\u0005]cIA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002^\u0005\r\u0004cA#\u0002`%\u0019\u0011\u0011\r$\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002fq\t\t\u00111\u0001\u0002T\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a\u001b\u0011\r\u00055\u00141OA/\u001b\t\tyGC\u0002\u0002r\u0019\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\t)(a\u001c\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004?\u0006m\u0004\"CA3=\u0005\u0005\t\u0019AA/\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005}\u0012\u0011\u0011\u0005\n\u0003Kz\u0012\u0011!a\u0001\u0003'\na!Z9vC2\u001cHcA0\u0002\b\"I\u0011Q\r\u0011\u0002\u0002\u0003\u0007\u0011Q\f\u0015\u0018\u0001\u0005-\u0015\u0011SAJ\u0003/\u000bI*!(\u0002 \u0006\r\u0016QUAU\u0003W\u00032\u0001OAG\u0013\r\ty)\u000b\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\t)*ABF\u0015\u0001\u0002\u0003\u0005I0G+:\u001bu\fK5oaV$8\f\f\u0011pM\u001a\u001cX\r^.-A\u0011,g-Y;mivk\u0016\u0006I\u0017!%\u0016$XO\u001d8tAQDW\r\t<bYV,\u0007e\u001c4!A&t\u0007/\u001e;aA\u0005$\b\u0005\u001e5fA\u0001|gMZ:fi\u0002$\b\u000e\t:po*\u0001\u0003\u0005\t\u0011!A\t,gm\u001c:fAQDW\rI2veJ,g\u000e\u001e\u0011s_^\u0004\u0013N\u001c\u0011uQ\u0016\u0004s/\u001b8e_^t\u0003\u0005\u00165fA\u0011,g-Y;mi\u00022\u0018\r\\;fA=4\u0007\u0005Y8gMN,G\u000f\u0019\u0011jg\u0002\n\u0004%\u00198eAQDW\r\t3fM\u0006,H\u000e\u001e\u0006!A\u0001\u0002\u0003\u0005\t<bYV,\u0007e\u001c4!A\u0012,g-Y;mi\u0002\u0004\u0013n\u001d\u0011ok2dg\u0006I%gAQDW\r\t<bYV,\u0007e\u001c4!A&t\u0007/\u001e;aA\u0005$\b\u0005\u001e5fA\u0001|gMZ:fi\u0002$\b\u000e\t:po\u0002J7\u000f\t8vY2d#\u0002\t\u0011!A\u0001\u0002c.\u001e7mA%\u001c\bE]3ukJtW\r\u001a\u0018!\u0013\u001a\u0004C\u000f[3sK\u0002J7\u000f\t8pAM,8\r\u001b\u0011pM\u001a\u001cX\r\u001e\u0011s_^\u0004\u0003&\u001a\u0018h]1\u0002s\u000f[3oAQDW\rI8gMN,G\u000fI5tAEb\u0003\u0005\u001e5fA\u0019L'o\u001d;\u000bA\u0001\u0002\u0003\u0005\t\u0011s_^\u0004sN\u001a\u0011uQ\u0016\u0004s/\u001b8e_^\u0004Cm\\3tA9|G\u000f\t5bm\u0016\u0004\u0013M\\=!aJ,g/[8vg\u0002\u0012xn^\u0015-A\u0001$WMZ1vYR\u0004\u0007%[:!e\u0016$XO\u001d8fI:R\u0001\u0005I\u0001\nCJ<W/\\3oiN\f#!a'\u0002\u0005KQ\u0001\u0005\t\u0011!\u0003J<W/\\3oiNT$\u0002\t\u0011!A\u0001\u0002#\u0006I5oaV$\b%\f\u0011bAM$(/\u001b8hA\u0015D\bO]3tg&|g\u000e\t;pA\u00154\u0018\r\\;bi\u0016\u0004\u0003m\u001c4gg\u0016$\b\r\t:poN\u0004#-\u001a4pe\u0016\u0004C\u000f[3!GV\u0014(/\u001a8uAI|wO\f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!_\u001a47/\u001a;![\u0001\ng\u000eI5oi\u0002*\u0007\u0010\u001d:fgNLwN\u001c\u0011xQ&\u001c\u0007\u000eI5tAI|wo\u001d\u0011u_\u0002RW/\u001c9!E\u0006\u001c7\u000eI5oAQDW\r\t9beRLG/[8o])\u0001\u0003\u0005\t\u0011!A)\u0002C-\u001a4bk2$\b%\f\u0011bAM$(/\u001b8hA\u0015D\bO]3tg&|g\u000eI<iS\u000eD\u0007%[:!i>\u0004So]3!o\",g\u000e\t;iK\u0002zgMZ:fi\u0002\u0012xn\u001e\u0011e_\u0016\u001c\bE\\8uA\u0015D\u0018n\u001d;/\u0015\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005\u0005\u0016!a)\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA\u0005d\u0003E\u0019\u0017!?\u001a+fjQ0)E&\u0002sJV#SA!\u0002\u0016I\u0015+J)&{e\n\t\"ZA\u0005\u0004sJ\u0015#F%\u0002\u0012\u0015\f\t2*A\u0019\u0013v*\u0014\u0011W\u00032+Vi\u0015\u0011)O\u0005\u000bt\u0005\f\u00113S1\u0002\u0003fJ!2O1\u0002\u0013'\u000b\u0017!Q\u001d\n%g\n\u0017!g%b\u0003\u0005K\u0014Bc\u001db\u0003%M\u0015!i\u0006\u0014\u0007&\u0019\u0017!E&Z$\u0002\t\u0011!A\u0001\u0002\u0003%Q\u0019\nc%qU\u000b\u0014'\u000bA\u0001\u0002\u0003\u0005\t\u0011!\u0003FJ\u0011'C\u0019\u000bA\u0001\u0002\u0003\u0005\t\u0011!\u0003FJ!'C\u0019\u000bA\u0001\u0002\u0003\u0005\t\u0011!\u0003JJ1'\u0003(V\u00192S\u0001\u0005I\u0001\u0006g&t7-Z\u0011\u0003\u0003O\u000bQA\r\u00181]A\nQa\u001a:pkB\f#!!,\u0002\u0019]Lg\u000eZ8x?\u001a,hnY:\u0002\u00071\u000bw\r\u0005\u00029EM)!%!.\u0002BBI\u0011qWA_\u0003\u0006\u000bu,Z\u0007\u0003\u0003sS1!a/G\u0003\u001d\u0011XO\u001c;j[\u0016LA!a0\u0002:\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001b\u0011\t\u0005\r\u0017\u0011Z\u0007\u0003\u0003\u000bTA!a2\u0002H\u0005\u0011\u0011n\\\u0005\u0004)\u0006\u0015GCAAY\u0003!!xn\u0015;sS:<GCAA \u0003\u0015\t\u0007\u000f\u001d7z)%)\u0017Q[Al\u00033\fY\u000eC\u0003WK\u0001\u0007\u0011\tC\u0003ZK\u0001\u0007\u0011\tC\u0003\\K\u0001\u0007\u0011\tC\u0003^K\u0001\u0007q,A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005\u0005\u0018Q\u001e\t\u0006\u000b\u0006\r\u0018q]\u0005\u0004\u0003K4%AB(qi&|g\u000eE\u0004F\u0003S\f\u0015)Q0\n\u0007\u0005-hI\u0001\u0004UkBdW\r\u000e\u0005\t\u0003_4\u0013\u0011!a\u0001K\u0006\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\u0005U\b\u0003BA!\u0003oLA!!?\u0002D\t1qJ\u00196fGR\u0004")
public class Lag
extends FrameLessOffsetWindowFunction
implements TernaryLike<Expression>,
Serializable {
    private final Expression input;
    private final Expression inputOffset;
    private final Expression default;
    private final boolean ignoreNulls;
    private final Expression offset;
    private transient Seq<Expression> children;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple4<Expression, Expression, Expression, Object>> unapply(Lag x$0) {
        return Lag$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple4<Expression, Expression, Expression, Object>, Lag> tupled() {
        return Lag$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Function1<Object, Lag>>>> curried() {
        return Lag$.MODULE$.curried();
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return TernaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return TernaryLike.withNewChildrenInternal$(this, newChildren);
    }

    private Seq<Expression> children$lzycompute() {
        Lag lag = this;
        synchronized (lag) {
            if (!this.bitmap$trans$0) {
                this.children = TernaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        if (!this.bitmap$trans$0) {
            return this.children$lzycompute();
        }
        return this.children;
    }

    @Override
    public Expression input() {
        return this.input;
    }

    public Expression inputOffset() {
        return this.inputOffset;
    }

    @Override
    public Expression default() {
        return this.default;
    }

    @Override
    public boolean ignoreNulls() {
        return this.ignoreNulls;
    }

    @Override
    public Expression offset() {
        return this.offset;
    }

    @Override
    public Expression first() {
        return this.input();
    }

    @Override
    public Expression second() {
        return this.inputOffset();
    }

    @Override
    public Expression third() {
        return this.default();
    }

    @Override
    public Lag withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird, this.copy$default$4());
    }

    public Lag copy(Expression input, Expression inputOffset, Expression expression, boolean ignoreNulls) {
        return new Lag(input, inputOffset, expression, ignoreNulls);
    }

    public Expression copy$default$1() {
        return this.input();
    }

    public Expression copy$default$2() {
        return this.inputOffset();
    }

    public Expression copy$default$3() {
        return this.default();
    }

    public boolean copy$default$4() {
        return this.ignoreNulls();
    }

    @Override
    public String productPrefix() {
        return "Lag";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.input();
            }
            case 1: {
                return this.inputOffset();
            }
            case 2: {
                return this.default();
            }
            case 3: {
                return BoxesRunTime.boxToBoolean((boolean)this.ignoreNulls());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Lag;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "input";
            }
            case 1: {
                return "inputOffset";
            }
            case 2: {
                return "default";
            }
            case 3: {
                return "ignoreNulls";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Lag)) return false;
        boolean bl = true;
        if (!bl) return false;
        Lag lag = (Lag)x$1;
        if (this.ignoreNulls() != lag.ignoreNulls()) return false;
        Expression expression = this.input();
        Expression expression2 = lag.input();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.inputOffset();
        Expression expression4 = lag.inputOffset();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.default();
        Expression expression6 = lag.default();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!lag.canEqual(this)) return false;
        return true;
    }

    public Lag(Expression input, Expression inputOffset, Expression expression, boolean ignoreNulls) {
        UnaryMinus unaryMinus;
        this.input = input;
        this.inputOffset = inputOffset;
        this.default = expression;
        this.ignoreNulls = ignoreNulls;
        TernaryLike.$init$(this);
        UnaryMinus unaryMinus2 = new UnaryMinus(inputOffset, UnaryMinus$.MODULE$.apply$default$2());
        this.offset = unaryMinus2 != null && (unaryMinus = unaryMinus2).foldable() ? Literal$.MODULE$.create(unaryMinus.eval(package$.MODULE$.EmptyRow()), unaryMinus.dataType()) : unaryMinus2;
    }

    public Lag(Expression input, Expression inputOffset, Expression expression) {
        this(input, inputOffset, expression, false);
    }

    public Lag(Expression input, Expression offset, Expression expression, Expression ignoreNulls) {
        this(input, offset, expression, WindowExpression$.MODULE$.expressionToIngnoreNulls(ignoreNulls, "lag"));
    }

    public Lag(Expression input, Expression inputOffset) {
        this(input, inputOffset, Literal$.MODULE$.apply(null));
    }

    public Lag(Expression input) {
        this(input, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)1)));
    }

    public Lag() {
        this(Literal$.MODULE$.apply(null));
    }
}

