/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jetty.compression.server.internal;

import java.util.ListIterator;
import org.sparkproject.jetty.compression.Compression;
import org.sparkproject.jetty.compression.DecoderSource;
import org.sparkproject.jetty.http.HttpField;
import org.sparkproject.jetty.http.HttpFields;
import org.sparkproject.jetty.http.HttpHeader;
import org.sparkproject.jetty.io.Content;
import org.sparkproject.jetty.server.Request;
import org.sparkproject.jetty.util.component.Destroyable;

public class DecompressionRequest
extends Request.Wrapper
implements Destroyable {
    private final Compression compression;
    private final HttpFields fields;
    private final DecoderSource decoderSource;

    public DecompressionRequest(Compression compression, Request request) {
        super(request);
        this.compression = compression;
        this.fields = this.updateRequestFields(request);
        this.decoderSource = compression.newDecoderSource(request);
    }

    @Override
    public void demand(Runnable demandCallback) {
        this.decoderSource.demand(demandCallback);
    }

    @Override
    public void destroy() {
        DecoderSource decoderSource = this.decoderSource;
        if (decoderSource instanceof Destroyable) {
            Destroyable destroyable = (Destroyable)((Object)decoderSource);
            destroyable.destroy();
        }
    }

    @Override
    public HttpFields getHeaders() {
        if (this.fields == null) {
            return super.getHeaders();
        }
        return this.fields;
    }

    @Override
    public Content.Chunk read() {
        return this.decoderSource.read();
    }

    private HttpFields updateRequestFields(Request request) {
        HttpFields fields = request.getHeaders();
        HttpFields.Mutable newFields = HttpFields.build(fields);
        boolean contentEncodingSeen = false;
        ListIterator<HttpField> i = newFields.listIterator(newFields.size());
        while (i.hasPrevious()) {
            HttpField field = i.previous();
            HttpHeader header = field.getHeader();
            if (header == null) continue;
            switch (header) {
                case CONTENT_ENCODING: {
                    if (contentEncodingSeen) break;
                    contentEncodingSeen = true;
                    if (field.getValue().equalsIgnoreCase(this.compression.getEncodingName())) {
                        i.set(this.compression.getXContentEncodingField());
                        break;
                    }
                    if (!field.containsLast(this.compression.getEncodingName())) break;
                    String v = field.getValue();
                    v = v.substring(0, v.lastIndexOf(44));
                    i.set(new HttpField(HttpHeader.CONTENT_ENCODING, v));
                    i.add(this.compression.getXContentEncodingField());
                    break;
                }
                case CONTENT_LENGTH: {
                    i.set(new HttpField("X-Content-Length", field.getValue()));
                }
            }
        }
        return newFields.asImmutable();
    }
}

