/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jetty.ee10.servlets;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sparkproject.jetty.util.StringUtil;

@Deprecated(since="12.0.6", forRemoval=true)
public class CrossOriginFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(CrossOriginFilter.class);
    private static final String ORIGIN_HEADER = "Origin";
    public static final String ACCESS_CONTROL_REQUEST_METHOD_HEADER = "Access-Control-Request-Method";
    public static final String ACCESS_CONTROL_REQUEST_HEADERS_HEADER = "Access-Control-Request-Headers";
    public static final String ACCESS_CONTROL_ALLOW_ORIGIN_HEADER = "Access-Control-Allow-Origin";
    public static final String ACCESS_CONTROL_ALLOW_METHODS_HEADER = "Access-Control-Allow-Methods";
    public static final String ACCESS_CONTROL_ALLOW_HEADERS_HEADER = "Access-Control-Allow-Headers";
    public static final String ACCESS_CONTROL_MAX_AGE_HEADER = "Access-Control-Max-Age";
    public static final String ACCESS_CONTROL_ALLOW_CREDENTIALS_HEADER = "Access-Control-Allow-Credentials";
    public static final String ACCESS_CONTROL_EXPOSE_HEADERS_HEADER = "Access-Control-Expose-Headers";
    public static final String TIMING_ALLOW_ORIGIN_HEADER = "Timing-Allow-Origin";
    public static final String ALLOWED_ORIGINS_PARAM = "allowedOrigins";
    public static final String ALLOWED_TIMING_ORIGINS_PARAM = "allowedTimingOrigins";
    public static final String ALLOWED_METHODS_PARAM = "allowedMethods";
    public static final String ALLOWED_HEADERS_PARAM = "allowedHeaders";
    public static final String PREFLIGHT_MAX_AGE_PARAM = "preflightMaxAge";
    public static final String ALLOW_CREDENTIALS_PARAM = "allowCredentials";
    public static final String EXPOSED_HEADERS_PARAM = "exposedHeaders";
    public static final String OLD_CHAIN_PREFLIGHT_PARAM = "forwardPreflight";
    public static final String CHAIN_PREFLIGHT_PARAM = "chainPreflight";
    private static final String ANY_ORIGIN = "*";
    private static final String DEFAULT_ALLOWED_ORIGINS = "*";
    private static final String DEFAULT_ALLOWED_TIMING_ORIGINS = "";
    private static final List<String> SIMPLE_HTTP_METHODS = Arrays.asList("GET", "POST", "HEAD");
    private static final List<String> DEFAULT_ALLOWED_METHODS = Arrays.asList("GET", "POST", "HEAD");
    private static final List<String> DEFAULT_ALLOWED_HEADERS = Arrays.asList("X-Requested-With", "Content-Type", "Accept", "Origin");
    private boolean anyOriginAllowed;
    private boolean anyTimingOriginAllowed;
    private boolean anyHeadersAllowed;
    private final Set<String> allowedOrigins = new HashSet<String>();
    private final List<Pattern> allowedOriginPatterns = new ArrayList<Pattern>();
    private final Set<String> allowedTimingOrigins = new HashSet<String>();
    private final List<Pattern> allowedTimingOriginPatterns = new ArrayList<Pattern>();
    private final List<String> allowedMethods = new ArrayList<String>();
    private final List<String> allowedHeaders = new ArrayList<String>();
    private final List<String> exposedHeaders = new ArrayList<String>();
    private int preflightMaxAge;
    private boolean allowCredentials;
    private boolean chainPreflight;

    public void init(FilterConfig config) throws ServletException {
        String allowedOriginsConfig = config.getInitParameter(ALLOWED_ORIGINS_PARAM);
        String allowedTimingOriginsConfig = config.getInitParameter(ALLOWED_TIMING_ORIGINS_PARAM);
        this.anyOriginAllowed = this.generateAllowedOrigins(this.allowedOrigins, this.allowedOriginPatterns, allowedOriginsConfig, "*");
        this.anyTimingOriginAllowed = this.generateAllowedOrigins(this.allowedTimingOrigins, this.allowedTimingOriginPatterns, allowedTimingOriginsConfig, DEFAULT_ALLOWED_TIMING_ORIGINS);
        String allowedMethodsConfig = config.getInitParameter(ALLOWED_METHODS_PARAM);
        if (allowedMethodsConfig == null) {
            this.allowedMethods.addAll(DEFAULT_ALLOWED_METHODS);
        } else {
            this.allowedMethods.addAll(Arrays.asList(StringUtil.csvSplit(allowedMethodsConfig)));
        }
        String allowedHeadersConfig = config.getInitParameter(ALLOWED_HEADERS_PARAM);
        if (allowedHeadersConfig == null) {
            this.allowedHeaders.addAll(DEFAULT_ALLOWED_HEADERS);
        } else if ("*".equals(allowedHeadersConfig)) {
            this.anyHeadersAllowed = true;
        } else {
            this.allowedHeaders.addAll(Arrays.asList(StringUtil.csvSplit(allowedHeadersConfig)));
        }
        String preflightMaxAgeConfig = config.getInitParameter(PREFLIGHT_MAX_AGE_PARAM);
        if (preflightMaxAgeConfig == null) {
            preflightMaxAgeConfig = "1800";
        }
        try {
            this.preflightMaxAge = Integer.parseInt(preflightMaxAgeConfig);
        }
        catch (NumberFormatException x) {
            LOG.info("Cross-origin filter, could not parse '{}' parameter as integer: {}", (Object)PREFLIGHT_MAX_AGE_PARAM, (Object)preflightMaxAgeConfig);
        }
        String allowedCredentialsConfig = config.getInitParameter(ALLOW_CREDENTIALS_PARAM);
        if (allowedCredentialsConfig == null) {
            allowedCredentialsConfig = "true";
        }
        this.allowCredentials = Boolean.parseBoolean(allowedCredentialsConfig);
        String exposedHeadersConfig = config.getInitParameter(EXPOSED_HEADERS_PARAM);
        if (exposedHeadersConfig == null) {
            exposedHeadersConfig = DEFAULT_ALLOWED_TIMING_ORIGINS;
        }
        this.exposedHeaders.addAll(Arrays.asList(StringUtil.csvSplit(exposedHeadersConfig)));
        String chainPreflightConfig = config.getInitParameter(OLD_CHAIN_PREFLIGHT_PARAM);
        if (chainPreflightConfig != null) {
            LOG.warn("DEPRECATED CONFIGURATION: Use {} instead of {}", (Object)CHAIN_PREFLIGHT_PARAM, (Object)OLD_CHAIN_PREFLIGHT_PARAM);
        } else {
            chainPreflightConfig = config.getInitParameter(CHAIN_PREFLIGHT_PARAM);
        }
        if (chainPreflightConfig == null) {
            chainPreflightConfig = "true";
        }
        this.chainPreflight = Boolean.parseBoolean(chainPreflightConfig);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Cross-origin filter configuration: allowedOrigins = " + allowedOriginsConfig + ", allowedTimingOrigins = " + allowedTimingOriginsConfig + ", allowedMethods = " + allowedMethodsConfig + ", allowedHeaders = " + allowedHeadersConfig + ", preflightMaxAge = " + preflightMaxAgeConfig + ", allowCredentials = " + allowedCredentialsConfig + ",exposedHeaders = " + exposedHeadersConfig + ",chainPreflight = " + chainPreflightConfig);
        }
    }

    private boolean generateAllowedOrigins(Set<String> allowedOriginStore, List<Pattern> allowedOriginPatternStore, String allowedOriginsConfig, String defaultOrigin) {
        String[] allowedOrigins;
        if (allowedOriginsConfig == null) {
            allowedOriginsConfig = defaultOrigin;
        }
        for (String allowedOrigin : allowedOrigins = StringUtil.csvSplit(allowedOriginsConfig)) {
            if (allowedOrigin.length() <= 0) continue;
            if ("*".equals(allowedOrigin)) {
                allowedOriginStore.clear();
                allowedOriginPatternStore.clear();
                return true;
            }
            if (allowedOrigin.contains("*")) {
                allowedOriginPatternStore.add(Pattern.compile(this.parseAllowedWildcardOriginToRegex(allowedOrigin)));
                continue;
            }
            allowedOriginStore.add(allowedOrigin);
        }
        return false;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.handle((HttpServletRequest)request, (HttpServletResponse)response, chain);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handle(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        response.addHeader("Vary", ORIGIN_HEADER);
        String origin = request.getHeader(ORIGIN_HEADER);
        if (origin != null && this.isEnabled(request)) {
            if (this.anyOriginAllowed || this.originMatches(this.allowedOrigins, this.allowedOriginPatterns, origin)) {
                if (this.isSimpleRequest(request)) {
                    LOG.debug("Cross-origin request to {} is a simple cross-origin request", (Object)request.getRequestURI());
                    this.handleSimpleResponse(request, response, origin);
                } else if (this.isPreflightRequest(request)) {
                    LOG.debug("Cross-origin request to {} is a preflight cross-origin request", (Object)request.getRequestURI());
                    this.handlePreflightResponse(request, response, origin);
                    if (!this.chainPreflight) return;
                    LOG.debug("Preflight cross-origin request to {} forwarded to application", (Object)request.getRequestURI());
                } else {
                    LOG.debug("Cross-origin request to {} is a non-simple cross-origin request", (Object)request.getRequestURI());
                    this.handleSimpleResponse(request, response, origin);
                }
                if (this.anyTimingOriginAllowed || this.originMatches(this.allowedTimingOrigins, this.allowedTimingOriginPatterns, origin)) {
                    response.setHeader(TIMING_ALLOW_ORIGIN_HEADER, origin);
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug("Cross-origin request to {} with origin {} does not match allowed timing origins {}", new Object[]{request.getRequestURI(), origin, this.allowedTimingOrigins});
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Cross-origin request to {} with origin {} does not match allowed origins {}", new Object[]{request.getRequestURI(), origin, this.allowedOrigins});
            }
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    protected boolean isEnabled(HttpServletRequest request) {
        Enumeration connections = request.getHeaders("Connection");
        while (connections.hasMoreElements()) {
            String connection = (String)connections.nextElement();
            if (!"Upgrade".equalsIgnoreCase(connection)) continue;
            Enumeration upgrades = request.getHeaders("Upgrade");
            while (upgrades.hasMoreElements()) {
                String upgrade = (String)upgrades.nextElement();
                if (!"WebSocket".equalsIgnoreCase(upgrade)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean originMatches(Set<String> allowedOrigins, List<Pattern> allowedOriginPatterns, String originList) {
        String[] origins;
        if (originList.trim().length() == 0) {
            return false;
        }
        for (String origin : origins = originList.split(" ")) {
            if (origin.trim().length() == 0) continue;
            if (allowedOrigins.contains(origin)) {
                return true;
            }
            for (Pattern allowedOrigin : allowedOriginPatterns) {
                if (!allowedOrigin.matcher(origin).matches()) continue;
                return true;
            }
        }
        return false;
    }

    private String parseAllowedWildcardOriginToRegex(String allowedOrigin) {
        String regex = StringUtil.replace(allowedOrigin, ".", "\\.");
        return StringUtil.replace(regex, "*", ".*");
    }

    private boolean isSimpleRequest(HttpServletRequest request) {
        String method = request.getMethod();
        if (SIMPLE_HTTP_METHODS.contains(method)) {
            return request.getHeader(ACCESS_CONTROL_REQUEST_METHOD_HEADER) == null;
        }
        return false;
    }

    private boolean isPreflightRequest(HttpServletRequest request) {
        String method = request.getMethod();
        if (!"OPTIONS".equalsIgnoreCase(method)) {
            return false;
        }
        return request.getHeader(ACCESS_CONTROL_REQUEST_METHOD_HEADER) != null;
    }

    private void handleSimpleResponse(HttpServletRequest request, HttpServletResponse response, String origin) {
        response.setHeader(ACCESS_CONTROL_ALLOW_ORIGIN_HEADER, origin);
        if (this.allowCredentials) {
            response.setHeader(ACCESS_CONTROL_ALLOW_CREDENTIALS_HEADER, "true");
        }
        if (!this.exposedHeaders.isEmpty()) {
            response.setHeader(ACCESS_CONTROL_EXPOSE_HEADERS_HEADER, this.commify(this.exposedHeaders));
        }
    }

    private void handlePreflightResponse(HttpServletRequest request, HttpServletResponse response, String origin) {
        boolean methodAllowed = this.isMethodAllowed(request);
        if (!methodAllowed) {
            return;
        }
        List<String> headersRequested = this.getAccessControlRequestHeaders(request);
        boolean headersAllowed = this.areHeadersAllowed(headersRequested);
        if (!headersAllowed) {
            return;
        }
        response.setHeader(ACCESS_CONTROL_ALLOW_ORIGIN_HEADER, origin);
        if (this.allowCredentials) {
            response.setHeader(ACCESS_CONTROL_ALLOW_CREDENTIALS_HEADER, "true");
        }
        if (this.preflightMaxAge > 0) {
            response.setHeader(ACCESS_CONTROL_MAX_AGE_HEADER, String.valueOf(this.preflightMaxAge));
        }
        response.setHeader(ACCESS_CONTROL_ALLOW_METHODS_HEADER, this.commify(this.allowedMethods));
        if (this.anyHeadersAllowed) {
            response.setHeader(ACCESS_CONTROL_ALLOW_HEADERS_HEADER, this.commify(headersRequested));
        } else {
            response.setHeader(ACCESS_CONTROL_ALLOW_HEADERS_HEADER, this.commify(this.allowedHeaders));
        }
    }

    private boolean isMethodAllowed(HttpServletRequest request) {
        String accessControlRequestMethod = request.getHeader(ACCESS_CONTROL_REQUEST_METHOD_HEADER);
        LOG.debug("{} is {}", (Object)ACCESS_CONTROL_REQUEST_METHOD_HEADER, (Object)accessControlRequestMethod);
        boolean result = false;
        if (accessControlRequestMethod != null) {
            result = this.allowedMethods.contains(accessControlRequestMethod);
        }
        LOG.debug("Method {} is" + (result ? DEFAULT_ALLOWED_TIMING_ORIGINS : " not") + " among allowed methods {}", (Object)accessControlRequestMethod, this.allowedMethods);
        return result;
    }

    private List<String> getAccessControlRequestHeaders(HttpServletRequest request) {
        String[] headers;
        String accessControlRequestHeaders = request.getHeader(ACCESS_CONTROL_REQUEST_HEADERS_HEADER);
        LOG.debug("{} is {}", (Object)ACCESS_CONTROL_REQUEST_HEADERS_HEADER, (Object)accessControlRequestHeaders);
        if (accessControlRequestHeaders == null) {
            return Collections.emptyList();
        }
        ArrayList<String> requestedHeaders = new ArrayList<String>();
        for (String header : headers = StringUtil.csvSplit(accessControlRequestHeaders)) {
            String h = header.trim();
            if (h.length() <= 0) continue;
            requestedHeaders.add(h);
        }
        return requestedHeaders;
    }

    private boolean areHeadersAllowed(List<String> requestedHeaders) {
        if (this.anyHeadersAllowed) {
            LOG.debug("Any header is allowed");
            return true;
        }
        boolean result = true;
        for (String requestedHeader : requestedHeaders) {
            boolean headerAllowed = false;
            for (String allowedHeader : this.allowedHeaders) {
                if (!requestedHeader.equalsIgnoreCase(allowedHeader.trim())) continue;
                headerAllowed = true;
                break;
            }
            if (headerAllowed) continue;
            result = false;
            break;
        }
        LOG.debug("Headers [{}] are" + (result ? DEFAULT_ALLOWED_TIMING_ORIGINS : " not") + " among allowed headers {}", requestedHeaders, this.allowedHeaders);
        return result;
    }

    private String commify(List<String> strings) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < strings.size(); ++i) {
            if (i > 0) {
                builder.append(",");
            }
            String string = strings.get(i);
            builder.append(string);
        }
        return builder.toString();
    }

    public void destroy() {
        this.anyOriginAllowed = false;
        this.anyTimingOriginAllowed = false;
        this.allowedOrigins.clear();
        this.allowedOriginPatterns.clear();
        this.allowedTimingOrigins.clear();
        this.allowedTimingOriginPatterns.clear();
        this.allowedMethods.clear();
        this.allowedHeaders.clear();
        this.preflightMaxAge = 0;
        this.allowCredentials = false;
    }
}

