/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.ml.classification.NaiveBayes$;
import org.apache.spark.ml.classification.NaiveBayesModel$;
import org.apache.spark.ml.classification.NaiveBayesModel$NaiveBayesModelReader$;
import org.apache.spark.ml.classification.NaiveBayesModel$NaiveBayesModelWriter$;
import org.apache.spark.ml.classification.NaiveBayesParams;
import org.apache.spark.ml.classification.ProbabilisticClassificationModel;
import org.apache.spark.ml.impl.Utils$;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.Matrices$;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.DefaultParamsWriter$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.ReadWriteUtils$;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.util.VersionUtils$;
import org.json4s.DefaultFormats$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.SeqOps;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.hashing.MurmurHash3$;

@ScalaSignature(bytes="\u0006\u0005\rEd\u0001\u0002(P\u0001iC\u0001b\u001c\u0001\u0003\u0006\u0004%\t\u0005\u001d\u0005\n\u0003\u001f\u0001!\u0011!Q\u0001\nED!\"a\u0005\u0001\u0005\u000b\u0007I\u0011AA\u000b\u0011%\ti\u0002\u0001B\u0001B\u0003%q\f\u0003\u0006\u0002\"\u0001\u0011)\u0019!C\u0001\u0003GA!\"!\f\u0001\u0005\u0003\u0005\u000b\u0011BA\u0013\u0011)\t\t\u0004\u0001BC\u0002\u0013\u0005\u00111\u0005\u0005\u000b\u0003s\u0001!\u0011!Q\u0001\n\u0005\u0015\u0002\u0002CA\u001f\u0001\u0011\u0005\u0011+a\u0010\t\u0011\u0005u\u0002\u0001\"\u0001R\u0003#B!\"a\u0015\u0001\u0001\u0004%\taUA+\u0011)\t)\u0007\u0001a\u0001\n\u0003\u0019\u0016q\r\u0005\t\u0003g\u0002\u0001\u0015)\u0003\u0002X!A\u0011Q\u000f\u0001\u0005\u0002M\u000b9\b\u0003\u0006\u0002\u0000\u0001A)\u0019!C\u0005\u0003GA!\"!#\u0001\u0011\u000b\u0007I\u0011BAF\u0011)\t)\n\u0001EC\u0002\u0013%\u0011Q\u000b\u0005\n\u00033\u0003!\u0019!C!\u00037C\u0001\"!+\u0001A\u0003%\u0011Q\u0014\u0005\n\u0003[\u0003!\u0019!C!\u00037C\u0001\"!-\u0001A\u0003%\u0011Q\u0014\u0005\b\u0003k\u0003A\u0011BA\\\u0011\u001d\ti\f\u0001C\u0005\u0003\u007fCq!a1\u0001\t\u0013\t)\rC\u0004\u0002J\u0002!I!a3\t\u0015\u0005=\u0007\u0001#b\u0001\n\u0013\t\t\u000eC\u0004\u0002\\\u0002!\t%!8\t\u000f\u0005\r\b\u0001\"\u0015\u0002f\"A\u00111\u001e\u0001\u0005BM\u000bi\u000fC\u0004\u0002v\u0002!\t%a>\t\u000f\t-\u0001\u0001\"\u0011\u0003\u000e!9!\u0011\u0003\u0001\u0005B\tMqa\u0002B\u0010\u001f\"\u0005!\u0011\u0005\u0004\u0007\u001d>C\tAa\t\t\u000f\u0005u\"\u0005\"\u0001\u0003B\u00199!1\t\u0012A#\n\u0015\u0003BCA\nI\tU\r\u0011\"\u0001\u0002\u0016!I\u0011Q\u0004\u0013\u0003\u0012\u0003\u0006Ia\u0018\u0005\u000b\u0003C!#Q3A\u0005\u0002\u0005\r\u0002BCA\u0017I\tE\t\u0015!\u0003\u0002&!Q\u0011\u0011\u0007\u0013\u0003\u0016\u0004%\t!a\t\t\u0015\u0005eBE!E!\u0002\u0013\t)\u0003C\u0004\u0002>\u0011\"\tA!\u0018\t\u0013\u0005UH%!A\u0005\u0002\t%\u0004\"\u0003B9IE\u0005I\u0011\u0001B:\u0011%\u00119\tJI\u0001\n\u0003\u0011I\tC\u0005\u0003\u000e\u0012\n\n\u0011\"\u0001\u0003\n\"I!q\u0012\u0013\u0002\u0002\u0013\u0005#\u0011\u0013\u0005\n\u0005;#\u0013\u0011!C\u0001\u00037C\u0011Ba(%\u0003\u0003%\tA!)\t\u0013\t-F%!A\u0005B\t5\u0006\"\u0003B^I\u0005\u0005I\u0011\u0001B_\u0011%\u00119\rJA\u0001\n\u0003\u0012I\rC\u0005\u0003N\u0012\n\t\u0011\"\u0011\u0003P\"I!1\u0002\u0013\u0002\u0002\u0013\u0005#\u0011\u001b\u0005\n\u0005'$\u0013\u0011!C!\u0005+<!B!7#\u0003\u0003E\t!\u0015Bn\r)\u0011\u0019EIA\u0001\u0012\u0003\t&Q\u001c\u0005\b\u0003{QD\u0011\u0001Bv\u0011%\u0011YAOA\u0001\n\u000b\u0012\t\u000eC\u0005\u0003nj\n\t\u0011\"!\u0003p\"I!q\u001f\u001e\u0002\u0002\u0013\u0005%\u0011 \u0005\n\u0007\u0017Q\u0014\u0011!C\u0005\u0007\u001bA\u0001b!\u0006#\t\u0003\t6q\u0003\u0005\t\u0007O\u0011C\u0011A)\u0004*!91Q\u0007\u0012\u0005B\r]\u0002bBB!E\u0011\u000531\t\u0004\b\u0007\u0017\u0012\u0003AIB'\u0011%\u0019y\u0005\u0012B\u0001B\u0003%Q\rC\u0004\u0002>\u0011#\ta!\u0015\t\u000f\r]C\t\"\u0015\u0004Z\u001911Q\f\u0012\u0005\u0007?Bq!!\u0010I\t\u0003\u0019\t\u0007C\u0005\u0004f!\u0013\r\u0011\"\u0003\u0003\u0012\"A1q\r%!\u0002\u0013\u0011\u0019\nC\u0004\u0004B!#\te!\u001b\t\u0013\r-!%!A\u0005\n\r5!a\u0004(bSZ,')Y=fg6{G-\u001a7\u000b\u0005A\u000b\u0016AD2mCN\u001c\u0018NZ5dCRLwN\u001c\u0006\u0003%N\u000b!!\u001c7\u000b\u0005Q+\u0016!B:qCJ\\'B\u0001,X\u0003\u0019\t\u0007/Y2iK*\t\u0001,A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u00017\u001aL\u0007\u0003\u0002/^?\u0016l\u0011aT\u0005\u0003=>\u0013\u0001\u0005\u0015:pE\u0006\u0014\u0017\u000e\\5ti&\u001c7\t\\1tg&4\u0017nY1uS>tWj\u001c3fYB\u0011\u0001mY\u0007\u0002C*\u0011!-U\u0001\u0007Y&t\u0017\r\\4\n\u0005\u0011\f'A\u0002,fGR|'\u000f\u0005\u0002]\u0001A\u0011AlZ\u0005\u0003Q>\u0013\u0001CT1jm\u0016\u0014\u0015-_3t!\u0006\u0014\u0018-\\:\u0011\u0005)lW\"A6\u000b\u00051\f\u0016\u0001B;uS2L!A\\6\u0003\u00155cuK]5uC\ndW-A\u0002vS\u0012,\u0012!\u001d\t\u0003ent!a]=\u0011\u0005Q<X\"A;\u000b\u0005YL\u0016A\u0002\u001fs_>$hHC\u0001y\u0003\u0015\u00198-\u00197b\u0013\tQx/\u0001\u0004Qe\u0016$WMZ\u0005\u0003yv\u0014aa\u0015;sS:<'B\u0001>xQ\u0011\tq0a\u0003\u0011\t\u0005\u0005\u0011qA\u0007\u0003\u0003\u0007Q1!!\u0002T\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u0013\t\u0019AA\u0003TS:\u001cW-\t\u0002\u0002\u000e\u0005)\u0011GL\u001b/a\u0005!Q/\u001b3!Q\u0011\u0011q0a\u0003\u0002\u0005ALW#A0)\t\ry\u0018\u0011D\u0011\u0003\u00037\tQA\r\u00181]A\n1\u0001]5!Q\u0011!q0!\u0007\u0002\u000bQDW\r^1\u0016\u0005\u0005\u0015\u0002c\u00011\u0002(%\u0019\u0011\u0011F1\u0003\r5\u000bGO]5yQ\u0011)q0!\u0007\u0002\rQDW\r^1!Q\u00111q0!\u0007\u0002\u000bMLw-\\1)\t\u001dy\u0018QG\u0011\u0003\u0003o\tQa\r\u00181]A\naa]5h[\u0006\u0004\u0003\u0006\u0002\u0005\u0000\u0003k\ta\u0001P5oSRtD#C3\u0002B\u0005\u0015\u0013\u0011JA'\u0011\u0015y\u0017\u00021\u0001rQ\u0015\t\te`A\u0006\u0011\u0019\t\u0019\"\u0003a\u0001?\"*\u0011QI@\u0002\u001a!9\u0011\u0011E\u0005A\u0002\u0005\u0015\u0002&BA%\u007f\u0006e\u0001bBA\u0019\u0013\u0001\u0007\u0011Q\u0005\u0015\u0006\u0003\u001bz\u0018Q\u0007\u000b\u0002K\u0006Iq\u000e\u001c3MC\n,Gn]\u000b\u0003\u0003/\u0002b!!\u0017\u0002\\\u0005}S\"A<\n\u0007\u0005usOA\u0003BeJ\f\u0017\u0010\u0005\u0003\u0002Z\u0005\u0005\u0014bAA2o\n1Ai\\;cY\u0016\fQb\u001c7e\u0019\u0006\u0014W\r\\:`I\u0015\fH\u0003BA5\u0003_\u0002B!!\u0017\u0002l%\u0019\u0011QN<\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003cb\u0011\u0011!a\u0001\u0003/\n1\u0001\u001f\u00132\u0003)yG\u000e\u001a'bE\u0016d7\u000fI\u0001\rg\u0016$x\n\u001c3MC\n,Gn\u001d\u000b\u0005\u0003s\nY(D\u0001\u0001\u0011\u001d\tiH\u0004a\u0001\u0003/\na\u0001\\1cK2\u001c\u0018A\u0005;iKR\fW*\u001b8vg:+w\r\u00165fi\u0006D3aDAB!\u0011\tI&!\"\n\u0007\u0005\u001duOA\u0005ue\u0006t7/[3oi\u0006y\u0001/['j]V\u001cH\u000b[3uCN+X.\u0006\u0002\u0002\u000eB\u0019\u0001-a$\n\u0007\u0005E\u0015MA\u0006EK:\u001cXMV3di>\u0014\bf\u0001\t\u0002\u0004\u0006IAn\\4WCJ\u001cV/\u001c\u0015\u0004#\u0005\r\u0015a\u00038v[\u001a+\u0017\r^;sKN,\"!!(\u0011\t\u0005e\u0013qT\u0005\u0004\u0003C;(aA%oi\"\"!c`ASC\t\t9+A\u00032]Yr\u0003'\u0001\u0007ok64U-\u0019;ve\u0016\u001c\b\u0005\u000b\u0003\u0014\u007f\u0006\u0015\u0016A\u00038v[\u000ec\u0017m]:fg\"\"Ac`A\u0006\u0003-qW/\\\"mCN\u001cXm\u001d\u0011)\tUy\u00181B\u0001\u0017[VdG/\u001b8p[&\fGnQ1mGVd\u0017\r^5p]R!\u0011QRA]\u0011\u0019\tYL\u0006a\u0001?\u0006Aa-Z1ukJ,7/A\u000bd_6\u0004H.Z7f]R\u001c\u0015\r\\2vY\u0006$\u0018n\u001c8\u0015\u0007}\u000b\t\r\u0003\u0004\u0002<^\u0001\raX\u0001\u0015E\u0016\u0014hn\\;mY&\u001c\u0015\r\\2vY\u0006$\u0018n\u001c8\u0015\t\u00055\u0015q\u0019\u0005\u0007\u0003wC\u0002\u0019A0\u0002'\u001d\fWo]:jC:\u001c\u0015\r\\2vY\u0006$\u0018n\u001c8\u0015\u0007}\u000bi\r\u0003\u0004\u0002<f\u0001\raX\u0001\u000faJ,G-[2u%\u0006<h)\u001e8d+\t\t\u0019\u000e\u0005\u0004\u0002Z\u0005UwlX\u0005\u0004\u0003/<(!\u0003$v]\u000e$\u0018n\u001c82Q\rQ\u00121Q\u0001\u000baJ,G-[2u%\u0006<HcA0\u0002`\"1\u00111X\u000eA\u0002}CCaG@\u00026\u00051\"/Y<3aJ|'-\u00192jY&$\u00180\u00138QY\u0006\u001cW\rF\u0002`\u0003ODa!!;\u001d\u0001\u0004y\u0016!\u0004:boB\u0013X\rZ5di&|g.A\u0007fgRLW.\u0019;fINK'0Z\u000b\u0003\u0003_\u0004B!!\u0017\u0002r&\u0019\u00111_<\u0003\t1{gnZ\u0001\u0005G>\u0004\u0018\u0010F\u0002f\u0003sDq!a?\u001f\u0001\u0004\ti0A\u0003fqR\u0014\u0018\r\u0005\u0003\u0002\u0000\n\u0015QB\u0001B\u0001\u0015\r\u0011\u0019!U\u0001\u0006a\u0006\u0014\u0018-\\\u0005\u0005\u0005\u000f\u0011\tA\u0001\u0005QCJ\fW.T1qQ\u0011qr0a\u0003\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012!\u001d\u0015\u0005?}\fY!A\u0003xe&$X-\u0006\u0002\u0003\u0016A\u0019!Na\u0006\n\u0007\te1N\u0001\u0005N\u0019^\u0013\u0018\u000e^3sQ\u0011\u0001s0!*)\t\u0001y\u00181B\u0001\u0010\u001d\u0006Lg/\u001a\"bs\u0016\u001cXj\u001c3fYB\u0011ALI\n\bE\t\u0015\"1\u0006B\u0019!\u0011\tIFa\n\n\u0007\t%rO\u0001\u0004B]f\u0014VM\u001a\t\u0005U\n5R-C\u0002\u00030-\u0014!\"\u0014'SK\u0006$\u0017M\u00197f!\u0011\u0011\u0019D!\u0010\u000e\u0005\tU\"\u0002\u0002B\u001c\u0005s\t!![8\u000b\u0005\tm\u0012\u0001\u00026bm\u0006LAAa\u0010\u00036\ta1+\u001a:jC2L'0\u00192mKR\u0011!\u0011\u0005\u0002\u0005\t\u0006$\u0018mE\u0004%\u0005K\u00119E!\u0014\u0011\t\u0005e#\u0011J\u0005\u0004\u0005\u0017:(a\u0002)s_\u0012,8\r\u001e\t\u0005\u0005\u001f\u0012IF\u0004\u0003\u0003R\tUcb\u0001;\u0003T%\t\u00010C\u0002\u0003X]\fq\u0001]1dW\u0006<W-\u0003\u0003\u0003@\tm#b\u0001B,oRA!q\fB2\u0005K\u00129\u0007E\u0002\u0003b\u0011j\u0011A\t\u0005\u0007\u0003'Y\u0003\u0019A0\t\u000f\u0005\u00052\u00061\u0001\u0002&!9\u0011\u0011G\u0016A\u0002\u0005\u0015B\u0003\u0003B0\u0005W\u0012iGa\u001c\t\u0011\u0005MA\u0006%AA\u0002}C\u0011\"!\t-!\u0003\u0005\r!!\n\t\u0013\u0005EB\u0006%AA\u0002\u0005\u0015\u0012AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0005kR3a\u0018B<W\t\u0011I\b\u0005\u0003\u0003|\t\rUB\u0001B?\u0015\u0011\u0011yH!!\u0002\u0013Ut7\r[3dW\u0016$'bAA\u0003o&!!Q\u0011B?\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011YI\u000b\u0003\u0002&\t]\u0014AD2paf$C-\u001a4bk2$HeM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\tM\u0005\u0003\u0002BK\u00057k!Aa&\u000b\t\te%\u0011H\u0001\u0005Y\u0006tw-C\u0002}\u0005/\u000bA\u0002\u001d:pIV\u001cG/\u0011:jif\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0003$\n%\u0006\u0003BA-\u0005KK1Aa*x\u0005\r\te.\u001f\u0005\n\u0003c\u0012\u0014\u0011!a\u0001\u0003;\u000bq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005_\u0003bA!-\u00038\n\rVB\u0001BZ\u0015\r\u0011)l^\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002B]\u0005g\u0013\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!!q\u0018Bc!\u0011\tIF!1\n\u0007\t\rwOA\u0004C_>dW-\u00198\t\u0013\u0005ED'!AA\u0002\t\r\u0016A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$BAa%\u0003L\"I\u0011\u0011O\u001b\u0002\u0002\u0003\u0007\u0011QT\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011Q\u0014\u000b\u0003\u0005'\u000ba!Z9vC2\u001cH\u0003\u0002B`\u0005/D\u0011\"!\u001d9\u0003\u0003\u0005\rAa)\u0002\t\u0011\u000bG/\u0019\t\u0004\u0005CR4#\u0002\u001e\u0003`\nE\u0002c\u0003Bq\u0005O|\u0016QEA\u0013\u0005?j!Aa9\u000b\u0007\t\u0015x/A\u0004sk:$\u0018.\\3\n\t\t%(1\u001d\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u001cDC\u0001Bn\u0003\u0015\t\u0007\u000f\u001d7z)!\u0011yF!=\u0003t\nU\bBBA\n{\u0001\u0007q\fC\u0004\u0002\"u\u0002\r!!\n\t\u000f\u0005ER\b1\u0001\u0002&\u00059QO\\1qa2LH\u0003\u0002B~\u0007\u000f\u0001b!!\u0017\u0003~\u000e\u0005\u0011b\u0001B\u0000o\n1q\n\u001d;j_:\u0004\u0012\"!\u0017\u0004\u0004}\u000b)#!\n\n\u0007\r\u0015qO\u0001\u0004UkBdWm\r\u0005\n\u0007\u0013q\u0014\u0011!a\u0001\u0005?\n1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0019y\u0001\u0005\u0003\u0003\u0016\u000eE\u0011\u0002BB\n\u0005/\u0013aa\u00142kK\u000e$\u0018!D:fe&\fG.\u001b>f\t\u0006$\u0018\r\u0006\u0004\u0002j\re1Q\u0004\u0005\b\u00077\u0001\u0005\u0019\u0001B0\u0003\u0011!\u0017\r^1\t\u000f\r}\u0001\t1\u0001\u0004\"\u0005\u0019Am\\:\u0011\t\tM21E\u0005\u0005\u0007K\u0011)D\u0001\tECR\fw*\u001e;qkR\u001cFO]3b[\u0006yA-Z:fe&\fG.\u001b>f\t\u0006$\u0018\r\u0006\u0003\u0003`\r-\u0002bBB\u0017\u0003\u0002\u00071qF\u0001\u0004I&\u001c\b\u0003\u0002B\u001a\u0007cIAaa\r\u00036\tyA)\u0019;b\u0013:\u0004X\u000f^*ue\u0016\fW.\u0001\u0003sK\u0006$WCAB\u001d!\u0011Q71H3\n\u0007\ru2N\u0001\u0005N\u0019J+\u0017\rZ3sQ\u0011\u0011u0!*\u0002\t1|\u0017\r\u001a\u000b\u0004K\u000e\u0015\u0003BBB$\u0007\u0002\u0007\u0011/\u0001\u0003qCRD\u0007\u0006B\"\u0000\u0003K\u0013QCT1jm\u0016\u0014\u0015-_3t\u001b>$W\r\\,sSR,'oE\u0002E\u0005+\t\u0001\"\u001b8ti\u0006t7-\u001a\u000b\u0005\u0007'\u001a)\u0006E\u0002\u0003b\u0011Caaa\u0014G\u0001\u0004)\u0017\u0001C:bm\u0016LU\u000e\u001d7\u0015\t\u0005%41\f\u0005\u0007\u0007\u000f:\u0005\u0019A9\u0003+9\u000b\u0017N^3CCf,7/T8eK2\u0014V-\u00193feN\u0019\u0001j!\u000f\u0015\u0005\r\r\u0004c\u0001B1\u0011\u0006I1\r\\1tg:\u000bW.Z\u0001\u000bG2\f7o\u001d(b[\u0016\u0004CcA3\u0004l!11q\t'A\u0002EDCAI@\u0002&\"\"\u0011e`AS\u0001")
public class NaiveBayesModel
extends ProbabilisticClassificationModel<Vector, NaiveBayesModel>
implements NaiveBayesParams,
MLWritable {
    private transient Matrix thetaMinusNegTheta;
    private transient DenseVector piMinusThetaSum;
    private transient double[] logVarSum;
    private transient Function1<Vector, Vector> predictRawFunc;
    private final String uid;
    private final Vector pi;
    private final Matrix theta;
    private final Matrix sigma;
    private double[] oldLabels;
    private final int numFeatures;
    private final int numClasses;
    private DoubleParam smoothing;
    private Param<String> modelType;
    private Param<String> weightCol;
    private volatile transient byte bitmap$trans$0;

    public static NaiveBayesModel load(String path) {
        return NaiveBayesModel$.MODULE$.load(path);
    }

    public static MLReader<NaiveBayesModel> read() {
        return NaiveBayesModel$.MODULE$.read();
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public final double getSmoothing() {
        return NaiveBayesParams.getSmoothing$(this);
    }

    @Override
    public final String getModelType() {
        return NaiveBayesParams.getModelType$(this);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final DoubleParam smoothing() {
        return this.smoothing;
    }

    @Override
    public final Param<String> modelType() {
        return this.modelType;
    }

    @Override
    public final void org$apache$spark$ml$classification$NaiveBayesParams$_setter_$smoothing_$eq(DoubleParam x$1) {
        this.smoothing = x$1;
    }

    @Override
    public final void org$apache$spark$ml$classification$NaiveBayesParams$_setter_$modelType_$eq(Param<String> x$1) {
        this.modelType = x$1;
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public Vector pi() {
        return this.pi;
    }

    public Matrix theta() {
        return this.theta;
    }

    public Matrix sigma() {
        return this.sigma;
    }

    public double[] oldLabels() {
        return this.oldLabels;
    }

    public void oldLabels_$eq(double[] x$1) {
        this.oldLabels = x$1;
    }

    public NaiveBayesModel setOldLabels(double[] labels) {
        this.oldLabels_$eq(labels);
        return this;
    }

    private Matrix thetaMinusNegTheta$lzycompute() {
        block5: {
            NaiveBayesModel naiveBayesModel = this;
            synchronized (naiveBayesModel) {
                block7: {
                    block8: {
                        String string;
                        String string2;
                        block6: {
                            if ((byte)(this.bitmap$trans$0 & 1) != 0) break block5;
                            String string3 = this.$(this.modelType());
                            string2 = NaiveBayes$.MODULE$.Bernoulli();
                            string = string3;
                            if (string2 != null) break block6;
                            if (string == null) break block7;
                            break block8;
                        }
                        if (string2.equals(string)) break block7;
                    }
                    throw new IllegalArgumentException("Invalid modelType: " + this.$(this.modelType()) + ". Variables thetaMinusNegTheta should only be precomputed in Bernoulli NB.");
                }
                this.thetaMinusNegTheta = this.theta().map((Function1)(JFunction1.mcDD.sp & Serializable)value -> value - scala.math.package$.MODULE$.log1p(-scala.math.package$.MODULE$.exp(value)));
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.thetaMinusNegTheta;
    }

    private Matrix thetaMinusNegTheta() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.thetaMinusNegTheta$lzycompute();
        }
        return this.thetaMinusNegTheta;
    }

    private DenseVector piMinusThetaSum$lzycompute() {
        NaiveBayesModel naiveBayesModel = this;
        synchronized (naiveBayesModel) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                String string = this.$(this.modelType());
                String string2 = NaiveBayes$.MODULE$.Bernoulli();
                String string3 = string;
                if (string2 != null ? !string2.equals(string3) : string3 != null) {
                    throw new IllegalArgumentException("Invalid modelType: " + this.$(this.modelType()) + ". Variables piMinusThetaSum should only be precomputed in Bernoulli NB.");
                }
                Matrix negTheta = this.theta().map((Function1)(JFunction1.mcDD.sp & Serializable)value -> scala.math.package$.MODULE$.log1p(-scala.math.package$.MODULE$.exp(value)));
                DenseVector ones = new DenseVector((double[])Array$.MODULE$.fill(this.theta().numCols(), (Function0)(JFunction0.mcD.sp & Serializable)() -> 1.0, (ClassTag)ClassTag$.MODULE$.Double()));
                DenseVector piMinusThetaSum = this.pi().toDense().copy();
                BLAS$.MODULE$.gemv(1.0, negTheta, (Vector)ones, 1.0, piMinusThetaSum);
                this.piMinusThetaSum = piMinusThetaSum;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.piMinusThetaSum;
    }

    private DenseVector piMinusThetaSum() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.piMinusThetaSum$lzycompute();
        }
        return this.piMinusThetaSum;
    }

    private double[] logVarSum$lzycompute() {
        block5: {
            NaiveBayesModel naiveBayesModel = this;
            synchronized (naiveBayesModel) {
                block7: {
                    block8: {
                        String string;
                        String string2;
                        block6: {
                            if ((byte)(this.bitmap$trans$0 & 4) != 0) break block5;
                            String string3 = this.$(this.modelType());
                            string2 = NaiveBayes$.MODULE$.Gaussian();
                            string = string3;
                            if (string2 != null) break block6;
                            if (string == null) break block7;
                            break block8;
                        }
                        if (string2.equals(string)) break block7;
                    }
                    throw new IllegalArgumentException("Invalid modelType: " + this.$(this.modelType()) + ". Variables logVarSum should only be precomputed in Gaussian NB.");
                }
                this.logVarSum = (double[])Array$.MODULE$.tabulate(this.numClasses(), (Function1)(JFunction1.mcDI.sp & Serializable)i -> BoxesRunTime.unboxToDouble((Object)package$.MODULE$.Iterator().range(0, this.numFeatures()).map((Function1)(JFunction1.mcDI.sp & Serializable)j -> scala.math.package$.MODULE$.log(this.sigma().apply(i, j))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)), (ClassTag)ClassTag$.MODULE$.Double());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.logVarSum;
    }

    private double[] logVarSum() {
        if ((byte)(this.bitmap$trans$0 & 4) == 0) {
            return this.logVarSum$lzycompute();
        }
        return this.logVarSum;
    }

    @Override
    public int numFeatures() {
        return this.numFeatures;
    }

    @Override
    public int numClasses() {
        return this.numClasses;
    }

    private DenseVector multinomialCalculation(Vector features) {
        NaiveBayes$.MODULE$.requireNonnegativeValues(features);
        DenseVector prob = this.pi().toDense().copy();
        BLAS$.MODULE$.gemv(1.0, this.theta(), features, 1.0, prob);
        return prob;
    }

    private Vector complementCalculation(Vector features) {
        int j;
        NaiveBayes$.MODULE$.requireNonnegativeValues(features);
        double[] probArray = this.theta().multiply(features).toArray();
        double max = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.wrapDoubleArray(probArray).max((Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$));
        double sumExp = 0.0;
        for (j = 0; j < probArray.length; ++j) {
            sumExp += scala.math.package$.MODULE$.exp(probArray[j] - max);
        }
        double logSumExp = scala.math.package$.MODULE$.log(sumExp) + max;
        j = 0;
        while (j < probArray.length) {
            int n = j++;
            probArray[n] = probArray[n] - logSumExp;
        }
        return Vectors$.MODULE$.dense(probArray);
    }

    private DenseVector bernoulliCalculation(Vector features) {
        NaiveBayes$.MODULE$.requireZeroOneBernoulliValues(features);
        DenseVector prob = this.piMinusThetaSum().copy();
        BLAS$.MODULE$.gemv(1.0, this.thetaMinusNegTheta(), features, 1.0, prob);
        return prob;
    }

    private Vector gaussianCalculation(Vector features) {
        double[] prob = (double[])Array$.MODULE$.ofDim(this.numClasses(), (ClassTag)ClassTag$.MODULE$.Double());
        for (int i = 0; i < this.numClasses(); ++i) {
            double s = 0.0;
            for (int j = 0; j < this.numFeatures(); ++j) {
                double d = features.apply(j) - this.theta().apply(i, j);
                s += d * d / this.sigma().apply(i, j);
            }
            prob[i] = this.pi().apply(i) - (s + this.logVarSum()[i]) / (double)2;
        }
        return Vectors$.MODULE$.dense(prob);
    }

    private Function1<Vector, Vector> predictRawFunc$lzycompute() {
        NaiveBayesModel naiveBayesModel = this;
        synchronized (naiveBayesModel) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                Function1 & Serializable intersect;
                String string = this.$(this.modelType());
                String string2 = NaiveBayes$.MODULE$.Multinomial();
                String string3 = string;
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    intersect = (Function1 & Serializable)features -> this.multinomialCalculation((Vector)features);
                } else {
                    String string4 = NaiveBayes$.MODULE$.Complement();
                    String string5 = string;
                    if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                        intersect = (Function1 & Serializable)features -> this.complementCalculation((Vector)features);
                    } else {
                        String string6 = NaiveBayes$.MODULE$.Bernoulli();
                        String string7 = string;
                        if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                            intersect = (Function1 & Serializable)features -> this.bernoulliCalculation((Vector)features);
                        } else {
                            String string8 = NaiveBayes$.MODULE$.Gaussian();
                            String string9 = string;
                            if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                                intersect = (Function1 & Serializable)features -> this.gaussianCalculation((Vector)features);
                            } else {
                                throw new MatchError((Object)string);
                            }
                        }
                    }
                }
                this.predictRawFunc = intersect;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
        }
        return this.predictRawFunc;
    }

    private Function1<Vector, Vector> predictRawFunc() {
        if ((byte)(this.bitmap$trans$0 & 8) == 0) {
            return this.predictRawFunc$lzycompute();
        }
        return this.predictRawFunc;
    }

    @Override
    public Vector predictRaw(Vector features) {
        return (Vector)this.predictRawFunc().apply((Object)features);
    }

    @Override
    public Vector raw2probabilityInPlace(Vector rawPrediction) {
        Vector vector = rawPrediction;
        if (vector instanceof DenseVector) {
            DenseVector denseVector = (DenseVector)vector;
            Utils$.MODULE$.softmax(denseVector.values());
            return denseVector;
        }
        if (vector instanceof SparseVector) {
            throw new RuntimeException("Unexpected error in NaiveBayesModel: raw2probabilityInPlace encountered SparseVector");
        }
        throw new MatchError((Object)vector);
    }

    @Override
    public long estimatedSize() {
        long size;
        block2: {
            size = this.estimateMatadataSize();
            if (this.pi() != null) {
                size += this.pi().getSizeInBytes();
            }
            if (this.theta() != null) {
                size += this.theta().getSizeInBytes();
            }
            if (this.sigma() == null) break block2;
            size += this.sigma().getSizeInBytes();
        }
        return size;
    }

    @Override
    public NaiveBayesModel copy(ParamMap extra) {
        return (NaiveBayesModel)this.copyValues(new NaiveBayesModel(this.uid(), this.pi(), this.theta(), this.sigma()).setParent(this.parent()), extra);
    }

    @Override
    public String toString() {
        return "NaiveBayesModel: uid=" + this.uid() + ", modelType=" + this.$(this.modelType()) + ", numClasses=" + this.numClasses() + ", numFeatures=" + this.numFeatures();
    }

    @Override
    public MLWriter write() {
        return new NaiveBayesModelWriter(this);
    }

    public NaiveBayesModel(String uid, Vector pi, Matrix theta, Matrix sigma) {
        this.uid = uid;
        this.pi = pi;
        this.theta = theta;
        this.sigma = sigma;
        HasWeightCol.$init$(this);
        NaiveBayesParams.$init$(this);
        MLWritable.$init$(this);
        this.oldLabels = null;
        this.numFeatures = theta.numCols();
        this.numClasses = pi.size();
        Statics.releaseFence();
    }

    public NaiveBayesModel() {
        this("", (Vector)Vectors$.MODULE$.empty(), (Matrix)Matrices$.MODULE$.empty(), (Matrix)Matrices$.MODULE$.empty());
    }

    public static class Data
    implements Product,
    Serializable {
        private final Vector pi;
        private final Matrix theta;
        private final Matrix sigma;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public Vector pi() {
            return this.pi;
        }

        public Matrix theta() {
            return this.theta;
        }

        public Matrix sigma() {
            return this.sigma;
        }

        public Data copy(Vector pi, Matrix theta, Matrix sigma) {
            return new Data(pi, theta, sigma);
        }

        public Vector copy$default$1() {
            return this.pi();
        }

        public Matrix copy$default$2() {
            return this.theta();
        }

        public Matrix copy$default$3() {
            return this.sigma();
        }

        public String productPrefix() {
            return "Data";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.pi();
                }
                case 1: {
                    return this.theta();
                }
                case 2: {
                    return this.sigma();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Data;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "pi";
                }
                case 1: {
                    return "theta";
                }
                case 2: {
                    return "sigma";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return MurmurHash3$.MODULE$.productHash((Product)this, 45109845, true);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Data)) return false;
            boolean bl = true;
            if (!bl) return false;
            Data data = (Data)x$1;
            Vector vector = this.pi();
            Vector vector2 = data.pi();
            if (vector == null) {
                if (vector2 != null) {
                    return false;
                }
            } else if (!vector.equals(vector2)) return false;
            Matrix matrix = this.theta();
            Matrix matrix2 = data.theta();
            if (matrix == null) {
                if (matrix2 != null) {
                    return false;
                }
            } else if (!matrix.equals(matrix2)) return false;
            Matrix matrix3 = this.sigma();
            Matrix matrix4 = data.sigma();
            if (matrix3 == null) {
                if (matrix4 != null) {
                    return false;
                }
            } else if (!matrix3.equals(matrix4)) return false;
            if (!data.canEqual(this)) return false;
            return true;
        }

        public Data(Vector pi, Matrix theta, Matrix sigma) {
            this.pi = pi;
            this.theta = theta;
            this.sigma = sigma;
            Product.$init$((Product)this);
        }
    }

    private static class NaiveBayesModelReader
    extends MLReader<NaiveBayesModel> {
        private final String className = NaiveBayesModel.class.getName();

        private String className() {
            return this.className;
        }

        @Override
        public NaiveBayesModel load(String path) {
            NaiveBayesModel naiveBayesModel;
            DefaultParamsReader.Metadata metadata;
            block7: {
                String dataPath;
                block4: {
                    Vector vector;
                    Object theta;
                    block6: {
                        Row row;
                        block5: {
                            Some some;
                            DefaultFormats$ format = DefaultFormats$.MODULE$;
                            metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, this.sparkSession(), this.className());
                            Tuple2 tuple2 = VersionUtils$.MODULE$.majorMinorVersion(metadata.sparkVersion());
                            if (tuple2 == null) {
                                throw new MatchError((Object)tuple2);
                            }
                            int major = tuple2._1$mcI$sp();
                            int minor = tuple2._2$mcI$sp();
                            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(major, minor);
                            int major2 = sp2._1$mcI$sp();
                            int minor2 = sp2._2$mcI$sp();
                            dataPath = new Path(path, "data").toString();
                            if (major2 >= 3) break block4;
                            Dataset data = this.sparkSession().read().parquet(dataPath);
                            Dataset<Row> vecConverted = MLUtils$.MODULE$.convertVectorColumnsToML(data, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"pi"}));
                            row = (Row)MLUtils$.MODULE$.convertMatrixColumnsToML(vecConverted, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"theta"})).select("pi", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"theta"})).head();
                            if (row == null || (some = Row$.MODULE$.unapplySeq(row)).isEmpty() || some.get() == null || ((SeqOps)some.get()).lengthCompare(2) != 0) break block5;
                            Object pi = ((SeqOps)some.get()).apply(0);
                            theta = ((SeqOps)some.get()).apply(1);
                            if (!(pi instanceof Vector)) break block5;
                            vector = (Vector)pi;
                            if (theta instanceof Matrix) break block6;
                        }
                        throw new MatchError((Object)row);
                    }
                    Matrix matrix = (Matrix)theta;
                    Tuple2 tuple2 = new Tuple2((Object)vector, (Object)matrix);
                    Vector pi = (Vector)tuple2._1();
                    Matrix theta2 = (Matrix)tuple2._2();
                    naiveBayesModel = new NaiveBayesModel(metadata.uid(), pi, theta2, Matrices$.MODULE$.zeros(0, 0));
                    break block7;
                }
                JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(NaiveBayesModelReader.class.getClassLoader());
                public final class Org_apache_spark_ml_classification_NaiveBayesModel$NaiveBayesModelReader$$typecreator1$2
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.ml.classification.NaiveBayesModel.Data").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_ml_classification_NaiveBayesModel$NaiveBayesModelReader$$typecreator1$2(NaiveBayesModelReader $outer) {
                    }
                }
                Data data = (Data)ReadWriteUtils$.MODULE$.loadObject(dataPath, this.sparkSession(), (Function1 & Serializable)dis -> NaiveBayesModel$.MODULE$.deserializeData((DataInputStream)dis), ClassTag$.MODULE$.apply(Data.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_NaiveBayesModel$NaiveBayesModelReader$$typecreator1$2(null)));
                naiveBayesModel = new NaiveBayesModel(metadata.uid(), data.pi(), data.theta(), data.sigma());
            }
            NaiveBayesModel model = naiveBayesModel;
            metadata.getAndSetParams(model, metadata.getAndSetParams$default$2());
            return model;
        }
    }

    public static class NaiveBayesModelWriter
    extends MLWriter {
        private final NaiveBayesModel instance;

        @Override
        public void saveImpl(String path) {
            public final class Org_apache_spark_ml_classification_NaiveBayesModel$NaiveBayesModelWriter$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.classification.NaiveBayesModel.Data").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_classification_NaiveBayesModel$NaiveBayesModelWriter$$typecreator1$1(NaiveBayesModelWriter $outer) {
                }
            }
            boolean bl;
            DefaultParamsWriter$.MODULE$.saveMetadata(this.instance, path, this.sparkSession());
            String dataPath = new Path(path, "data").toString();
            String string = this.instance.getModelType();
            String string2 = NaiveBayes$.MODULE$.Multinomial();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                bl = true;
            } else {
                String string4 = NaiveBayes$.MODULE$.Bernoulli();
                String string5 = string;
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    bl = true;
                } else {
                    String string6 = NaiveBayes$.MODULE$.Complement();
                    String string7 = string;
                    bl = !(string6 != null ? !string6.equals(string7) : string7 != null);
                }
            }
            if (bl) {
                Predef$.MODULE$.require(this.instance.sigma().numRows() == 0 && this.instance.sigma().numCols() == 0);
            } else {
                String string8 = NaiveBayes$.MODULE$.Gaussian();
                String string9 = string;
                if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                    Predef$.MODULE$.require(this.instance.sigma().numRows() != 0 && this.instance.sigma().numCols() != 0);
                } else {
                    throw new MatchError((Object)string);
                }
            }
            Data data2 = new Data(this.instance.pi(), this.instance.theta(), this.instance.sigma());
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(NaiveBayesModelWriter.class.getClassLoader());
            ReadWriteUtils$.MODULE$.saveObject(dataPath, data2, this.sparkSession(), (Function2 & Serializable)(data, dos) -> {
                NaiveBayesModel$.MODULE$.serializeData(data, dos);
                return BoxedUnit.UNIT;
            }, ClassTag$.MODULE$.apply(Data.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_NaiveBayesModel$NaiveBayesModelWriter$$typecreator1$1(null)));
        }

        public NaiveBayesModelWriter(NaiveBayesModel instance) {
            this.instance = instance;
        }
    }
}

