/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.connect.grpc.internal;

import java.text.MessageFormat;
import java.util.logging.Level;
import org.sparkproject.connect.grpc.ChannelLogger;
import org.sparkproject.connect.grpc.InternalChannelz;
import org.sparkproject.connect.grpc.InternalLogId;
import org.sparkproject.connect.grpc.internal.ChannelTracer;
import org.sparkproject.connect.grpc.internal.TimeProvider;
import org.sparkproject.guava.base.Preconditions;

final class ChannelLoggerImpl
extends ChannelLogger {
    private final ChannelTracer tracer;
    private final TimeProvider time;

    ChannelLoggerImpl(ChannelTracer tracer, TimeProvider time) {
        this.tracer = (ChannelTracer)Preconditions.checkNotNull((Object)tracer, (Object)"tracer");
        this.time = (TimeProvider)Preconditions.checkNotNull((Object)time, (Object)"time");
    }

    @Override
    public void log(ChannelLogger.ChannelLogLevel level, String msg) {
        ChannelLoggerImpl.logOnly(this.tracer.getLogId(), level, msg);
        if (this.isTraceable(level)) {
            this.trace(level, msg);
        }
    }

    @Override
    public void log(ChannelLogger.ChannelLogLevel level, String messageFormat, Object ... args) {
        String msg = null;
        Level javaLogLevel = ChannelLoggerImpl.toJavaLogLevel(level);
        if (this.isTraceable(level) || ChannelTracer.logger.isLoggable(javaLogLevel)) {
            msg = MessageFormat.format(messageFormat, args);
        }
        this.log(level, msg);
    }

    static void logOnly(InternalLogId logId, ChannelLogger.ChannelLogLevel level, String msg) {
        Level javaLogLevel = ChannelLoggerImpl.toJavaLogLevel(level);
        if (ChannelTracer.logger.isLoggable(javaLogLevel)) {
            ChannelTracer.logOnly(logId, javaLogLevel, msg);
        }
    }

    static void logOnly(InternalLogId logId, ChannelLogger.ChannelLogLevel level, String messageFormat, Object ... args) {
        Level javaLogLevel = ChannelLoggerImpl.toJavaLogLevel(level);
        if (ChannelTracer.logger.isLoggable(javaLogLevel)) {
            String msg = MessageFormat.format(messageFormat, args);
            ChannelTracer.logOnly(logId, javaLogLevel, msg);
        }
    }

    private boolean isTraceable(ChannelLogger.ChannelLogLevel level) {
        return level != ChannelLogger.ChannelLogLevel.DEBUG && this.tracer.isTraceEnabled();
    }

    private void trace(ChannelLogger.ChannelLogLevel level, String msg) {
        if (level == ChannelLogger.ChannelLogLevel.DEBUG) {
            return;
        }
        this.tracer.traceOnly(new InternalChannelz.ChannelTrace.Event.Builder().setDescription(msg).setSeverity(ChannelLoggerImpl.toTracerSeverity(level)).setTimestampNanos(this.time.currentTimeNanos()).build());
    }

    private static InternalChannelz.ChannelTrace.Event.Severity toTracerSeverity(ChannelLogger.ChannelLogLevel level) {
        switch (level) {
            case ERROR: {
                return InternalChannelz.ChannelTrace.Event.Severity.CT_ERROR;
            }
            case WARNING: {
                return InternalChannelz.ChannelTrace.Event.Severity.CT_WARNING;
            }
        }
        return InternalChannelz.ChannelTrace.Event.Severity.CT_INFO;
    }

    private static Level toJavaLogLevel(ChannelLogger.ChannelLogLevel level) {
        switch (level) {
            case ERROR: 
            case WARNING: {
                return Level.FINE;
            }
            case INFO: {
                return Level.FINER;
            }
        }
        return Level.FINEST;
    }
}

