/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.util;

import java.io.IOException;
import org.apache.spark.SparkException$;
import org.apache.spark.sql.util.AbstractMessageIterator;
import org.sparkproject.org.apache.arrow.memory.BufferAllocator;
import org.sparkproject.org.apache.arrow.vector.ipc.ArrowReader;
import org.sparkproject.org.apache.arrow.vector.ipc.message.ArrowDictionaryBatch;
import org.sparkproject.org.apache.arrow.vector.ipc.message.ArrowMessage;
import org.sparkproject.org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.sparkproject.org.apache.arrow.vector.types.pojo.Schema;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005i4Qa\u0004\t\u0001%iA\u0001\"\n\u0001\u0003\u0002\u0003\u0006Ia\n\u0005\t[\u0001\u0011\t\u0011)A\u0005]!A\u0001\t\u0001B\u0001B\u0003%\u0011\tC\u0003F\u0001\u0011\u0005a\t\u0003\u0004L\u0001\u0001\u0006K\u0001\u0014\u0005\n\u001f\u0002\u0001\r\u0011!Q!\nqBQ\u0001\u0015\u0001\u0005RECQA\u0017\u0001\u0005\nmCQA\u0019\u0001\u0005B\rDQ\u0001\u001a\u0001\u0005\n\u0015DQ\u0001\u001a\u0001\u0005\n-DQ\u0001\u001d\u0001\u0005\nEDQa\u001d\u0001\u0005BQDQ!\u001e\u0001\u0005BY\u0014adQ8oG\u0006$XM\\1uS:<\u0017I\u001d:poN#(/Z1n%\u0016\fG-\u001a:\u000b\u0005E\u0011\u0012\u0001B;uS2T!a\u0005\u000b\u0002\u0007M\fHN\u0003\u0002\u0016-\u0005)1\u000f]1sW*\u0011q\u0003G\u0001\u0007CB\f7\r[3\u000b\u0003e\t1a\u001c:h'\t\u00011\u0004\u0005\u0002\u001dG5\tQD\u0003\u0002\u001f?\u0005\u0019\u0011\u000e]2\u000b\u0005\u0001\n\u0013A\u0002<fGR|'O\u0003\u0002#-\u0005)\u0011M\u001d:po&\u0011A%\b\u0002\f\u0003J\u0014xn\u001e*fC\u0012,'/A\u0005bY2|7-\u0019;pe\u000e\u0001\u0001C\u0001\u0015,\u001b\u0005I#B\u0001\u0016\"\u0003\u0019iW-\\8ss&\u0011A&\u000b\u0002\u0010\u0005V4g-\u001a:BY2|7-\u0019;pe\u0006)\u0011N\u001c9viB\u0019q&\u000f\u001f\u000f\u0005A2dBA\u00195\u001b\u0005\u0011$BA\u001a'\u0003\u0019a$o\\8u}%\tQ'A\u0003tG\u0006d\u0017-\u0003\u00028q\u00059\u0001/Y2lC\u001e,'\"A\u001b\n\u0005iZ$\u0001C%uKJ\fGo\u001c:\u000b\u0005]B\u0004CA\u001f?\u001b\u0005\u0001\u0012BA \u0011\u0005]\t%m\u001d;sC\u000e$X*Z:tC\u001e,\u0017\n^3sCR|'/A\u0006eKN$(/^2uSZ,\u0007C\u0001\"D\u001b\u0005A\u0014B\u0001#9\u0005\u001d\u0011un\u001c7fC:\fa\u0001P5oSRtD\u0003B$I\u0013*\u0003\"!\u0010\u0001\t\u000b\u0015\"\u0001\u0019A\u0014\t\u000b5\"\u0001\u0019\u0001\u0018\t\u000b\u0001#\u0001\u0019A!\u0002\u001dQ|G/\u00197CsR,7OU3bIB\u0011!)T\u0005\u0003\u001db\u0012A\u0001T8oO\u000691-\u001e:sK:$\u0018A\u0003:fC\u0012\u001c6\r[3nCR\t!\u000b\u0005\u0002T16\tAK\u0003\u0002V-\u0006!\u0001o\u001c6p\u0015\t9v$A\u0003usB,7/\u0003\u0002Z)\n11k\u00195f[\u0006\f1B\\3yi6+7o]1hKR\tA\f\u0005\u0002^A6\taL\u0003\u0002`;\u00059Q.Z:tC\u001e,\u0017BA1_\u00051\t%O]8x\u001b\u0016\u001c8/Y4f\u00035aw.\u00193OKb$()\u0019;dQR\t\u0011)A\u000bdY>tW-\u00134O_:$Um\u001d;sk\u000e$\u0018N^3\u0015\u0005\u0019L\u0007CA/h\u0013\tAgL\u0001\tBeJ|wOU3d_J$')\u0019;dQ\")!N\u0003a\u0001M\u0006)!-\u0019;dQR\u0011An\u001c\t\u0003;6L!A\u001c0\u0003)\u0005\u0013(o\\<ES\u000e$\u0018n\u001c8bef\u0014\u0015\r^2i\u0011\u0015Q7\u00021\u0001m\u0003A\u0019Gn\u001c8f%\u0016\u001cwN\u001d3CCR\u001c\u0007\u000e\u0006\u0002ge\")!\u000e\u0004a\u0001M\u0006I!-\u001f;fgJ+\u0017\r\u001a\u000b\u0002\u0019\u0006y1\r\\8tKJ+\u0017\rZ*pkJ\u001cW\rF\u0001x!\t\u0011\u00050\u0003\u0002zq\t!QK\\5u\u0001")
public class ConcatenatingArrowStreamReader
extends ArrowReader {
    private final Iterator<AbstractMessageIterator> input;
    private final boolean destructive;
    private long totalBytesRead;
    private AbstractMessageIterator current;

    @Override
    public Schema readSchema() {
        Predef$.MODULE$.assert(this.current == null);
        if (!this.input.hasNext()) {
            throw new IOException("Unexpected end of input. Missing schema.");
        }
        this.current = (AbstractMessageIterator)this.input.next();
        return this.current.schema();
    }

    private ArrowMessage nextMessage() {
        Predef$.MODULE$.assert(this.current != null);
        while (!this.current.hasNext() && this.input.hasNext()) {
            this.totalBytesRead += this.current.bytesRead();
            this.current = (AbstractMessageIterator)this.input.next();
            Schema schema = this.current.schema();
            Schema schema2 = this.getVectorSchemaRoot().getSchema();
            if (!(schema == null ? schema2 != null : !((Object)schema).equals(schema2))) continue;
            throw SparkException$.MODULE$.internalError("IPC Streams have different schemas.");
        }
        if (this.current.hasNext()) {
            return (ArrowMessage)this.current.next();
        }
        return null;
    }

    @Override
    public boolean loadNextBatch() {
        ArrowMessage message = this.nextMessage();
        while (message != null) {
            ArrowMessage arrowMessage = message;
            if (arrowMessage instanceof ArrowRecordBatch) {
                ArrowRecordBatch arrowRecordBatch = (ArrowRecordBatch)arrowMessage;
                this.loadRecordBatch(this.cloneIfNonDestructive(arrowRecordBatch));
                if (this.getVectorSchemaRoot().getRowCount() > 0) {
                    return true;
                }
            } else if (arrowMessage instanceof ArrowDictionaryBatch) {
                ArrowDictionaryBatch arrowDictionaryBatch = (ArrowDictionaryBatch)arrowMessage;
                this.loadDictionary(this.cloneIfNonDestructive(arrowDictionaryBatch));
            } else {
                throw new MatchError((Object)arrowMessage);
            }
            message = this.nextMessage();
        }
        return false;
    }

    private ArrowRecordBatch cloneIfNonDestructive(ArrowRecordBatch batch) {
        if (this.destructive) {
            return batch;
        }
        return this.cloneRecordBatch(batch);
    }

    private ArrowDictionaryBatch cloneIfNonDestructive(ArrowDictionaryBatch batch) {
        if (this.destructive) {
            return batch;
        }
        return new ArrowDictionaryBatch(batch.getDictionaryId(), this.cloneRecordBatch(batch.getDictionary()), batch.isDelta());
    }

    private ArrowRecordBatch cloneRecordBatch(ArrowRecordBatch batch) {
        return new ArrowRecordBatch(batch.getLength(), batch.getNodes(), batch.getBuffers(), batch.getBodyCompression(), true, true);
    }

    @Override
    public long bytesRead() {
        if (this.current != null) {
            return this.totalBytesRead + this.current.bytesRead();
        }
        return 0L;
    }

    @Override
    public void closeReadSource() {
    }

    public ConcatenatingArrowStreamReader(BufferAllocator allocator, Iterator<AbstractMessageIterator> input, boolean destructive) {
        this.input = input;
        this.destructive = destructive;
        super(allocator);
        this.totalBytesRead = 0L;
    }
}

