/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.ParentReference;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.ParentReferenceBuilder;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.ParentReferenceFluent;
import io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.UDPRouteRule;
import io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.UDPRouteRuleBuilder;
import io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.UDPRouteRuleFluent;
import io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.UDPRouteSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class UDPRouteSpecFluent<A extends UDPRouteSpecFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private ArrayList<ParentReferenceBuilder> parentRefs = new ArrayList();
    private ArrayList<UDPRouteRuleBuilder> rules = new ArrayList();
    private String useDefaultGateways;

    public UDPRouteSpecFluent() {
    }

    public UDPRouteSpecFluent(UDPRouteSpec instance) {
        this.copyInstance(instance);
    }

    public A addAllToParentRefs(Collection<ParentReference> items) {
        if (this.parentRefs == null) {
            this.parentRefs = new ArrayList();
        }
        for (ParentReference item : items) {
            ParentReferenceBuilder builder = new ParentReferenceBuilder(item);
            this._visitables.get((Object)"parentRefs").add(builder);
            this.parentRefs.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToRules(Collection<UDPRouteRule> items) {
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        for (UDPRouteRule item : items) {
            UDPRouteRuleBuilder builder = new UDPRouteRuleBuilder(item);
            this._visitables.get((Object)"rules").add(builder);
            this.rules.add(builder);
        }
        return (A)((Object)this);
    }

    public ParentRefsNested<A> addNewParentRef() {
        return new ParentRefsNested(-1, null);
    }

    public ParentRefsNested<A> addNewParentRefLike(ParentReference item) {
        return new ParentRefsNested(-1, item);
    }

    public RulesNested<A> addNewRule() {
        return new RulesNested(-1, null);
    }

    public RulesNested<A> addNewRuleLike(UDPRouteRule item) {
        return new RulesNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToParentRefs(ParentReference ... items) {
        if (this.parentRefs == null) {
            this.parentRefs = new ArrayList();
        }
        for (ParentReference item : items) {
            ParentReferenceBuilder builder = new ParentReferenceBuilder(item);
            this._visitables.get((Object)"parentRefs").add(builder);
            this.parentRefs.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToParentRefs(int index, ParentReference item) {
        if (this.parentRefs == null) {
            this.parentRefs = new ArrayList();
        }
        ParentReferenceBuilder builder = new ParentReferenceBuilder(item);
        if (index < 0 || index >= this.parentRefs.size()) {
            this._visitables.get((Object)"parentRefs").add(builder);
            this.parentRefs.add(builder);
        } else {
            this._visitables.get((Object)"parentRefs").add(builder);
            this.parentRefs.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToRules(UDPRouteRule ... items) {
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        for (UDPRouteRule item : items) {
            UDPRouteRuleBuilder builder = new UDPRouteRuleBuilder(item);
            this._visitables.get((Object)"rules").add(builder);
            this.rules.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToRules(int index, UDPRouteRule item) {
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        UDPRouteRuleBuilder builder = new UDPRouteRuleBuilder(item);
        if (index < 0 || index >= this.rules.size()) {
            this._visitables.get((Object)"rules").add(builder);
            this.rules.add(builder);
        } else {
            this._visitables.get((Object)"rules").add(builder);
            this.rules.add(index, builder);
        }
        return (A)((Object)this);
    }

    public ParentReference buildFirstParentRef() {
        return this.parentRefs.get(0).build();
    }

    public UDPRouteRule buildFirstRule() {
        return this.rules.get(0).build();
    }

    public ParentReference buildLastParentRef() {
        return this.parentRefs.get(this.parentRefs.size() - 1).build();
    }

    public UDPRouteRule buildLastRule() {
        return this.rules.get(this.rules.size() - 1).build();
    }

    public ParentReference buildMatchingParentRef(Predicate<ParentReferenceBuilder> predicate) {
        for (ParentReferenceBuilder item : this.parentRefs) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public UDPRouteRule buildMatchingRule(Predicate<UDPRouteRuleBuilder> predicate) {
        for (UDPRouteRuleBuilder item : this.rules) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public ParentReference buildParentRef(int index) {
        return this.parentRefs.get(index).build();
    }

    public List<ParentReference> buildParentRefs() {
        return this.parentRefs != null ? UDPRouteSpecFluent.build(this.parentRefs) : null;
    }

    public UDPRouteRule buildRule(int index) {
        return this.rules.get(index).build();
    }

    public List<UDPRouteRule> buildRules() {
        return this.rules != null ? UDPRouteSpecFluent.build(this.rules) : null;
    }

    protected void copyInstance(UDPRouteSpec instance) {
        UDPRouteSpec uDPRouteSpec = instance = instance != null ? instance : new UDPRouteSpec();
        if (instance != null) {
            this.withParentRefs(instance.getParentRefs());
            this.withRules(instance.getRules());
            this.withUseDefaultGateways(instance.getUseDefaultGateways());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ParentRefsNested<A> editFirstParentRef() {
        if (this.parentRefs.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "parentRefs"));
        }
        return this.setNewParentRefLike(0, this.buildParentRef(0));
    }

    public RulesNested<A> editFirstRule() {
        if (this.rules.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "rules"));
        }
        return this.setNewRuleLike(0, this.buildRule(0));
    }

    public ParentRefsNested<A> editLastParentRef() {
        int index = this.parentRefs.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "parentRefs"));
        }
        return this.setNewParentRefLike(index, this.buildParentRef(index));
    }

    public RulesNested<A> editLastRule() {
        int index = this.rules.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "rules"));
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    public ParentRefsNested<A> editMatchingParentRef(Predicate<ParentReferenceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.parentRefs.size(); ++i) {
            if (!predicate.test(this.parentRefs.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "parentRefs"));
        }
        return this.setNewParentRefLike(index, this.buildParentRef(index));
    }

    public RulesNested<A> editMatchingRule(Predicate<UDPRouteRuleBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.rules.size(); ++i) {
            if (!predicate.test(this.rules.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "rules"));
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    public ParentRefsNested<A> editParentRef(int index) {
        if (this.parentRefs.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "parentRefs"));
        }
        return this.setNewParentRefLike(index, this.buildParentRef(index));
    }

    public RulesNested<A> editRule(int index) {
        if (this.rules.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "rules"));
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UDPRouteSpecFluent that = (UDPRouteSpecFluent)((Object)o);
        if (!Objects.equals(this.parentRefs, that.parentRefs)) {
            return false;
        }
        if (!Objects.equals(this.rules, that.rules)) {
            return false;
        }
        if (!Objects.equals(this.useDefaultGateways, that.useDefaultGateways)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getUseDefaultGateways() {
        return this.useDefaultGateways;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasMatchingParentRef(Predicate<ParentReferenceBuilder> predicate) {
        for (ParentReferenceBuilder item : this.parentRefs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingRule(Predicate<UDPRouteRuleBuilder> predicate) {
        for (UDPRouteRuleBuilder item : this.rules) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasParentRefs() {
        return this.parentRefs != null && !this.parentRefs.isEmpty();
    }

    public boolean hasRules() {
        return this.rules != null && !this.rules.isEmpty();
    }

    public boolean hasUseDefaultGateways() {
        return this.useDefaultGateways != null;
    }

    public int hashCode() {
        return Objects.hash(this.parentRefs, this.rules, this.useDefaultGateways, this.additionalProperties);
    }

    public A removeAllFromParentRefs(Collection<ParentReference> items) {
        if (this.parentRefs == null) {
            return (A)((Object)this);
        }
        for (ParentReference item : items) {
            ParentReferenceBuilder builder = new ParentReferenceBuilder(item);
            this._visitables.get((Object)"parentRefs").remove((Object)builder);
            this.parentRefs.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromRules(Collection<UDPRouteRule> items) {
        if (this.rules == null) {
            return (A)((Object)this);
        }
        for (UDPRouteRule item : items) {
            UDPRouteRuleBuilder builder = new UDPRouteRuleBuilder(item);
            this._visitables.get((Object)"rules").remove((Object)builder);
            this.rules.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromParentRefs(ParentReference ... items) {
        if (this.parentRefs == null) {
            return (A)((Object)this);
        }
        for (ParentReference item : items) {
            ParentReferenceBuilder builder = new ParentReferenceBuilder(item);
            this._visitables.get((Object)"parentRefs").remove((Object)builder);
            this.parentRefs.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromRules(UDPRouteRule ... items) {
        if (this.rules == null) {
            return (A)((Object)this);
        }
        for (UDPRouteRule item : items) {
            UDPRouteRuleBuilder builder = new UDPRouteRuleBuilder(item);
            this._visitables.get((Object)"rules").remove((Object)builder);
            this.rules.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromParentRefs(Predicate<ParentReferenceBuilder> predicate) {
        if (this.parentRefs == null) {
            return (A)((Object)this);
        }
        Iterator<ParentReferenceBuilder> each = this.parentRefs.iterator();
        List visitables = this._visitables.get((Object)"parentRefs");
        while (each.hasNext()) {
            ParentReferenceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromRules(Predicate<UDPRouteRuleBuilder> predicate) {
        if (this.rules == null) {
            return (A)((Object)this);
        }
        Iterator<UDPRouteRuleBuilder> each = this.rules.iterator();
        List visitables = this._visitables.get((Object)"rules");
        while (each.hasNext()) {
            UDPRouteRuleBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public ParentRefsNested<A> setNewParentRefLike(int index, ParentReference item) {
        return new ParentRefsNested(index, item);
    }

    public RulesNested<A> setNewRuleLike(int index, UDPRouteRule item) {
        return new RulesNested(index, item);
    }

    public A setToParentRefs(int index, ParentReference item) {
        if (this.parentRefs == null) {
            this.parentRefs = new ArrayList();
        }
        ParentReferenceBuilder builder = new ParentReferenceBuilder(item);
        if (index < 0 || index >= this.parentRefs.size()) {
            this._visitables.get((Object)"parentRefs").add(builder);
            this.parentRefs.add(builder);
        } else {
            this._visitables.get((Object)"parentRefs").add(builder);
            this.parentRefs.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToRules(int index, UDPRouteRule item) {
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        UDPRouteRuleBuilder builder = new UDPRouteRuleBuilder(item);
        if (index < 0 || index >= this.rules.size()) {
            this._visitables.get((Object)"rules").add(builder);
            this.rules.add(builder);
        } else {
            this._visitables.get((Object)"rules").add(builder);
            this.rules.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.parentRefs != null && !this.parentRefs.isEmpty()) {
            sb.append("parentRefs:");
            sb.append(this.parentRefs);
            sb.append(",");
        }
        if (this.rules != null && !this.rules.isEmpty()) {
            sb.append("rules:");
            sb.append(this.rules);
            sb.append(",");
        }
        if (this.useDefaultGateways != null) {
            sb.append("useDefaultGateways:");
            sb.append(this.useDefaultGateways);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withParentRefs(List<ParentReference> parentRefs) {
        if (this.parentRefs != null) {
            this._visitables.get((Object)"parentRefs").clear();
        }
        if (parentRefs != null) {
            this.parentRefs = new ArrayList();
            for (ParentReference item : parentRefs) {
                this.addToParentRefs(item);
            }
        } else {
            this.parentRefs = null;
        }
        return (A)((Object)this);
    }

    public A withParentRefs(ParentReference ... parentRefs) {
        if (this.parentRefs != null) {
            this.parentRefs.clear();
            this._visitables.remove((Object)"parentRefs");
        }
        if (parentRefs != null) {
            for (ParentReference item : parentRefs) {
                this.addToParentRefs(item);
            }
        }
        return (A)((Object)this);
    }

    public A withRules(List<UDPRouteRule> rules) {
        if (this.rules != null) {
            this._visitables.get((Object)"rules").clear();
        }
        if (rules != null) {
            this.rules = new ArrayList();
            for (UDPRouteRule item : rules) {
                this.addToRules(item);
            }
        } else {
            this.rules = null;
        }
        return (A)((Object)this);
    }

    public A withRules(UDPRouteRule ... rules) {
        if (this.rules != null) {
            this.rules.clear();
            this._visitables.remove((Object)"rules");
        }
        if (rules != null) {
            for (UDPRouteRule item : rules) {
                this.addToRules(item);
            }
        }
        return (A)((Object)this);
    }

    public A withUseDefaultGateways(String useDefaultGateways) {
        this.useDefaultGateways = useDefaultGateways;
        return (A)((Object)this);
    }

    public class RulesNested<N>
    extends UDPRouteRuleFluent<RulesNested<N>>
    implements Nested<N> {
        UDPRouteRuleBuilder builder;
        int index;

        RulesNested(int index, UDPRouteRule item) {
            this.index = index;
            this.builder = new UDPRouteRuleBuilder(this, item);
        }

        public N and() {
            return (N)UDPRouteSpecFluent.this.setToRules(this.index, this.builder.build());
        }

        public N endRule() {
            return this.and();
        }
    }

    public class ParentRefsNested<N>
    extends ParentReferenceFluent<ParentRefsNested<N>>
    implements Nested<N> {
        ParentReferenceBuilder builder;
        int index;

        ParentRefsNested(int index, ParentReference item) {
            this.index = index;
            this.builder = new ParentReferenceBuilder(this, item);
        }

        public N and() {
            return (N)UDPRouteSpecFluent.this.setToParentRefs(this.index, this.builder.build());
        }

        public N endParentRef() {
            return this.and();
        }
    }
}

