/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.python;

import java.io.File;
import java.io.Serializable;
import java.util.LinkedList;
import org.apache.spark.memory.MemoryConsumer;
import org.apache.spark.memory.SparkOutOfMemoryError;
import org.apache.spark.memory.TaskMemoryManager;
import org.apache.spark.serializer.SerializerManager;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.python.Queue;
import org.apache.spark.sql.execution.python.QueueMode$;
import org.apache.spark.unsafe.memory.MemoryBlock;
import scala.Enumeration;
import scala.Function0;
import scala.Predef$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005}e!\u0002\u0012$\u0003\u0003\u0001\u0004\u0002\u0003\u001d\u0001\u0005\u0003\u0005\u000b\u0011B\u001d\t\u0011q\u0002!\u0011!Q\u0001\nuB\u0001\"\u0012\u0001\u0003\u0002\u0003\u0006IA\u0012\u0005\u0006\u0019\u0002!\t!\u0014\u0005\bQ\u0002\u0001\r\u0011\"\u0005j\u0011\u001d\u0001\b\u00011A\u0005\u0012EDaa\u001e\u0001!B\u0013Q\u0007\"\u0003=\u0001\u0001\u0004\u0005\r\u0011\"\u0003z\u0011%Q\b\u00011AA\u0002\u0013%1\u0010C\u0005~\u0001\u0001\u0007\t\u0011)Q\u0005=\"Ia\u0010\u0001a\u0001\u0002\u0004%\t\"\u001f\u0005\u000b\u007f\u0002\u0001\r\u00111A\u0005\u0012\u0005\u0005\u0001BCA\u0003\u0001\u0001\u0007\t\u0011)Q\u0005=\"I\u0011q\u0001\u0001A\u0002\u0013E\u0011\u0011\u0002\u0005\n\u0003#\u0001\u0001\u0019!C\t\u0003'A\u0001\"a\u0006\u0001A\u0003&\u00111\u0002\u0005\n\u00033\u0001\u0001\u0019!C\t\u0003\u0013A\u0011\"a\u0007\u0001\u0001\u0004%\t\"!\b\t\u0011\u0005\u0005\u0002\u0001)Q\u0005\u0003\u0017A\u0001\"a\t\u0001\t\u0003\u0019\u0013Q\u0005\u0005\b\u0003[\u0001a\u0011CA\u0018\u0011\u001d\t\t\u0004\u0001D\t\u0003gAq!a\u0012\u0001\r#\tI\u0005C\u0004\u0002P\u00011\t\"!\u0015\t\u000f\u0005]\u0003A\"\u0005\u0002Z!9\u00111\r\u0001\u0005\u0012\u0005\u0015\u0004bBA4\u0001\u0011\u0005\u0011\u0011\u000e\u0005\b\u0003g\u0002A\u0011BA;\u0011\u001d\tY\b\u0001C\u0001\u0003{Bq!!%\u0001\t\u0003\t\u0019\nC\u0004\u0002\u0016\u0002!\t!a&\t\u000f\u0005e\u0005\u0001\"\u0001\u0002\u001c\"9\u0011Q\u0014\u0001\u0005\u0002\u0005m%a\u0003%zEJLG-U;fk\u0016T!\u0001J\u0013\u0002\rALH\u000f[8o\u0015\t1s%A\u0005fq\u0016\u001cW\u000f^5p]*\u0011\u0001&K\u0001\u0004gFd'B\u0001\u0016,\u0003\u0015\u0019\b/\u0019:l\u0015\taS&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002]\u0005\u0019qN]4\u0004\u0001U\u0019\u0011GU0\u0014\u0005\u0001\u0011\u0004CA\u001a7\u001b\u0005!$BA\u001b*\u0003\u0019iW-\\8ss&\u0011q\u0007\u000e\u0002\u000f\u001b\u0016lwN]=D_:\u001cX/\\3s\u0003)iW-\\'b]\u0006<WM\u001d\t\u0003giJ!a\u000f\u001b\u0003#Q\u000b7o['f[>\u0014\u00180T1oC\u001e,'/A\u0004uK6\u0004H)\u001b:\u0011\u0005y\u001aU\"A \u000b\u0005\u0001\u000b\u0015AA5p\u0015\u0005\u0011\u0015\u0001\u00026bm\u0006L!\u0001R \u0003\t\u0019KG.Z\u0001\u0007g\u0016\u0014Xj\u001a:\u0011\u0005\u001dSU\"\u0001%\u000b\u0005%K\u0013AC:fe&\fG.\u001b>fe&\u00111\n\u0013\u0002\u0012'\u0016\u0014\u0018.\u00197ju\u0016\u0014X*\u00198bO\u0016\u0014\u0018A\u0002\u001fj]&$h\b\u0006\u0003OK\u001a<\u0007\u0003B(\u0001!zk\u0011a\t\t\u0003#Jc\u0001\u0001B\u0003T\u0001\t\u0007AKA\u0001U#\t)6\f\u0005\u0002W36\tqKC\u0001Y\u0003\u0015\u00198-\u00197b\u0013\tQvKA\u0004O_RD\u0017N\\4\u0011\u0005Yc\u0016BA/X\u0005\r\te.\u001f\t\u0003#~#Q\u0001\u0019\u0001C\u0002\u0005\u0014\u0011!U\t\u0003+\n\u00042aT2Q\u0013\t!7EA\u0003Rk\u0016,X\rC\u00039\t\u0001\u0007\u0011\bC\u0003=\t\u0001\u0007Q\bC\u0003F\t\u0001\u0007a)\u0001\u0004rk\u0016,Xm]\u000b\u0002UB\u00191N\u001c0\u000e\u00031T!!\\!\u0002\tU$\u0018\u000e\\\u0005\u0003_2\u0014!\u0002T5oW\u0016$G*[:u\u0003)\tX/Z;fg~#S-\u001d\u000b\u0003eV\u0004\"AV:\n\u0005Q<&\u0001B+oSRDqA\u001e\u0004\u0002\u0002\u0003\u0007!.A\u0002yIE\nq!];fk\u0016\u001c\b%A\u0004xe&$\u0018N\\4\u0016\u0003y\u000b1b\u001e:ji&twm\u0018\u0013fcR\u0011!\u000f \u0005\bm&\t\t\u00111\u0001_\u0003!9(/\u001b;j]\u001e\u0004\u0013a\u0002:fC\u0012LgnZ\u0001\fe\u0016\fG-\u001b8h?\u0012*\u0017\u000fF\u0002s\u0003\u0007AqA\u001e\u0007\u0002\u0002\u0003\u0007a,\u0001\u0005sK\u0006$\u0017N\\4!\u0003]qW/\\#mK6,g\u000e^:Rk\u0016,X\rZ(o\t&\u001c8.\u0006\u0002\u0002\fA\u0019a+!\u0004\n\u0007\u0005=qK\u0001\u0003M_:<\u0017a\u00078v[\u0016cW-\\3oiN\fV/Z;fI>sG)[:l?\u0012*\u0017\u000fF\u0002s\u0003+A\u0001B^\b\u0002\u0002\u0003\u0007\u00111B\u0001\u0019]VlW\t\\3nK:$8/U;fk\u0016$wJ\u001c#jg.\u0004\u0013!\u00058v[\u0016cW-\\3oiN\fV/Z;fI\u0006)b.^7FY\u0016lWM\u001c;t#V,W/\u001a3`I\u0015\fHc\u0001:\u0002 !AaOEA\u0001\u0002\u0004\tY!\u0001\nok6,E.Z7f]R\u001c\u0018+^3vK\u0012\u0004\u0013!\u00038v[F+X-^3t)\t\t9\u0003E\u0002W\u0003SI1!a\u000bX\u0005\rIe\u000e^\u0001\u0010GJ,\u0017\r^3ESN\\\u0017+^3vKR\ta,A\nde\u0016\fG/Z%o\u001b\u0016lwN]=Rk\u0016,X\rF\u0002_\u0003kAq!a\u000e\u0017\u0001\u0004\tI$\u0001\u0003qC\u001e,\u0007\u0003BA\u001e\u0003\u0007j!!!\u0010\u000b\u0007U\nyDC\u0002\u0002B%\na!\u001e8tC\u001a,\u0017\u0002BA#\u0003{\u00111\"T3n_JL(\t\\8dW\u0006yq-\u001a;SKF,\u0018N]3e'&TX\r\u0006\u0003\u0002\f\u0005-\u0003BBA'/\u0001\u0007\u0001+\u0001\u0003ji\u0016l\u0017aC4fiB\u000bw-Z*ju\u0016$B!a\u0003\u0002T!1\u0011Q\u000b\rA\u0002y\u000bQ!];fk\u0016\fq\"[:J]6+Wn\u001c:z#V,W/\u001a\u000b\u0005\u00037\n\t\u0007E\u0002W\u0003;J1!a\u0018X\u0005\u001d\u0011un\u001c7fC:Da!!\u0016\u001a\u0001\u0004q\u0016AF5t%\u0016\fG-\u001b8h\rJ|W\u000eR5tWF+X-^3\u0016\u0005\u0005m\u0013!B:qS2dGCBA\u0006\u0003W\ny\u0007C\u0004\u0002nm\u0001\r!a\u0003\u0002\tML'0\u001a\u0005\u0007\u0003cZ\u0002\u0019\u0001\u001a\u0002\u000fQ\u0014\u0018nZ4fe\u0006q1M]3bi\u0016tUm^)vKV,Gc\u00010\u0002x!9\u0011\u0011\u0010\u000fA\u0002\u0005-\u0011\u0001\u0003:fcVL'/\u001a3\u0002\u0007\u0005$G\r\u0006\u0003\u0002\u0000\u0005=\u0005\u0003BAA\u0003\u000fs1aTAB\u0013\r\t)iI\u0001\n#V,W/Z'pI\u0016LA!!#\u0002\f\n)a+\u00197vK&\u0019\u0011QR,\u0003\u0017\u0015sW/\\3sCRLwN\u001c\u0005\u0007\u0003\u001bj\u0002\u0019\u0001)\u0002\rI,Wn\u001c<f)\u0005\u0001\u0016!B2m_N,G#\u0001:\u00025\u001d,GOT;n\u000b2,W.\u001a8ugF+X-^3e\u001f:$\u0015n]6\u0015\u0005\u0005-\u0011\u0001F4fi:+X.\u00127f[\u0016tGo])vKV,G\r")
public abstract class HybridQueue<T, Q extends Queue<T>>
extends MemoryConsumer {
    private LinkedList<Q> queues = new LinkedList();
    private Q writing;
    private Q reading;
    private long numElementsQueuedOnDisk = 0L;
    private long numElementsQueued = 0L;

    public LinkedList<Q> queues() {
        return this.queues;
    }

    public void queues_$eq(LinkedList<Q> x$1) {
        this.queues = x$1;
    }

    private Q writing() {
        return this.writing;
    }

    private void writing_$eq(Q x$1) {
        this.writing = x$1;
    }

    public Q reading() {
        return this.reading;
    }

    public void reading_$eq(Q x$1) {
        this.reading = x$1;
    }

    public long numElementsQueuedOnDisk() {
        return this.numElementsQueuedOnDisk;
    }

    public void numElementsQueuedOnDisk_$eq(long x$1) {
        this.numElementsQueuedOnDisk = x$1;
    }

    public long numElementsQueued() {
        return this.numElementsQueued;
    }

    public void numElementsQueued_$eq(long x$1) {
        this.numElementsQueued = x$1;
    }

    public int numQueues() {
        return this.queues().size();
    }

    public abstract Q createDiskQueue();

    public abstract Q createInMemoryQueue(MemoryBlock var1);

    public abstract long getRequiredSize(T var1);

    public abstract long getPageSize(Q var1);

    public abstract boolean isInMemoryQueue(Q var1);

    public boolean isReadingFromDiskQueue() {
        return !this.isInMemoryQueue(this.reading());
    }

    public long spill(long size, MemoryConsumer trigger) {
        MemoryConsumer memoryConsumer = trigger;
        HybridQueue hybridQueue = this;
        if (!(memoryConsumer != null ? !memoryConsumer.equals((Object)hybridQueue) : hybridQueue != null)) {
            return 0L;
        }
        long released = 0L;
        HybridQueue hybridQueue2 = this;
        synchronized (hybridQueue2) {
            LinkedList<Queue> newQueues = new LinkedList<Queue>();
            while (!this.queues().isEmpty()) {
                Queue<Object> queue;
                Queue queue2 = (Queue)this.queues().remove();
                if (!this.queues().isEmpty() && this.isInMemoryQueue(queue2)) {
                    Q diskQueue = this.createDiskQueue();
                    Object item = queue2.remove();
                    while (item != null) {
                        diskQueue.add(item);
                        item = queue2.remove();
                    }
                    released += this.getPageSize(queue2);
                    queue2.close();
                    queue = diskQueue;
                } else {
                    queue = queue2;
                }
                Queue newQueue = queue;
                newQueues.add(newQueue);
            }
            this.queues_$eq(newQueues);
        }
        return released;
    }

    private Q createNewQueue(long required) {
        MemoryBlock memoryBlock;
        try {
            memoryBlock = this.allocatePage(required);
        }
        catch (SparkOutOfMemoryError sparkOutOfMemoryError) {
            memoryBlock = null;
        }
        MemoryBlock page = memoryBlock;
        Q buffer = page != null ? this.createInMemoryQueue(page) : this.createDiskQueue();
        HybridQueue hybridQueue = this;
        synchronized (hybridQueue) {
            this.queues().add(buffer);
        }
        return buffer;
    }

    public Enumeration.Value add(T item) {
        if (this.writing() == null || !this.writing().add(item)) {
            this.writing_$eq(this.createNewQueue(this.getRequiredSize(item)));
            if (!this.writing().add(item)) {
                throw QueryExecutionErrors$.MODULE$.failedToPushRowIntoRowQueueError(this.writing().toString());
            }
        }
        this.numElementsQueued_$eq(this.numElementsQueued() + 1L);
        if (this.isInMemoryQueue(this.writing())) {
            return QueueMode$.MODULE$.IN_MEMORY();
        }
        this.numElementsQueuedOnDisk_$eq(this.numElementsQueuedOnDisk() + 1L);
        return QueueMode$.MODULE$.DISK();
    }

    public T remove() {
        T item = null;
        if (this.reading() != null) {
            item = this.reading().remove();
        }
        if (item == null) {
            if (this.reading() != null) {
                this.reading().close();
            }
            HybridQueue hybridQueue = this;
            synchronized (hybridQueue) {
                this.reading_$eq((Queue)this.queues().remove());
            }
            Predef$.MODULE$.assert(this.reading() != null, (Function0 & Serializable)() -> "queue should not be empty");
            item = this.reading().remove();
            Predef$.MODULE$.assert(item != null, (Function0 & Serializable)() -> this.reading() + " should have at least one element");
        }
        if (!this.isInMemoryQueue(this.reading())) {
            this.numElementsQueuedOnDisk_$eq(this.numElementsQueuedOnDisk() - 1L);
        }
        this.numElementsQueued_$eq(this.numElementsQueued() - 1L);
        return item;
    }

    public void close() {
        if (this.reading() != null) {
            this.reading().close();
            this.reading_$eq(null);
        }
        HybridQueue hybridQueue = this;
        synchronized (hybridQueue) {
            while (!this.queues().isEmpty()) {
                ((Queue)this.queues().remove()).close();
            }
        }
    }

    public long getNumElementsQueuedOnDisk() {
        return this.numElementsQueuedOnDisk();
    }

    public long getNumElementsQueued() {
        return this.numElementsQueued();
    }

    public HybridQueue(TaskMemoryManager memManager, File tempDir, SerializerManager serMgr) {
        super(memManager, memManager.getTungstenMemoryMode());
    }
}

