/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.jee;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlID;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.HashSet;
import java.util.Set;
import org.apache.openejb.jee.InjectionTarget;
import org.apache.openejb.jee.JndiReference;
import org.apache.openejb.jee.MessageDestinationUsage;
import org.apache.openejb.jee.Text;
import org.apache.openejb.jee.TextMap;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="message-destination-refType", propOrder={"descriptions", "messageDestinationRefName", "messageDestinationType", "messageDestinationUsage", "messageDestinationLink", "mappedName", "injectionTarget", "lookupName"})
public class MessageDestinationRef
implements JndiReference {
    @XmlTransient
    protected TextMap description = new TextMap();
    @XmlElement(name="message-destination-ref-name", required=true)
    protected String messageDestinationRefName;
    @XmlElement(name="message-destination-type")
    protected String messageDestinationType;
    @XmlElement(name="message-destination-usage")
    protected MessageDestinationUsage messageDestinationUsage;
    @XmlElement(name="message-destination-link")
    protected String messageDestinationLink;
    @XmlElement(name="mapped-name")
    protected String mappedName;
    @XmlElement(name="lookup-name")
    protected String lookupName;
    @XmlElement(name="injection-target", required=true)
    protected Set<InjectionTarget> injectionTarget;
    @XmlAttribute
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @XmlID
    protected String id;

    @Override
    @XmlTransient
    public String getName() {
        return this.getMessageDestinationRefName();
    }

    @Override
    public String getKey() {
        String name = this.getName();
        if (name == null || name.startsWith("java:")) {
            return name;
        }
        return "java:comp/env/" + name;
    }

    public MessageDestinationRef name(String messageDestinationRefName) {
        this.messageDestinationRefName = messageDestinationRefName;
        return this;
    }

    public MessageDestinationRef type(String messageDestinationType) {
        this.messageDestinationType = messageDestinationType;
        return this;
    }

    public MessageDestinationRef type(Class<?> messageDestinationType) {
        return this.type(messageDestinationType.getName());
    }

    public MessageDestinationRef link(String messageDestinationLink) {
        this.messageDestinationLink = messageDestinationLink;
        return this;
    }

    public MessageDestinationRef mappedName(String mappedName) {
        this.mappedName = mappedName;
        return this;
    }

    public MessageDestinationRef lookup(String lookupName) {
        this.lookupName = lookupName;
        return this;
    }

    public MessageDestinationRef injectionTarget(String className, String property) {
        this.getInjectionTarget().add(new InjectionTarget(className, property));
        if (this.messageDestinationRefName == null) {
            this.messageDestinationRefName = "java:comp/env/" + className + "/" + property;
        }
        return this;
    }

    public MessageDestinationRef injectionTarget(Class<?> clazz, String property) {
        return this.injectionTarget(clazz.getName(), property);
    }

    @Override
    @XmlTransient
    public String getType() {
        return this.getMessageDestinationType();
    }

    @Override
    public void setName(String name) {
        this.setMessageDestinationRefName(name);
    }

    @Override
    public void setType(String type) {
        this.setMessageDestinationType(type);
    }

    @XmlElement(name="description", required=true)
    public Text[] getDescriptions() {
        return this.description.toArray();
    }

    public void setDescriptions(Text[] text) {
        this.description.set(text);
    }

    public String getDescription() {
        return this.description.get();
    }

    public String getMessageDestinationRefName() {
        return this.messageDestinationRefName;
    }

    public void setMessageDestinationRefName(String value) {
        this.messageDestinationRefName = value;
    }

    public String getMessageDestinationType() {
        return this.messageDestinationType;
    }

    public void setMessageDestinationType(String value) {
        this.messageDestinationType = value;
    }

    public MessageDestinationUsage getMessageDestinationUsage() {
        return this.messageDestinationUsage;
    }

    public void setMessageDestinationUsage(MessageDestinationUsage value) {
        this.messageDestinationUsage = value;
    }

    public String getMessageDestinationLink() {
        return this.messageDestinationLink;
    }

    public void setMessageDestinationLink(String value) {
        this.messageDestinationLink = value;
    }

    @Override
    public String getMappedName() {
        return this.mappedName;
    }

    @Override
    public void setMappedName(String value) {
        this.mappedName = value;
    }

    @Override
    public String getLookupName() {
        return this.lookupName;
    }

    @Override
    public void setLookupName(String lookupName) {
        this.lookupName = lookupName;
    }

    @Override
    public Set<InjectionTarget> getInjectionTarget() {
        if (this.injectionTarget == null) {
            this.injectionTarget = new HashSet<InjectionTarget>();
        }
        return this.injectionTarget;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        this.id = value;
    }

    public String toString() {
        return "MessageDestinationRef{name='" + this.messageDestinationRefName + "', type='" + this.messageDestinationType + "', usage=" + this.messageDestinationUsage + ", link='" + this.messageDestinationLink + "', mappedName='" + this.mappedName + "', lookupName='" + this.lookupName + "'}";
    }
}

