/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.util.Objects;
import org.hsqldb.lib.AbstractReadOnlyCollection;
import org.hsqldb.lib.Collection;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.Map;
import org.hsqldb.lib.MapEntry;
import org.hsqldb.lib.ObjectComparator;
import org.hsqldb.lib.Set;
import org.hsqldb.map.BaseHashMap;

public class HashMap<K, V>
extends BaseHashMap
implements Map<K, V> {
    private Set<K> keySet;
    private Collection<V> values;
    private Set<Map.Entry<K, V>> entries;

    public HashMap() {
        this(8);
    }

    public HashMap(int n) throws IllegalArgumentException {
        super(n, 3, 3, false);
    }

    public HashMap(int n, ObjectComparator<K> objectComparator) throws IllegalArgumentException {
        this(n);
        this.comparator = objectComparator;
    }

    @Override
    public boolean containsKey(Object object) {
        return super.containsObjectKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return super.containsValue(object);
    }

    @Override
    public V get(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        int n = this.comparator.hashCode(object);
        int n2 = this.getLookup(object, n);
        if (n2 != -1) {
            return (V)this.objectValueTable[n2];
        }
        return null;
    }

    @Override
    public V put(K k, V v) {
        if (k == null) {
            throw new NullPointerException();
        }
        return (V)super.addOrUpdate(0L, 0L, k, v);
    }

    @Override
    public V remove(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        return (V)super.removeObject(object, false);
    }

    public boolean remove(K k, V v) {
        if (k == null) {
            throw new NullPointerException();
        }
        Object object = super.remove(0L, 0L, k, v, true, false);
        return object != null;
    }

    public void putAll(Map<K, V> map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e == null) continue;
            this.put(e, map.get(e));
        }
    }

    public <T> T[] keysToArray(T[] TArray) {
        return this.toArray(TArray, true);
    }

    public <T> T[] valuesToArray(T[] TArray) {
        return this.toArray(TArray, false);
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new Values();
        }
        return this.values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entries == null) {
            this.entries = new EntrySet();
        }
        return this.entries;
    }

    private class Values
    extends AbstractReadOnlyCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            HashMap hashMap = HashMap.this;
            Objects.requireNonNull(hashMap);
            return new BaseHashMap.BaseHashIterator(hashMap, false);
        }

        @Override
        public int size() {
            return HashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }

    private class KeySet
    extends AbstractReadOnlyCollection<K>
    implements Set<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            HashMap hashMap = HashMap.this;
            Objects.requireNonNull(hashMap);
            return new BaseHashMap.BaseHashIterator(hashMap, true);
        }

        @Override
        public int size() {
            return HashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }

    private class EntrySetIterator
    extends BaseHashMap.BaseHashIterator {
        EntrySetIterator() {
            super(HashMap.this, true);
        }

        @Override
        public Map.Entry<K, V> next() {
            Object object = super.next();
            Object object2 = HashMap.this.objectValueTable[this.lookup];
            return new MapEntry<Object, Object>(object, object2);
        }
    }

    private class EntrySet
    extends AbstractReadOnlyCollection<Map.Entry<K, V>>
    implements Set<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntrySetIterator();
        }

        @Override
        public int size() {
            return HashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }
}

