/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.core.util.watch;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Duration;
import java.util.List;
import org.apache.wicket.Application;
import org.apache.wicket.ThreadContext;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.util.io.IOUtils;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.thread.ICode;
import org.apache.wicket.util.thread.Task;
import org.apache.wicket.util.watch.ModificationWatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Nio2ModificationWatcher
extends ModificationWatcher {
    private static final Logger LOG = LoggerFactory.getLogger(Nio2ModificationWatcher.class);
    private final WatchService watchService;
    private final Application application;
    private Task task;

    public Nio2ModificationWatcher(Application application, Duration pollFrequency) {
        try {
            this.application = application;
            this.watchService = FileSystems.getDefault().newWatchService();
            this.registerWatchables(this.watchService);
            this.start(pollFrequency);
        }
        catch (IOException iox) {
            throw new WicketRuntimeException("Cannot get the watch service", iox);
        }
    }

    @Override
    public void start(Duration pollFrequency) {
        this.task = new Task("Wicket-ModificationWatcher-NIO2");
        this.task.run(pollFrequency, new ICode(){

            @Override
            public void run(Logger log) {
                Nio2ModificationWatcher.this.checkCreated(log);
                Nio2ModificationWatcher.this.checkModified();
            }
        });
    }

    protected void checkCreated(Logger log) {
        WatchKey watchKey = this.watchService.poll();
        if (watchKey != null) {
            List<WatchEvent<?>> events = watchKey.pollEvents();
            for (WatchEvent<?> event : events) {
                WatchEvent.Kind<?> eventKind = event.kind();
                Path eventPath = (Path)event.context();
                if (eventKind == StandardWatchEventKinds.ENTRY_CREATE) {
                    this.entryCreated(eventPath, log);
                    continue;
                }
                if (eventKind == StandardWatchEventKinds.ENTRY_DELETE) {
                    this.entryDeleted(eventPath, log);
                    continue;
                }
                if (eventKind != StandardWatchEventKinds.ENTRY_MODIFY) continue;
                this.entryModified(eventPath, log);
            }
            watchKey.reset();
        }
    }

    protected void entryModified(Path path, Logger log) {
    }

    protected void entryDeleted(Path path, Logger log) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void entryCreated(Path path, Logger log) {
        if (Files.isDirectory(path, new LinkOption[0])) {
            try {
                this.register(path, this.watchService);
            }
            catch (IOException iox) {
                log.warn("Cannot register folder '" + String.valueOf(path) + "' to be watched.", iox);
            }
        } else {
            String absolutePath = path.toAbsolutePath().toFile().toURI().toString();
            try {
                ThreadContext.setApplication(this.application);
                this.application.getMarkupSettings().getMarkupFactory().getMarkupCache().removeMarkup(absolutePath);
            }
            finally {
                ThreadContext.setApplication(null);
            }
        }
    }

    @Override
    public void destroy() {
        try {
            super.destroy();
            if (this.task != null) {
                this.task.interrupt();
            }
        }
        finally {
            IOUtils.closeQuietly(this.watchService);
        }
    }

    private void registerWatchables(final WatchService watchService) throws IOException {
        String[] classPathEntries;
        String classpath = System.getProperty("java.class.path");
        for (String classPathEntry : classPathEntries = Strings.split(classpath, File.pathSeparatorChar)) {
            Path folder;
            if (classPathEntry.endsWith(".jar") || !Files.isDirectory(folder = Paths.get(classPathEntry, new String[0]), new LinkOption[0])) continue;
            this.register(folder, watchService);
            Files.walkFileTree(folder, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    Nio2ModificationWatcher.this.register(dir, watchService);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    private void register(Path folder, WatchService watchService) throws IOException {
        WatchEvent.Kind[] watchedKinds = this.getWatchedKinds(folder);
        LOG.debug("Registering folder '{}' to the watching service with kinds: {}", (Object)folder, (Object)watchedKinds);
        folder.register(watchService, watchedKinds);
    }

    protected WatchEvent.Kind[] getWatchedKinds(Path folder) {
        return new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY};
    }
}

