// Protocol Buffers - Google's data interchange format
// Copyright 2008 Google Inc.  All rights reserved.
//
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file or at
// https://developers.google.com/open-source/licenses/bsd

// Author: kenton@google.com (Kenton Varda)
//
// protoc (aka the Protocol Compiler) can be extended via plugins.  A plugin is
// just a program that reads a CodeGeneratorRequest from stdin and writes a
// CodeGeneratorResponse to stdout.
//
// Plugins written using C++ can use google/protobuf/compiler/plugin.h instead
// of dealing with the raw protocol defined here.
//
// A plugin executable needs only to be placed somewhere in the path.  The
// plugin should be named "protoc-gen-$NAME", and will then be used when the
// flag "--${NAME}_out" is passed to protoc.

// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/protobuf/compiler/plugin.proto

package pluginpb

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	descriptorpb "google.golang.org/protobuf/types/descriptorpb"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

// Sync with code_generator.h.
type CodeGeneratorResponse_Feature int32

const (
	CodeGeneratorResponse_FEATURE_NONE              CodeGeneratorResponse_Feature = 0
	CodeGeneratorResponse_FEATURE_PROTO3_OPTIONAL   CodeGeneratorResponse_Feature = 1
	CodeGeneratorResponse_FEATURE_SUPPORTS_EDITIONS CodeGeneratorResponse_Feature = 2
)

// Enum value maps for CodeGeneratorResponse_Feature.
var (
	CodeGeneratorResponse_Feature_name = map[int32]string{
		0: "FEATURE_NONE",
		1: "FEATURE_PROTO3_OPTIONAL",
		2: "FEATURE_SUPPORTS_EDITIONS",
	}
	CodeGeneratorResponse_Feature_value = map[string]int32{
		"FEATURE_NONE":              0,
		"FEATURE_PROTO3_OPTIONAL":   1,
		"FEATURE_SUPPORTS_EDITIONS": 2,
	}
)

func (x CodeGeneratorResponse_Feature) Enum() *CodeGeneratorResponse_Feature {
	p := new(CodeGeneratorResponse_Feature)
	*p = x
	return p
}

func (x CodeGeneratorResponse_Feature) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CodeGeneratorResponse_Feature) Descriptor() protoreflect.EnumDescriptor {
	return file_google_protobuf_compiler_plugin_proto_enumTypes[0].Descriptor()
}

func (CodeGeneratorResponse_Feature) Type() protoreflect.EnumType {
	return &file_google_protobuf_compiler_plugin_proto_enumTypes[0]
}

func (x CodeGeneratorResponse_Feature) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *CodeGeneratorResponse_Feature) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = CodeGeneratorResponse_Feature(num)
	return nil
}

// Deprecated: Use CodeGeneratorResponse_Feature.Descriptor instead.
func (CodeGeneratorResponse_Feature) EnumDescriptor() ([]byte, []int) {
	return file_google_protobuf_compiler_plugin_proto_rawDescGZIP(), []int{2, 0}
}

// The version number of protocol compiler.
type Version struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	Major *int32                 `protobuf:"varint,1,opt,name=major" json:"major,omitempty"`
	Minor *int32                 `protobuf:"varint,2,opt,name=minor" json:"minor,omitempty"`
	Patch *int32                 `protobuf:"varint,3,opt,name=patch" json:"patch,omitempty"`
	// A suffix for alpha, beta or rc release, e.g., "alpha-1", "rc2". It should
	// be empty for mainline stable releases.
	Suffix        *string `protobuf:"bytes,4,opt,name=suffix" json:"suffix,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Version) Reset() {
	*x = Version{}
	mi := &file_google_protobuf_compiler_plugin_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Version) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Version) ProtoMessage() {}

func (x *Version) ProtoReflect() protoreflect.Message {
	mi := &file_google_protobuf_compiler_plugin_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Version.ProtoReflect.Descriptor instead.
func (*Version) Descriptor() ([]byte, []int) {
	return file_google_protobuf_compiler_plugin_proto_rawDescGZIP(), []int{0}
}

func (x *Version) GetMajor() int32 {
	if x != nil && x.Major != nil {
		return *x.Major
	}
	return 0
}

func (x *Version) GetMinor() int32 {
	if x != nil && x.Minor != nil {
		return *x.Minor
	}
	return 0
}

func (x *Version) GetPatch() int32 {
	if x != nil && x.Patch != nil {
		return *x.Patch
	}
	return 0
}

func (x *Version) GetSuffix() string {
	if x != nil && x.Suffix != nil {
		return *x.Suffix
	}
	return ""
}

// An encoded CodeGeneratorRequest is written to the plugin's stdin.
type CodeGeneratorRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The .proto files that were explicitly listed on the command-line.  The
	// code generator should generate code only for these files.  Each file's
	// descriptor will be included in proto_file, below.
	FileToGenerate []string `protobuf:"bytes,1,rep,name=file_to_generate,json=fileToGenerate" json:"file_to_generate,omitempty"`
	// The generator parameter passed on the command-line.
	Parameter *string `protobuf:"bytes,2,opt,name=parameter" json:"parameter,omitempty"`
	// FileDescriptorProtos for all files in files_to_generate and everything
	// they import.  The files will appear in topological order, so each file
	// appears before any file that imports it.
	//
	// Note: the files listed in files_to_generate will include runtime-retention
	// options only, but all other files will include source-retention options.
	// The source_file_descriptors field below is available in case you need
	// source-retention options for files_to_generate.
	//
	// protoc guarantees that all proto_files will be written after
	// the fields above, even though this is not technically guaranteed by the
	// protobuf wire format.  This theoretically could allow a plugin to stream
	// in the FileDescriptorProtos and handle them one by one rather than read
	// the entire set into memory at once.  However, as of this writing, this
	// is not similarly optimized on protoc's end -- it will store all fields in
	// memory at once before sending them to the plugin.
	//
	// Type names of fields and extensions in the FileDescriptorProto are always
	// fully qualified.
	ProtoFile []*descriptorpb.FileDescriptorProto `protobuf:"bytes,15,rep,name=proto_file,json=protoFile" json:"proto_file,omitempty"`
	// File descriptors with all options, including source-retention options.
	// These descriptors are only provided for the files listed in
	// files_to_generate.
	SourceFileDescriptors []*descriptorpb.FileDescriptorProto `protobuf:"bytes,17,rep,name=source_file_descriptors,json=sourceFileDescriptors" json:"source_file_descriptors,omitempty"`
	// The version number of protocol compiler.
	CompilerVersion *Version `protobuf:"bytes,3,opt,name=compiler_version,json=compilerVersion" json:"compiler_version,omitempty"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *CodeGeneratorRequest) Reset() {
	*x = CodeGeneratorRequest{}
	mi := &file_google_protobuf_compiler_plugin_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CodeGeneratorRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CodeGeneratorRequest) ProtoMessage() {}

func (x *CodeGeneratorRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_protobuf_compiler_plugin_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CodeGeneratorRequest.ProtoReflect.Descriptor instead.
func (*CodeGeneratorRequest) Descriptor() ([]byte, []int) {
	return file_google_protobuf_compiler_plugin_proto_rawDescGZIP(), []int{1}
}

func (x *CodeGeneratorRequest) GetFileToGenerate() []string {
	if x != nil {
		return x.FileToGenerate
	}
	return nil
}

func (x *CodeGeneratorRequest) GetParameter() string {
	if x != nil && x.Parameter != nil {
		return *x.Parameter
	}
	return ""
}

func (x *CodeGeneratorRequest) GetProtoFile() []*descriptorpb.FileDescriptorProto {
	if x != nil {
		return x.ProtoFile
	}
	return nil
}

func (x *CodeGeneratorRequest) GetSourceFileDescriptors() []*descriptorpb.FileDescriptorProto {
	if x != nil {
		return x.SourceFileDescriptors
	}
	return nil
}

func (x *CodeGeneratorRequest) GetCompilerVersion() *Version {
	if x != nil {
		return x.CompilerVersion
	}
	return nil
}

// The plugin writes an encoded CodeGeneratorResponse to stdout.
type CodeGeneratorResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Error message.  If non-empty, code generation failed.  The plugin process
	// should exit with status code zero even if it reports an error in this way.
	//
	// This should be used to indicate errors in .proto files which prevent the
	// code generator from generating correct code.  Errors which indicate a
	// problem in protoc itself -- such as the input CodeGeneratorRequest being
	// unparseable -- should be reported by writing a message to stderr and
	// exiting with a non-zero status code.
	Error *string `protobuf:"bytes,1,opt,name=error" json:"error,omitempty"`
	// A bitmask of supported features that the code generator supports.
	// This is a bitwise "or" of values from the Feature enum.
	SupportedFeatures *uint64 `protobuf:"varint,2,opt,name=supported_features,json=supportedFeatures" json:"supported_features,omitempty"`
	// The minimum edition this plugin supports.  This will be treated as an
	// Edition enum, but we want to allow unknown values.  It should be specified
	// according the edition enum value, *not* the edition number.  Only takes
	// effect for plugins that have FEATURE_SUPPORTS_EDITIONS set.
	MinimumEdition *int32 `protobuf:"varint,3,opt,name=minimum_edition,json=minimumEdition" json:"minimum_edition,omitempty"`
	// The maximum edition this plugin supports.  This will be treated as an
	// Edition enum, but we want to allow unknown values.  It should be specified
	// according the edition enum value, *not* the edition number.  Only takes
	// effect for plugins that have FEATURE_SUPPORTS_EDITIONS set.
	MaximumEdition *int32                        `protobuf:"varint,4,opt,name=maximum_edition,json=maximumEdition" json:"maximum_edition,omitempty"`
	File           []*CodeGeneratorResponse_File `protobuf:"bytes,15,rep,name=file" json:"file,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *CodeGeneratorResponse) Reset() {
	*x = CodeGeneratorResponse{}
	mi := &file_google_protobuf_compiler_plugin_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CodeGeneratorResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CodeGeneratorResponse) ProtoMessage() {}

func (x *CodeGeneratorResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_protobuf_compiler_plugin_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CodeGeneratorResponse.ProtoReflect.Descriptor instead.
func (*CodeGeneratorResponse) Descriptor() ([]byte, []int) {
	return file_google_protobuf_compiler_plugin_proto_rawDescGZIP(), []int{2}
}

func (x *CodeGeneratorResponse) GetError() string {
	if x != nil && x.Error != nil {
		return *x.Error
	}
	return ""
}

func (x *CodeGeneratorResponse) GetSupportedFeatures() uint64 {
	if x != nil && x.SupportedFeatures != nil {
		return *x.SupportedFeatures
	}
	return 0
}

func (x *CodeGeneratorResponse) GetMinimumEdition() int32 {
	if x != nil && x.MinimumEdition != nil {
		return *x.MinimumEdition
	}
	return 0
}

func (x *CodeGeneratorResponse) GetMaximumEdition() int32 {
	if x != nil && x.MaximumEdition != nil {
		return *x.MaximumEdition
	}
	return 0
}

func (x *CodeGeneratorResponse) GetFile() []*CodeGeneratorResponse_File {
	if x != nil {
		return x.File
	}
	return nil
}

// Represents a single generated file.
type CodeGeneratorResponse_File struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The file name, relative to the output directory.  The name must not
	// contain "." or ".." components and must be relative, not be absolute (so,
	// the file cannot lie outside the output directory).  "/" must be used as
	// the path separator, not "\".
	//
	// If the name is omitted, the content will be appended to the previous
	// file.  This allows the generator to break large files into small chunks,
	// and allows the generated text to be streamed back to protoc so that large
	// files need not reside completely in memory at one time.  Note that as of
	// this writing protoc does not optimize for this -- it will read the entire
	// CodeGeneratorResponse before writing files to disk.
	Name *string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// If non-empty, indicates that the named file should already exist, and the
	// content here is to be inserted into that file at a defined insertion
	// point.  This feature allows a code generator to extend the output
	// produced by another code generator.  The original generator may provide
	// insertion points by placing special annotations in the file that look
	// like:
	//
	//	@@protoc_insertion_point(NAME)
	//
	// The annotation can have arbitrary text before and after it on the line,
	// which allows it to be placed in a comment.  NAME should be replaced with
	// an identifier naming the point -- this is what other generators will use
	// as the insertion_point.  Code inserted at this point will be placed
	// immediately above the line containing the insertion point (thus multiple
	// insertions to the same point will come out in the order they were added).
	// The double-@ is intended to make it unlikely that the generated code
	// could contain things that look like insertion points by accident.
	//
	// For example, the C++ code generator places the following line in the
	// .pb.h files that it generates:
	//
	//	// @@protoc_insertion_point(namespace_scope)
	//
	// This line appears within the scope of the file's package namespace, but
	// outside of any particular class.  Another plugin can then specify the
	// insertion_point "namespace_scope" to generate additional classes or
	// other declarations that should be placed in this scope.
	//
	// Note that if the line containing the insertion point begins with
	// whitespace, the same whitespace will be added to every line of the
	// inserted text.  This is useful for languages like Python, where
	// indentation matters.  In these languages, the insertion point comment
	// should be indented the same amount as any inserted code will need to be
	// in order to work correctly in that context.
	//
	// The code generator that generates the initial file and the one which
	// inserts into it must both run as part of a single invocation of protoc.
	// Code generators are executed in the order in which they appear on the
	// command line.
	//
	// If |insertion_point| is present, |name| must also be present.
	InsertionPoint *string `protobuf:"bytes,2,opt,name=insertion_point,json=insertionPoint" json:"insertion_point,omitempty"`
	// The file contents.
	Content *string `protobuf:"bytes,15,opt,name=content" json:"content,omitempty"`
	// Information describing the file content being inserted. If an insertion
	// point is used, this information will be appropriately offset and inserted
	// into the code generation metadata for the generated files.
	GeneratedCodeInfo *descriptorpb.GeneratedCodeInfo `protobuf:"bytes,16,opt,name=generated_code_info,json=generatedCodeInfo" json:"generated_code_info,omitempty"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *CodeGeneratorResponse_File) Reset() {
	*x = CodeGeneratorResponse_File{}
	mi := &file_google_protobuf_compiler_plugin_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CodeGeneratorResponse_File) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CodeGeneratorResponse_File) ProtoMessage() {}

func (x *CodeGeneratorResponse_File) ProtoReflect() protoreflect.Message {
	mi := &file_google_protobuf_compiler_plugin_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CodeGeneratorResponse_File.ProtoReflect.Descriptor instead.
func (*CodeGeneratorResponse_File) Descriptor() ([]byte, []int) {
	return file_google_protobuf_compiler_plugin_proto_rawDescGZIP(), []int{2, 0}
}

func (x *CodeGeneratorResponse_File) GetName() string {
	if x != nil && x.Name != nil {
		return *x.Name
	}
	return ""
}

func (x *CodeGeneratorResponse_File) GetInsertionPoint() string {
	if x != nil && x.InsertionPoint != nil {
		return *x.InsertionPoint
	}
	return ""
}

func (x *CodeGeneratorResponse_File) GetContent() string {
	if x != nil && x.Content != nil {
		return *x.Content
	}
	return ""
}

func (x *CodeGeneratorResponse_File) GetGeneratedCodeInfo() *descriptorpb.GeneratedCodeInfo {
	if x != nil {
		return x.GeneratedCodeInfo
	}
	return nil
}

var File_google_protobuf_compiler_plugin_proto protoreflect.FileDescriptor

const file_google_protobuf_compiler_plugin_proto_rawDesc = "" +
	"\n" +
	"%google/protobuf/compiler/plugin.proto\x12\x18google.protobuf.compiler\x1a google/protobuf/descriptor.proto\"c\n" +
	"\aVersion\x12\x14\n" +
	"\x05major\x18\x01 \x01(\x05R\x05major\x12\x14\n" +
	"\x05minor\x18\x02 \x01(\x05R\x05minor\x12\x14\n" +
	"\x05patch\x18\x03 \x01(\x05R\x05patch\x12\x16\n" +
	"\x06suffix\x18\x04 \x01(\tR\x06suffix\"\xcf\x02\n" +
	"\x14CodeGeneratorRequest\x12(\n" +
	"\x10file_to_generate\x18\x01 \x03(\tR\x0efileToGenerate\x12\x1c\n" +
	"\tparameter\x18\x02 \x01(\tR\tparameter\x12C\n" +
	"\n" +
	"proto_file\x18\x0f \x03(\v2$.google.protobuf.FileDescriptorProtoR\tprotoFile\x12\\\n" +
	"\x17source_file_descriptors\x18\x11 \x03(\v2$.google.protobuf.FileDescriptorProtoR\x15sourceFileDescriptors\x12L\n" +
	"\x10compiler_version\x18\x03 \x01(\v2!.google.protobuf.compiler.VersionR\x0fcompilerVersion\"\x85\x04\n" +
	"\x15CodeGeneratorResponse\x12\x14\n" +
	"\x05error\x18\x01 \x01(\tR\x05error\x12-\n" +
	"\x12supported_features\x18\x02 \x01(\x04R\x11supportedFeatures\x12'\n" +
	"\x0fminimum_edition\x18\x03 \x01(\x05R\x0eminimumEdition\x12'\n" +
	"\x0fmaximum_edition\x18\x04 \x01(\x05R\x0emaximumEdition\x12H\n" +
	"\x04file\x18\x0f \x03(\v24.google.protobuf.compiler.CodeGeneratorResponse.FileR\x04file\x1a\xb1\x01\n" +
	"\x04File\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x12'\n" +
	"\x0finsertion_point\x18\x02 \x01(\tR\x0einsertionPoint\x12\x18\n" +
	"\acontent\x18\x0f \x01(\tR\acontent\x12R\n" +
	"\x13generated_code_info\x18\x10 \x01(\v2\".google.protobuf.GeneratedCodeInfoR\x11generatedCodeInfo\"W\n" +
	"\aFeature\x12\x10\n" +
	"\fFEATURE_NONE\x10\x00\x12\x1b\n" +
	"\x17FEATURE_PROTO3_OPTIONAL\x10\x01\x12\x1d\n" +
	"\x19FEATURE_SUPPORTS_EDITIONS\x10\x02Br\n" +
	"\x1ccom.google.protobuf.compilerB\fPluginProtosZ)google.golang.org/protobuf/types/pluginpb\xaa\x02\x18Google.Protobuf.Compiler"

var (
	file_google_protobuf_compiler_plugin_proto_rawDescOnce sync.Once
	file_google_protobuf_compiler_plugin_proto_rawDescData []byte
)

func file_google_protobuf_compiler_plugin_proto_rawDescGZIP() []byte {
	file_google_protobuf_compiler_plugin_proto_rawDescOnce.Do(func() {
		file_google_protobuf_compiler_plugin_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_google_protobuf_compiler_plugin_proto_rawDesc), len(file_google_protobuf_compiler_plugin_proto_rawDesc)))
	})
	return file_google_protobuf_compiler_plugin_proto_rawDescData
}

var file_google_protobuf_compiler_plugin_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_protobuf_compiler_plugin_proto_msgTypes = make([]protoimpl.MessageInfo, 4)
var file_google_protobuf_compiler_plugin_proto_goTypes = []any{
	(CodeGeneratorResponse_Feature)(0),       // 0: google.protobuf.compiler.CodeGeneratorResponse.Feature
	(*Version)(nil),                          // 1: google.protobuf.compiler.Version
	(*CodeGeneratorRequest)(nil),             // 2: google.protobuf.compiler.CodeGeneratorRequest
	(*CodeGeneratorResponse)(nil),            // 3: google.protobuf.compiler.CodeGeneratorResponse
	(*CodeGeneratorResponse_File)(nil),       // 4: google.protobuf.compiler.CodeGeneratorResponse.File
	(*descriptorpb.FileDescriptorProto)(nil), // 5: google.protobuf.FileDescriptorProto
	(*descriptorpb.GeneratedCodeInfo)(nil),   // 6: google.protobuf.GeneratedCodeInfo
}
var file_google_protobuf_compiler_plugin_proto_depIdxs = []int32{
	5, // 0: google.protobuf.compiler.CodeGeneratorRequest.proto_file:type_name -> google.protobuf.FileDescriptorProto
	5, // 1: google.protobuf.compiler.CodeGeneratorRequest.source_file_descriptors:type_name -> google.protobuf.FileDescriptorProto
	1, // 2: google.protobuf.compiler.CodeGeneratorRequest.compiler_version:type_name -> google.protobuf.compiler.Version
	4, // 3: google.protobuf.compiler.CodeGeneratorResponse.file:type_name -> google.protobuf.compiler.CodeGeneratorResponse.File
	6, // 4: google.protobuf.compiler.CodeGeneratorResponse.File.generated_code_info:type_name -> google.protobuf.GeneratedCodeInfo
	5, // [5:5] is the sub-list for method output_type
	5, // [5:5] is the sub-list for method input_type
	5, // [5:5] is the sub-list for extension type_name
	5, // [5:5] is the sub-list for extension extendee
	0, // [0:5] is the sub-list for field type_name
}

func init() { file_google_protobuf_compiler_plugin_proto_init() }
func file_google_protobuf_compiler_plugin_proto_init() {
	if File_google_protobuf_compiler_plugin_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_google_protobuf_compiler_plugin_proto_rawDesc), len(file_google_protobuf_compiler_plugin_proto_rawDesc)),
			NumEnums:      1,
			NumMessages:   4,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_protobuf_compiler_plugin_proto_goTypes,
		DependencyIndexes: file_google_protobuf_compiler_plugin_proto_depIdxs,
		EnumInfos:         file_google_protobuf_compiler_plugin_proto_enumTypes,
		MessageInfos:      file_google_protobuf_compiler_plugin_proto_msgTypes,
	}.Build()
	File_google_protobuf_compiler_plugin_proto = out.File
	file_google_protobuf_compiler_plugin_proto_goTypes = nil
	file_google_protobuf_compiler_plugin_proto_depIdxs = nil
}
