      SUBROUTINE DCGCHK(IPAR,RPAR,N)
C***BEGIN PROLOGUE  DCGCHK
C***REFER TO  DCG,DCR,DPCG,DCGNR,DCGNE,DPCGNR,DPCGNE,DPPCG,DPCGCA
C***ROUTINES CALLED  D1MACH
C***REVISION DATE  860901   (YYMMDD)
C***END PROLOGUE  DCGCHK
C
C     THIS ROUTINE OUTPUTS THE INPUT PARAMETERS, AND THEN CHECKS THEIR
C     VALIDITY.  IF AN INVALID PARAMETER IS FOUND, AN ERROR MESSAGE IS
C     PRINTED AND THE CODE STOPPED.  IF AN UNUSUAL PARAMETER ASSIGNMENT
C     IS FOUND, A WARNING MESSAGE IS PRINTED, BUT THE CODE CONTINUES.
C
C     *** DECLARATIONS ***
      IMPLICIT  DOUBLE PRECISION(A-H,O-Z)
      DIMENSION IPAR(*),RPAR(*)
C
C***FIRST EXECUTABLE STATEMENT  DCGCHK
 1    CONTINUE
C
C     *** OUTPUT THE PARAMETERS ***
      IOUNIT = IPAR(5)
      IF (IOUNIT .LE. 0) GOTO 10
      WRITE(IOUNIT,5) N,IPAR(9),IPAR(31),IPAR(32),RPAR(1)
 5    FORMAT(' THE ITERATION PARAMETERS ARE ', /, 4X, 'N      = ', I5,
     2       /, 4X, 'ITMAX  = ', I5, /, 4X, 'ICYCLE = ', I5,
     3       /, 4X, 'NCE    = ', I5, /, 4X, 'ERRTOL = ', D12.5)
C
C     *** CHECK THE PARAMETERS ***
 10   IF (N .LE. 0) THEN 
         WRITE(IOUNIT,11)
 11      FORMAT(' ERROR IN DCGCHK: N .LE. 0', /)
         STOP
      END IF
C
      IF (IPAR(9) .LE. 0) WRITE(IOUNIT,12)
 12   FORMAT(/, ' WARNING IN DCGCHK: ITMAX .LE. 0', /)
C
      IF ((IPAR(31).LT.0) .OR. (IPAR(31).GT.IPAR(9))) WRITE(IOUNIT,13)
 13   FORMAT(/, ' WARNING IN DCGCHK: ICYCLE < 0 .OR. ICYCLE > ITMAX', /)
C
      IF (IPAR(32) .LT. 0) THEN
         WRITE(IOUNIT,14)
 14      FORMAT(/, ' WARNING IN DCGCHK: NCE .LT. 0; SET TO 0', /)
         IPAR(32) = 0
      END IF
C
      IF (RPAR(1) .LE. D1MACH(4)) WRITE(IOUNIT,15)
 15   FORMAT(/, ' WARNING IN DCGCHK: ERRTOL .LE. MACHINE EPSILON', /)
C
      RETURN
      END
