# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class AttestationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """AttestationType."""

    SGX_ENCLAVE = "SgxEnclave"
    """Intel Software Guard eXtensions"""
    OPEN_ENCLAVE = "OpenEnclave"
    """OpenEnclave extensions to SGX"""
    AZURE_GUEST = "AzureGuest"
    """Azure Guest Attestation"""
    SEV_SNP_VM = "SevSnpVm"
    """AMD SEV SNP Virtual Machine"""
    TPM = "Tpm"
    """Edge TPM Virtualization Based Security"""
    TDX_VM = "TdxVm"
    """Intel TDX Virtual Machine"""


class CertificateModification(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The result of the operation."""

    IS_PRESENT = "IsPresent"
    """After the operation was performed, the certificate is in the set of
certificates."""
    IS_ABSENT = "IsAbsent"
    """After the operation was performed, the certificate is no longer present in the
set of certificates."""


class DataType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the type of the data encoded contained within the "data" field of a
    "RuntimeData" or "InitTimeData" object.
    """

    BINARY = "Binary"
    """The field's content should be treated as binary and not interpreted by MAA."""
    JSON = "JSON"
    """The field's content should be treated as UTF-8 JSON text that may be further
interpreted by MAA. Refer to RFC 8259 for a description of JSON serialization
standards for interoperability."""


class PolicyModification(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The result of the operation."""

    UPDATED = "Updated"
    """The specified policy object was updated."""
    REMOVED = "Removed"
    """The specified policy object was removed."""


class SigningCertificatesContentType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Content type for upload."""

    APPLICATION_JWK_JSON = "application/jwk+json"
    """Content Type 'application/jwk+json'"""
    APPLICATION_JSON = "application/json"
    """Content Type 'application/json'"""
