# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from copy import deepcopy
from typing import Any, Awaitable, TYPE_CHECKING

from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.mgmt.core import AsyncARMPipelineClient

from .. import models
from .._serialization import Deserializer, Serializer
from ._configuration import LogicManagementClientConfiguration
from .operations import (
    IntegrationAccountAgreementsOperations,
    IntegrationAccountAssembliesOperations,
    IntegrationAccountBatchConfigurationsOperations,
    IntegrationAccountCertificatesOperations,
    IntegrationAccountMapsOperations,
    IntegrationAccountPartnersOperations,
    IntegrationAccountSchemasOperations,
    IntegrationAccountSessionsOperations,
    IntegrationAccountsOperations,
    IntegrationServiceEnvironmentManagedApiOperationsOperations,
    IntegrationServiceEnvironmentManagedApisOperations,
    IntegrationServiceEnvironmentNetworkHealthOperations,
    IntegrationServiceEnvironmentSkusOperations,
    IntegrationServiceEnvironmentsOperations,
    Operations,
    WorkflowRunActionRepetitionsOperations,
    WorkflowRunActionRepetitionsRequestHistoriesOperations,
    WorkflowRunActionRequestHistoriesOperations,
    WorkflowRunActionScopeRepetitionsOperations,
    WorkflowRunActionsOperations,
    WorkflowRunOperationsOperations,
    WorkflowRunsOperations,
    WorkflowTriggerHistoriesOperations,
    WorkflowTriggersOperations,
    WorkflowVersionTriggersOperations,
    WorkflowVersionsOperations,
    WorkflowsOperations,
)

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from azure.core.credentials_async import AsyncTokenCredential


class LogicManagementClient:  # pylint: disable=client-accepts-api-version-keyword,too-many-instance-attributes
    """REST API for Azure Logic Apps.

    :ivar workflows: WorkflowsOperations operations
    :vartype workflows: azure.mgmt.logic.aio.operations.WorkflowsOperations
    :ivar workflow_versions: WorkflowVersionsOperations operations
    :vartype workflow_versions: azure.mgmt.logic.aio.operations.WorkflowVersionsOperations
    :ivar workflow_triggers: WorkflowTriggersOperations operations
    :vartype workflow_triggers: azure.mgmt.logic.aio.operations.WorkflowTriggersOperations
    :ivar workflow_version_triggers: WorkflowVersionTriggersOperations operations
    :vartype workflow_version_triggers:
     azure.mgmt.logic.aio.operations.WorkflowVersionTriggersOperations
    :ivar workflow_trigger_histories: WorkflowTriggerHistoriesOperations operations
    :vartype workflow_trigger_histories:
     azure.mgmt.logic.aio.operations.WorkflowTriggerHistoriesOperations
    :ivar workflow_runs: WorkflowRunsOperations operations
    :vartype workflow_runs: azure.mgmt.logic.aio.operations.WorkflowRunsOperations
    :ivar workflow_run_actions: WorkflowRunActionsOperations operations
    :vartype workflow_run_actions: azure.mgmt.logic.aio.operations.WorkflowRunActionsOperations
    :ivar workflow_run_action_repetitions: WorkflowRunActionRepetitionsOperations operations
    :vartype workflow_run_action_repetitions:
     azure.mgmt.logic.aio.operations.WorkflowRunActionRepetitionsOperations
    :ivar workflow_run_action_repetitions_request_histories:
     WorkflowRunActionRepetitionsRequestHistoriesOperations operations
    :vartype workflow_run_action_repetitions_request_histories:
     azure.mgmt.logic.aio.operations.WorkflowRunActionRepetitionsRequestHistoriesOperations
    :ivar workflow_run_action_request_histories: WorkflowRunActionRequestHistoriesOperations
     operations
    :vartype workflow_run_action_request_histories:
     azure.mgmt.logic.aio.operations.WorkflowRunActionRequestHistoriesOperations
    :ivar workflow_run_action_scope_repetitions: WorkflowRunActionScopeRepetitionsOperations
     operations
    :vartype workflow_run_action_scope_repetitions:
     azure.mgmt.logic.aio.operations.WorkflowRunActionScopeRepetitionsOperations
    :ivar workflow_run_operations: WorkflowRunOperationsOperations operations
    :vartype workflow_run_operations:
     azure.mgmt.logic.aio.operations.WorkflowRunOperationsOperations
    :ivar integration_accounts: IntegrationAccountsOperations operations
    :vartype integration_accounts: azure.mgmt.logic.aio.operations.IntegrationAccountsOperations
    :ivar integration_account_assemblies: IntegrationAccountAssembliesOperations operations
    :vartype integration_account_assemblies:
     azure.mgmt.logic.aio.operations.IntegrationAccountAssembliesOperations
    :ivar integration_account_batch_configurations: IntegrationAccountBatchConfigurationsOperations
     operations
    :vartype integration_account_batch_configurations:
     azure.mgmt.logic.aio.operations.IntegrationAccountBatchConfigurationsOperations
    :ivar integration_account_schemas: IntegrationAccountSchemasOperations operations
    :vartype integration_account_schemas:
     azure.mgmt.logic.aio.operations.IntegrationAccountSchemasOperations
    :ivar integration_account_maps: IntegrationAccountMapsOperations operations
    :vartype integration_account_maps:
     azure.mgmt.logic.aio.operations.IntegrationAccountMapsOperations
    :ivar integration_account_partners: IntegrationAccountPartnersOperations operations
    :vartype integration_account_partners:
     azure.mgmt.logic.aio.operations.IntegrationAccountPartnersOperations
    :ivar integration_account_agreements: IntegrationAccountAgreementsOperations operations
    :vartype integration_account_agreements:
     azure.mgmt.logic.aio.operations.IntegrationAccountAgreementsOperations
    :ivar integration_account_certificates: IntegrationAccountCertificatesOperations operations
    :vartype integration_account_certificates:
     azure.mgmt.logic.aio.operations.IntegrationAccountCertificatesOperations
    :ivar integration_account_sessions: IntegrationAccountSessionsOperations operations
    :vartype integration_account_sessions:
     azure.mgmt.logic.aio.operations.IntegrationAccountSessionsOperations
    :ivar integration_service_environments: IntegrationServiceEnvironmentsOperations operations
    :vartype integration_service_environments:
     azure.mgmt.logic.aio.operations.IntegrationServiceEnvironmentsOperations
    :ivar integration_service_environment_skus: IntegrationServiceEnvironmentSkusOperations
     operations
    :vartype integration_service_environment_skus:
     azure.mgmt.logic.aio.operations.IntegrationServiceEnvironmentSkusOperations
    :ivar integration_service_environment_network_health:
     IntegrationServiceEnvironmentNetworkHealthOperations operations
    :vartype integration_service_environment_network_health:
     azure.mgmt.logic.aio.operations.IntegrationServiceEnvironmentNetworkHealthOperations
    :ivar integration_service_environment_managed_apis:
     IntegrationServiceEnvironmentManagedApisOperations operations
    :vartype integration_service_environment_managed_apis:
     azure.mgmt.logic.aio.operations.IntegrationServiceEnvironmentManagedApisOperations
    :ivar integration_service_environment_managed_api_operations:
     IntegrationServiceEnvironmentManagedApiOperationsOperations operations
    :vartype integration_service_environment_managed_api_operations:
     azure.mgmt.logic.aio.operations.IntegrationServiceEnvironmentManagedApiOperationsOperations
    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.logic.aio.operations.Operations
    :param credential: Credential needed for the client to connect to Azure. Required.
    :type credential: ~azure.core.credentials_async.AsyncTokenCredential
    :param subscription_id: The subscription id. Required.
    :type subscription_id: str
    :param base_url: Service URL. Default value is "https://management.azure.com".
    :type base_url: str
    :keyword api_version: Api Version. Default value is "2019-05-01". Note that overriding this
     default value may result in unsupported behavior.
    :paramtype api_version: str
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
     Retry-After header is present.
    """

    def __init__(
        self,
        credential: "AsyncTokenCredential",
        subscription_id: str,
        base_url: str = "https://management.azure.com",
        **kwargs: Any
    ) -> None:
        self._config = LogicManagementClientConfiguration(
            credential=credential, subscription_id=subscription_id, **kwargs
        )
        self._client = AsyncARMPipelineClient(base_url=base_url, config=self._config, **kwargs)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)
        self._serialize.client_side_validation = False
        self.workflows = WorkflowsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.workflow_versions = WorkflowVersionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.workflow_triggers = WorkflowTriggersOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.workflow_version_triggers = WorkflowVersionTriggersOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.workflow_trigger_histories = WorkflowTriggerHistoriesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.workflow_runs = WorkflowRunsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.workflow_run_actions = WorkflowRunActionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.workflow_run_action_repetitions = WorkflowRunActionRepetitionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.workflow_run_action_repetitions_request_histories = WorkflowRunActionRepetitionsRequestHistoriesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.workflow_run_action_request_histories = WorkflowRunActionRequestHistoriesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.workflow_run_action_scope_repetitions = WorkflowRunActionScopeRepetitionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.workflow_run_operations = WorkflowRunOperationsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.integration_accounts = IntegrationAccountsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.integration_account_assemblies = IntegrationAccountAssembliesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.integration_account_batch_configurations = IntegrationAccountBatchConfigurationsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.integration_account_schemas = IntegrationAccountSchemasOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.integration_account_maps = IntegrationAccountMapsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.integration_account_partners = IntegrationAccountPartnersOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.integration_account_agreements = IntegrationAccountAgreementsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.integration_account_certificates = IntegrationAccountCertificatesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.integration_account_sessions = IntegrationAccountSessionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.integration_service_environments = IntegrationServiceEnvironmentsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.integration_service_environment_skus = IntegrationServiceEnvironmentSkusOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.integration_service_environment_network_health = IntegrationServiceEnvironmentNetworkHealthOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.integration_service_environment_managed_apis = IntegrationServiceEnvironmentManagedApisOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.integration_service_environment_managed_api_operations = (
            IntegrationServiceEnvironmentManagedApiOperationsOperations(
                self._client, self._config, self._serialize, self._deserialize
            )
        )
        self.operations = Operations(self._client, self._config, self._serialize, self._deserialize)

    def _send_request(self, request: HttpRequest, **kwargs: Any) -> Awaitable[AsyncHttpResponse]:
        """Runs the network request through the client's chained policies.

        >>> from azure.core.rest import HttpRequest
        >>> request = HttpRequest("GET", "https://www.example.org/")
        <HttpRequest [GET], url: 'https://www.example.org/'>
        >>> response = await client._send_request(request)
        <AsyncHttpResponse: 200 OK>

        For more information on this code flow, see https://aka.ms/azsdk/dpcodegen/python/send_request

        :param request: The network request you want to make. Required.
        :type request: ~azure.core.rest.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to False.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.rest.AsyncHttpResponse
        """

        request_copy = deepcopy(request)
        request_copy.url = self._client.format_url(request_copy.url)
        return self._client.send_request(request_copy, **kwargs)

    async def close(self) -> None:
        await self._client.close()

    async def __aenter__(self) -> "LogicManagementClient":
        await self._client.__aenter__()
        return self

    async def __aexit__(self, *exc_details) -> None:
        await self._client.__aexit__(*exc_details)
