/* layla/layla_embedded.hpp
 * 
 * Copyright 2023 by Global Phasing Ltd.
 * Author: Jakub Smulski
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA
 */

#ifndef LAYLA_EMBEDDED_HPP
#define LAYLA_EMBEDDED_HPP
#include "state.hpp"
#include <rdkit/GraphMol/GraphMol.h>

namespace coot {

bool is_layla_initialized();
GtkApplicationWindow* initialize_layla(GtkApplication* app);
void deinitialize_layla();
void launch_layla();
void launch_layla(std::shared_ptr<RDKit::RWMol> mol);

}


#endif // LAYLA_GENERATORS_HPP