// Copyright 2018 JDCLOUD.COM
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// NOTE: This class is auto generated by the jdcloud code generator program.

package apis

import (
    "github.com/jdcloud-api/jdcloud-sdk-go/core"
    vpc "github.com/jdcloud-api/jdcloud-sdk-go/services/vpc/models"
)

type CreateVpcPeeringRequest struct {

    core.JDCloudRequest

    /* Region ID  */
    RegionId string `json:"regionId"`

    /* VpcPeering的名字,不为空。名称取值范围：1-32个中文、英文大小写的字母、数字和下划线分隔符  */
    VpcPeeringName string `json:"vpcPeeringName"`

    /* VpcPeering本端Vpc的Id  */
    VpcId string `json:"vpcId"`

    /* VpcPeering对端Vpc的Id  */
    RemoteVpcId string `json:"remoteVpcId"`

    /* VpcPeering 描述，取值范围：0-256个中文、英文大小写的字母、数字和下划线分隔符 (Optional) */
    Description *string `json:"description"`
}

/*
 * param regionId: Region ID (Required)
 * param vpcPeeringName: VpcPeering的名字,不为空。名称取值范围：1-32个中文、英文大小写的字母、数字和下划线分隔符 (Required)
 * param vpcId: VpcPeering本端Vpc的Id (Required)
 * param remoteVpcId: VpcPeering对端Vpc的Id (Required)
 *
 * @Deprecated, not compatible when mandatory parameters changed
 */
func NewCreateVpcPeeringRequest(
    regionId string,
    vpcPeeringName string,
    vpcId string,
    remoteVpcId string,
) *CreateVpcPeeringRequest {

	return &CreateVpcPeeringRequest{
        JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/vpcPeerings/",
			Method:  "POST",
			Header:  nil,
			Version: "v1",
		},
        RegionId: regionId,
        VpcPeeringName: vpcPeeringName,
        VpcId: vpcId,
        RemoteVpcId: remoteVpcId,
	}
}

/*
 * param regionId: Region ID (Required)
 * param vpcPeeringName: VpcPeering的名字,不为空。名称取值范围：1-32个中文、英文大小写的字母、数字和下划线分隔符 (Required)
 * param vpcId: VpcPeering本端Vpc的Id (Required)
 * param remoteVpcId: VpcPeering对端Vpc的Id (Required)
 * param description: VpcPeering 描述，取值范围：0-256个中文、英文大小写的字母、数字和下划线分隔符 (Optional)
 */
func NewCreateVpcPeeringRequestWithAllParams(
    regionId string,
    vpcPeeringName string,
    vpcId string,
    remoteVpcId string,
    description *string,
) *CreateVpcPeeringRequest {

    return &CreateVpcPeeringRequest{
        JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/vpcPeerings/",
            Method:  "POST",
            Header:  nil,
            Version: "v1",
        },
        RegionId: regionId,
        VpcPeeringName: vpcPeeringName,
        VpcId: vpcId,
        RemoteVpcId: remoteVpcId,
        Description: description,
    }
}

/* This constructor has better compatible ability when API parameters changed */
func NewCreateVpcPeeringRequestWithoutParam() *CreateVpcPeeringRequest {

    return &CreateVpcPeeringRequest{
            JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/vpcPeerings/",
            Method:  "POST",
            Header:  nil,
            Version: "v1",
        },
    }
}

/* param regionId: Region ID(Required) */
func (r *CreateVpcPeeringRequest) SetRegionId(regionId string) {
    r.RegionId = regionId
}

/* param vpcPeeringName: VpcPeering的名字,不为空。名称取值范围：1-32个中文、英文大小写的字母、数字和下划线分隔符(Required) */
func (r *CreateVpcPeeringRequest) SetVpcPeeringName(vpcPeeringName string) {
    r.VpcPeeringName = vpcPeeringName
}

/* param vpcId: VpcPeering本端Vpc的Id(Required) */
func (r *CreateVpcPeeringRequest) SetVpcId(vpcId string) {
    r.VpcId = vpcId
}

/* param remoteVpcId: VpcPeering对端Vpc的Id(Required) */
func (r *CreateVpcPeeringRequest) SetRemoteVpcId(remoteVpcId string) {
    r.RemoteVpcId = remoteVpcId
}

/* param description: VpcPeering 描述，取值范围：0-256个中文、英文大小写的字母、数字和下划线分隔符(Optional) */
func (r *CreateVpcPeeringRequest) SetDescription(description string) {
    r.Description = &description
}

// GetRegionId returns path parameter 'regionId' if exist,
// otherwise return empty string
func (r CreateVpcPeeringRequest) GetRegionId() string {
    return r.RegionId
}

type CreateVpcPeeringResponse struct {
    RequestID string `json:"requestId"`
    Error core.ErrorResponse `json:"error"`
    Result CreateVpcPeeringResult `json:"result"`
}

type CreateVpcPeeringResult struct {
    VpcPeering vpc.VpcPeering `json:"vpcPeering"`
}